/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.factory.ParserFactory;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class FormatterUtil {
    public static MessageParser.EntityLink getEntityLink(String fieldName, EntityInterface entity) {
        EntityReference entityReference = entity.getEntityReference();
        String entityType = entityReference.getType();
        String entityFQN = entityReference.getFullyQualifiedName();
        String arrayFieldName = null;
        String arrayFieldValue = null;
        if (fieldName.contains(".")) {
            String[] fieldNameParts = FullyQualifiedName.split(fieldName);
            fieldName = fieldNameParts[0];
            if (fieldNameParts.length == 3) {
                arrayFieldName = fieldNameParts[1];
                arrayFieldValue = fieldNameParts[2];
            } else if (fieldNameParts.length == 2) {
                arrayFieldName = fieldNameParts[1];
            }
        }
        return new MessageParser.EntityLink(entityType, entityFQN, fieldName, arrayFieldName, arrayFieldValue);
    }

    public static String getFieldValue(Object fieldValue) {
        if (CommonUtil.nullOrEmpty((Object)fieldValue)) {
            return "";
        }
        try {
            JsonValue json = JsonUtils.readJson(fieldValue.toString());
            if (json.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray jsonArray = json.asJsonArray();
                ArrayList<String> labels = new ArrayList<String>();
                for (JsonValue item : jsonArray) {
                    if (item.getValueType() == JsonValue.ValueType.OBJECT) {
                        Set keys = item.asJsonObject().keySet();
                        if (keys.contains("tagFQN")) {
                            labels.add(item.asJsonObject().getString("tagFQN"));
                            continue;
                        }
                        if (keys.contains("displayName")) {
                            labels.add(item.asJsonObject().getString("displayName"));
                            continue;
                        }
                        if (keys.contains("name")) {
                            labels.add(item.asJsonObject().getString("name"));
                            continue;
                        }
                        if (!keys.contains("constraintType")) continue;
                        labels.add(item.asJsonObject().getString("constraintType"));
                        continue;
                    }
                    if (item.getValueType() != JsonValue.ValueType.STRING) continue;
                    String label = item.toString().replaceAll("^\"|\"$", "");
                    labels.add(label.strip());
                }
                return String.join((CharSequence)", ", labels);
            }
            if (json.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject jsonObject = json.asJsonObject();
                Set keys = jsonObject.asJsonObject().keySet();
                if (keys.contains("displayName")) {
                    return jsonObject.asJsonObject().getString("displayName");
                }
                if (keys.contains("name")) {
                    return jsonObject.asJsonObject().getString("name");
                }
            }
        }
        catch (JsonParsingException jsonParsingException) {
            // empty catch block
        }
        return fieldValue.toString();
    }

    public static Set<String> getUpdatedField(ChangeEvent event) {
        HashSet<String> fields = new HashSet<String>();
        ChangeDescription description = event.getChangeDescription();
        if (description != null) {
            ArrayList fieldChanges = new ArrayList();
            fieldChanges.addAll(description.getFieldsAdded());
            fieldChanges.addAll(description.getFieldsUpdated());
            fieldChanges.addAll(description.getFieldsDeleted());
            fieldChanges.forEach(field -> {
                String fieldName = field.getName();
                if (fieldName.contains(".")) {
                    String[] tokens = fieldName.split("\\.");
                    fields.add(tokens[tokens.length - 1]);
                } else {
                    fields.add(fieldName);
                }
            });
        }
        return fields;
    }

    public static String transformMessage(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, CHANGE_TYPE changeType) {
        MessageParser.EntityLink link = FormatterUtil.getEntityLink(fieldChange.getName(), entity);
        String arrayFieldName = link.getArrayFieldName();
        String arrayFieldValue = link.getArrayFieldValue();
        String updatedField = fieldChange.getName();
        if (arrayFieldValue != null) {
            updatedField = String.format("%s.%s", arrayFieldName, arrayFieldValue);
        } else if (arrayFieldName != null) {
            updatedField = String.format("%s.%s", fieldChange.getName(), arrayFieldName);
        }
        String oldField = FormatterUtil.getFieldValue(fieldChange.getOldValue());
        String newField = FormatterUtil.getFieldValue(fieldChange.getNewValue());
        DefaultFieldFormatter fieldSpecificFormatter = CommonUtil.nullOrEmpty((String)arrayFieldValue) ? ParserFactory.getFieldParserObject(messageFormatter, oldField, newField, updatedField, link) : ParserFactory.getFieldParserObject(messageFormatter, oldField, newField, arrayFieldValue, link);
        String message = fieldSpecificFormatter.getFormattedMessage(changeType);
        return message;
    }

    public static Map<MessageParser.EntityLink, String> getFormattedMessages(MessageDecorator<?> messageFormatter, ChangeDescription changeDescription, EntityInterface entity) {
        List fieldsUpdated = changeDescription.getFieldsUpdated();
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, entity, fieldsUpdated, CHANGE_TYPE.UPDATE);
        List fieldsAdded = changeDescription.getFieldsAdded();
        List fieldsDeleted = changeDescription.getFieldsDeleted();
        if (fieldsAdded.isEmpty() || fieldsDeleted.isEmpty()) {
            if (!fieldsAdded.isEmpty()) {
                messages = FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, entity, fieldsAdded, CHANGE_TYPE.ADD);
            } else if (!fieldsDeleted.isEmpty()) {
                messages = FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, entity, fieldsDeleted, CHANGE_TYPE.DELETE);
            }
            return messages;
        }
        for (FieldChange field : fieldsDeleted) {
            Optional<FieldChange> addedField = fieldsAdded.stream().filter(f -> f.getName().equals(field.getName())).findAny();
            if (addedField.isPresent()) {
                String fieldName = field.getName();
                MessageParser.EntityLink link = FormatterUtil.getEntityLink(fieldName, entity);
                String message = ParserFactory.getEntityParser(link.getEntityType()).format(messageFormatter, new FieldChange().withName(fieldName).withOldValue(field.getOldValue()).withNewValue(addedField.get().getNewValue()), entity, CHANGE_TYPE.UPDATE);
                messages.put(link, message);
                fieldsAdded = fieldsAdded.stream().filter(f -> !f.equals(addedField.get())).collect(Collectors.toList());
                continue;
            }
            messages.putAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, entity, Collections.singletonList(field), CHANGE_TYPE.DELETE));
        }
        if (!fieldsAdded.isEmpty()) {
            messages.putAll(FormatterUtil.getFormattedMessagesForAllFieldChange(messageFormatter, entity, fieldsAdded, CHANGE_TYPE.ADD));
        }
        return messages;
    }

    private static Map<MessageParser.EntityLink, String> getFormattedMessagesForAllFieldChange(MessageDecorator<?> messageFormatter, EntityInterface entity, List<FieldChange> fields, CHANGE_TYPE changeType) {
        HashMap<MessageParser.EntityLink, String> messages = new HashMap<MessageParser.EntityLink, String>();
        for (FieldChange field : fields) {
            MessageParser.EntityLink link = FormatterUtil.getEntityLink(field.getName(), entity);
            String message = ParserFactory.getEntityParser(link.getEntityType()).format(messageFormatter, field, entity, changeType);
            messages.put(link, message);
        }
        return messages;
    }

    public static ChangeEvent getChangeEventFromResponseContext(ContainerResponseContext responseContext, String updateBy, String method) {
        if (method.equals("GET")) {
            return null;
        }
        if (responseContext.getEntity() == null) {
            return null;
        }
        int responseCode = responseContext.getStatus();
        String changeType = responseContext.getHeaderString("X-OpenMetadata-Change");
        if (responseCode == Response.Status.CREATED.getStatusCode() && !"entityFieldsChanged".equals(changeType) && !responseContext.getEntity().getClass().equals(Thread.class)) {
            if (responseContext.getEntity() instanceof EntityInterface) {
                EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
                EntityReference entityReference = entityInterface.getEntityReference();
                String entityType = entityReference.getType();
                String entityFQN = entityReference.getFullyQualifiedName();
                return FormatterUtil.getChangeEvent(updateBy, EventType.ENTITY_CREATED, entityType, entityInterface).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
            }
            return null;
        }
        if (changeType == null || "entityNoChange".equals(changeType)) {
            return null;
        }
        if (changeType.equals("Logical Test Cases Added to Test Suite")) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = "testCase";
            String entityFQN = entityReference.getFullyQualifiedName();
            return FormatterUtil.getChangeEvent(updateBy, EventType.ENTITY_UPDATED, entityType, entityInterface).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        if (changeType.equals("entityUpdated") || changeType.equals("entitySoftDeleted")) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = entityReference.getType();
            String entityFQN = entityReference.getFullyQualifiedName();
            EventType eventType = EventType.fromValue((String)changeType);
            return FormatterUtil.getChangeEvent(updateBy, eventType, entityType, entityInterface).withPreviousVersion(entityInterface.getChangeDescription().getPreviousVersion()).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        if (changeType.equals("entityFieldsChanged")) {
            return (ChangeEvent)responseContext.getEntity();
        }
        if (changeType.equals("entityDeleted")) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = entityReference.getType();
            String entityFQN = entityReference.getFullyQualifiedName();
            return FormatterUtil.getChangeEvent(updateBy, EventType.ENTITY_DELETED, entityType, entityInterface).withPreviousVersion(entityInterface.getVersion()).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        return null;
    }

    private static ChangeEvent getChangeEvent(String updateBy, EventType eventType, String entityType, EntityInterface entityInterface) {
        return new ChangeEvent().withEventType(eventType).withEntityId(entityInterface.getId()).withEntityType(entityType).withUserName(updateBy).withTimestamp(entityInterface.getUpdatedAt()).withChangeDescription(entityInterface.getChangeDescription()).withCurrentVersion(entityInterface.getVersion());
    }

    public static enum CHANGE_TYPE {
        ADD,
        UPDATE,
        DELETE;

    }
}

