/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRepository
extends EntityRepository<Chart> {
    private static final Logger LOG = LoggerFactory.getLogger(ChartRepository.class);
    private static final String CHART_UPDATE_FIELDS = "owner";
    private static final String CHART_PATCH_FIELDS = "owner,tags";

    public ChartRepository(CollectionDAO dao) {
        super("v1/charts/", "chart", Chart.class, dao.chartDAO(), dao, CHART_PATCH_FIELDS, CHART_UPDATE_FIELDS);
    }

    @Override
    public void setFullyQualifiedName(Chart chart) {
        chart.setFullyQualifiedName(FullyQualifiedName.add(chart.getService().getFullyQualifiedName(), chart.getName()));
    }

    @Override
    public void prepare(Chart chart) throws IOException {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(chart.getService(), "", Include.ALL);
        chart.setService(dashboardService.getEntityReference());
        chart.setServiceType(dashboardService.getServiceType());
    }

    @Override
    public void storeEntity(Chart chart, boolean update) throws JsonProcessingException {
        EntityReference service = chart.getService();
        chart.withService(null);
        this.store(chart, update);
        chart.withService(service);
    }

    @Override
    public void storeRelationships(Chart chart) {
        EntityReference service = chart.getService();
        this.addRelationship(service.getId(), chart.getId(), service.getType(), "chart", Relationship.CONTAINS);
    }

    @Override
    public Chart setFields(Chart chart, EntityUtil.Fields fields) throws IOException {
        chart.setService(this.getContainer(chart.getId()));
        return chart.withFollowers(fields.contains("followers") ? this.getFollowers(chart) : null);
    }

    @Override
    public void restorePatchAttributes(Chart original, Chart updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Chart original, Chart updated, EntityRepository.Operation operation) {
        return new ChartUpdater(original, updated, operation);
    }

    public class ChartUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public ChartUpdater(Chart chart, Chart updated, EntityRepository.Operation operation) {
            super((EntityRepository)ChartRepository.this, (EntityInterface)chart, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("chartType", ((Chart)this.original).getChartType(), ((Chart)this.updated).getChartType());
            this.recordChange("sourceUrl", ((Chart)this.original).getSourceUrl(), ((Chart)this.updated).getSourceUrl());
        }
    }
}

