/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationRepository
extends EntityRepository<Classification> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationRepository.class);

    public ClassificationRepository(CollectionDAO dao) {
        super("/v1/classifications/", "classification", Classification.class, dao.classificationDAO(), dao, "", "");
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Classification original, Classification updated, EntityRepository.Operation operation) {
        return new ClassificationUpdater(original, updated, operation);
    }

    @Override
    public Classification setFields(Classification category, EntityUtil.Fields fields) {
        category.withTermCount(fields.contains("termCount") ? Integer.valueOf(this.getTermCount(category)) : null);
        return category.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(category) : null);
    }

    @Override
    public void prepare(Classification entity) {
    }

    @Override
    public void storeEntity(Classification category, boolean update) throws IOException {
        this.store(category, update);
    }

    @Override
    public void storeRelationships(Classification entity) {
    }

    private int getTermCount(Classification category) {
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("parent", category.getName());
        return this.daoCollection.tagDAO().listCount(filter);
    }

    private Integer getUsageCount(Classification classification) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.CLASSIFICATION.ordinal(), FullyQualifiedName.buildHash(classification.getName()));
    }

    @Transaction
    public Classification delete(UriInfo uriInfo, UUID id) throws IOException {
        Classification classification = (Classification)this.get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS, Include.NON_DELETED);
        this.checkSystemEntityDeletion(classification);
        this.dao.delete(id.toString());
        this.daoCollection.tagDAO().deleteTagsByPrefix(classification.getName());
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.CLASSIFICATION.ordinal(), classification.getName());
        this.daoCollection.tagUsageDAO().deleteTagLabelsByPrefix(TagLabel.TagSource.CLASSIFICATION.ordinal(), classification.getName());
        return classification;
    }

    public class ClassificationUpdater
    extends EntityRepository.EntityUpdater {
        public ClassificationUpdater(Classification original, Classification updated, EntityRepository.Operation operation) {
            super((EntityRepository)ClassificationRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("mutuallyExclusive", ((Classification)this.original).getMutuallyExclusive(), ((Classification)this.updated).getMutuallyExclusive());
            this.recordChange("disabled,", ((Classification)this.original).getDisabled(), ((Classification)this.updated).getDisabled());
            this.updateName((Classification)this.original, (Classification)this.updated);
        }

        public void updateName(Classification original, Classification updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), ClassificationRepository.this.entityType));
                }
                LOG.info("Classification name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                ClassificationRepository.this.daoCollection.tagDAO().updateFqn(original.getName(), updated.getName());
                ClassificationRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
            }
        }
    }

    public static class TagLabelMapper
    implements RowMapper<TagLabel> {
        public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
            return new TagLabel().withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
        }
    }
}

