/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.connections.TestConnectionDefinition;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;

public class TestConnectionDefinitionRepository
extends EntityRepository<TestConnectionDefinition> {
    private static final String UPDATE_FIELDS = "steps";
    private static final String PATCH_FIELDS = "";

    public TestConnectionDefinitionRepository(CollectionDAO dao) {
        super("/v1/services/testConnectionDefinitions", "testConnectionDefinition", TestConnectionDefinition.class, dao.testConnectionDefinitionDAO(), dao, PATCH_FIELDS, UPDATE_FIELDS);
    }

    @Override
    public void setFullyQualifiedName(TestConnectionDefinition entity) {
        entity.setFullyQualifiedName(entity.getName() + ".testConnectionDefinition");
    }

    @Override
    public TestConnectionDefinition setFields(TestConnectionDefinition entity, EntityUtil.Fields fields) throws IOException {
        return entity.withOwner(fields.contains("owner") ? this.getOwner(entity) : null);
    }

    @Override
    public void prepare(TestConnectionDefinition entity) {
        if (CommonUtil.nullOrEmpty((List)entity.getSteps())) {
            throw new IllegalArgumentException("Steps must not be empty");
        }
    }

    @Override
    public void storeEntity(TestConnectionDefinition entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        entity.withOwner(null).withHref(null);
        this.store(entity, update);
        entity.withOwner(owner);
    }

    @Override
    public void storeRelationships(TestConnectionDefinition entity) {
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestConnectionDefinition original, TestConnectionDefinition updated, EntityRepository.Operation operation) {
        return new TestConnectionDefinitionUpdater(original, updated, operation);
    }

    public class TestConnectionDefinitionUpdater
    extends EntityRepository.EntityUpdater {
        public TestConnectionDefinitionUpdater(TestConnectionDefinition original, TestConnectionDefinition updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestConnectionDefinitionRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange(TestConnectionDefinitionRepository.UPDATE_FIELDS, ((TestConnectionDefinition)this.original).getSteps(), ((TestConnectionDefinition)this.updated).getSteps(), true);
        }
    }
}

