/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.api.tests.CreateTestSuite;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.connections.TestConnectionDefinition;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.migration.api.MigrationStep;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);

    public static <T extends EntityInterface> void updateFQNHashForEntity(Class<T> clazz, EntityDAO<T> dao) {
        List<String> jsons = dao.listAfter(new ListFilter(Include.ALL), Integer.MAX_VALUE, "");
        for (String json : jsons) {
            EntityInterface entity = (EntityInterface)JsonUtils.readValue(json, clazz);
            dao.update(entity.getId(), FullyQualifiedName.buildHash(entity.getFullyQualifiedName()), JsonUtils.pojoToJson(entity));
        }
    }

    public static MigrationDAO.ServerMigrationSQLTable buildServerMigrationTable(String version, String statement) {
        MigrationDAO.ServerMigrationSQLTable result = new MigrationDAO.ServerMigrationSQLTable();
        result.setVersion(String.valueOf(version));
        result.setSqlStatement(statement);
        result.setCheckSum(EntityUtil.hash(statement));
        return result;
    }

    public static List<MigrationDAO.ServerMigrationSQLTable> addInListIfToBeExecuted(String version, Set<String> lookUp, List<String> queries) {
        ArrayList<MigrationDAO.ServerMigrationSQLTable> result = new ArrayList<MigrationDAO.ServerMigrationSQLTable>();
        for (String query : queries) {
            MigrationDAO.ServerMigrationSQLTable tableContent = MigrationUtil.buildServerMigrationTable(version, query);
            if (!lookUp.contains(tableContent.getCheckSum())) {
                result.add(tableContent);
                continue;
            }
            LOG.debug("Query will be skipped in Migration Step , as this has already been executed");
        }
        return result;
    }

    public static void dataMigrationFQNHashing(CollectionDAO collectionDAO) {
        MigrationUtil.updateFQNHashForEntity(Bot.class, collectionDAO.botDAO());
        MigrationUtil.updateFQNHashForEntity(Chart.class, collectionDAO.chartDAO());
        MigrationUtil.updateFQNHashForEntity(Classification.class, collectionDAO.classificationDAO());
        MigrationUtil.updateFQNHashForEntity(Container.class, collectionDAO.containerDAO());
        MigrationUtil.updateFQNHashForEntity(DashboardDataModel.class, collectionDAO.dashboardDataModelDAO());
        MigrationUtil.updateFQNHashForEntity(Dashboard.class, collectionDAO.dashboardDAO());
        MigrationUtil.updateFQNHashForEntity(DashboardService.class, collectionDAO.dashboardServiceDAO());
        MigrationUtil.updateFQNHashForEntity(DataInsightChart.class, collectionDAO.dataInsightChartDAO());
        MigrationUtil.updateFQNHashForEntity(Database.class, collectionDAO.databaseDAO());
        MigrationUtil.updateFQNHashForEntity(DatabaseSchema.class, collectionDAO.databaseSchemaDAO());
        MigrationUtil.updateFQNHashForEntity(DatabaseService.class, collectionDAO.dbServiceDAO());
        MigrationUtil.updateFQNHashForEntity(EventSubscription.class, collectionDAO.eventSubscriptionDAO());
        MigrationUtil.updateFQNHashForEntity(Glossary.class, collectionDAO.glossaryDAO());
        MigrationUtil.updateFQNHashForEntity(GlossaryTerm.class, collectionDAO.glossaryTermDAO());
        MigrationUtil.updateFQNHashForEntity(IngestionPipeline.class, collectionDAO.ingestionPipelineDAO());
        MigrationUtil.updateFQNHashForEntity(Kpi.class, collectionDAO.kpiDAO());
        MigrationUtil.updateFQNHashForEntity(MessagingService.class, collectionDAO.messagingServiceDAO());
        MigrationUtil.updateFQNHashForEntity(MetadataService.class, collectionDAO.metadataServiceDAO());
        MigrationUtil.updateFQNHashForEntity(Metrics.class, collectionDAO.metricsDAO());
        MigrationUtil.updateFQNHashForEntity(MlModel.class, collectionDAO.mlModelDAO());
        MigrationUtil.updateFQNHashForEntity(MlModelService.class, collectionDAO.mlModelServiceDAO());
        MigrationUtil.updateFQNHashForEntity(Pipeline.class, collectionDAO.pipelineDAO());
        MigrationUtil.updateFQNHashForEntity(PipelineService.class, collectionDAO.pipelineServiceDAO());
        MigrationUtil.updateFQNHashForEntity(Policy.class, collectionDAO.policyDAO());
        MigrationUtil.updateFQNHashForEntity(Query.class, collectionDAO.queryDAO());
        MigrationUtil.updateFQNHashForEntity(Report.class, collectionDAO.reportDAO());
        MigrationUtil.updateFQNHashForEntity(Role.class, collectionDAO.roleDAO());
        MigrationUtil.updateFQNHashForEntity(StorageService.class, collectionDAO.storageServiceDAO());
        MigrationUtil.updateFQNHashForEntity(Table.class, collectionDAO.tableDAO());
        MigrationUtil.updateFQNHashForEntity(Tag.class, collectionDAO.tagDAO());
        MigrationUtil.updateFQNHashForEntity(Team.class, collectionDAO.teamDAO());
        MigrationUtil.updateFQNHashForEntity(TestCase.class, collectionDAO.testCaseDAO());
        MigrationUtil.updateFQNHashForEntity(TestConnectionDefinition.class, collectionDAO.testConnectionDefinitionDAO());
        MigrationUtil.updateFQNHashForEntity(TestDefinition.class, collectionDAO.testDefinitionDAO());
        MigrationUtil.updateFQNHashForEntity(TestSuite.class, collectionDAO.testSuiteDAO());
        MigrationUtil.updateFQNHashForEntity(Topic.class, collectionDAO.topicDAO());
        MigrationUtil.updateFQNHashForEntity(Type.class, collectionDAO.typeEntityDAO());
        MigrationUtil.updateFQNHashForEntity(User.class, collectionDAO.userDAO());
        MigrationUtil.updateFQNHashForEntity(WebAnalyticEvent.class, collectionDAO.webAnalyticEventDAO());
        MigrationUtil.updateFQNHashForEntity(Workflow.class, collectionDAO.workflowDAO());
        MigrationUtil.updateFQNHashForFieldRelationship(collectionDAO);
        MigrationUtil.updateFQNHashEntityExtensionTimeSeries(collectionDAO);
        MigrationUtil.updateFQNHashTagUsage(collectionDAO);
    }

    private static void updateFQNHashForFieldRelationship(CollectionDAO collectionDAO) {
        List<CollectionDAO.FieldRelationshipDAO.FieldRelationship> fieldRelationships = collectionDAO.fieldRelationshipDAO().listAll();
        for (CollectionDAO.FieldRelationshipDAO.FieldRelationship fieldRelationship : fieldRelationships) {
            if (!CommonUtil.nullOrEmpty((String)fieldRelationship.getFromFQNHash()) || !CommonUtil.nullOrEmpty((String)fieldRelationship.getToFQNHash())) continue;
            collectionDAO.fieldRelationshipDAO().upsertFQNHash(FullyQualifiedName.buildHash(fieldRelationship.getFromFQN()), FullyQualifiedName.buildHash(fieldRelationship.getToFQN()), fieldRelationship.getFromFQN(), fieldRelationship.getToFQN(), fieldRelationship.getFromType(), fieldRelationship.getToType(), fieldRelationship.getRelation(), fieldRelationship.getJsonSchema(), fieldRelationship.getJson());
        }
    }

    private static void updateFQNHashEntityExtensionTimeSeries(CollectionDAO collectionDAO) {
        List<CollectionDAO.EntityExtensionTimeSeriesDAO.EntityExtensionTimeSeriesTable> timeSeriesTables = collectionDAO.entityExtensionTimeSeriesDao().listAll();
        for (CollectionDAO.EntityExtensionTimeSeriesDAO.EntityExtensionTimeSeriesTable timeSeries : timeSeriesTables) {
            if (!CommonUtil.nullOrEmpty((String)timeSeries.getEntityFQNHash())) continue;
            collectionDAO.entityExtensionTimeSeriesDao().updateEntityFQNHash(FullyQualifiedName.buildHash(timeSeries.getEntityFQN()), timeSeries.getEntityFQN(), timeSeries.getExtension(), timeSeries.getTimestamp());
        }
    }

    public static void updateFQNHashTagUsage(CollectionDAO collectionDAO) {
        List<CollectionDAO.TagUsageDAO.TagLabelMigration> tagLabelMigrationList = collectionDAO.tagUsageDAO().listAll();
        for (CollectionDAO.TagUsageDAO.TagLabelMigration tagLabel : tagLabelMigrationList) {
            if (!CommonUtil.nullOrEmpty((String)tagLabel.getTagFQNHash()) || !CommonUtil.nullOrEmpty((String)tagLabel.getTargetFQNHash())) continue;
            collectionDAO.tagUsageDAO().upsertFQNHash(tagLabel.getSource(), tagLabel.getTagFQN(), FullyQualifiedName.buildHash(tagLabel.getTagFQN()), FullyQualifiedName.buildHash(tagLabel.getTargetFQN()), tagLabel.getLabelType(), tagLabel.getState(), tagLabel.getTargetFQN());
        }
    }

    public static void performSqlExecutionAndUpdation(MigrationStep step, MigrationDAO migrationDAO, Handle handle, List<String> queryList) {
        HashSet<String> executedSQLChecksums = new HashSet<String>(migrationDAO.getServerMigrationSQLWithVersion(String.valueOf(step.getMigrationVersion())));
        List<MigrationDAO.ServerMigrationSQLTable> toBeExecuted = MigrationUtil.addInListIfToBeExecuted(String.valueOf(step.getMigrationVersion()), executedSQLChecksums, queryList);
        for (MigrationDAO.ServerMigrationSQLTable tableData : toBeExecuted) {
            handle.execute(tableData.getSqlStatement(), new Object[0]);
            migrationDAO.upsertServerMigrationSQL(tableData.getVersion(), tableData.getSqlStatement(), tableData.getCheckSum());
        }
    }

    public static TestSuite getTestSuite(CollectionDAO dao, CreateTestSuite create, String user) throws IOException {
        TestSuite testSuite = MigrationUtil.copy(new TestSuite(), (CreateEntity)create, user).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withName(create.getName());
        if (create.getExecutableEntityReference() != null) {
            TableRepository tableRepository = new TableRepository(dao);
            Table table = JsonUtils.readValue(tableRepository.getDao().findJsonByFqn(create.getExecutableEntityReference(), Include.ALL), Table.class);
            EntityReference entityReference = new EntityReference().withId(table.getId()).withFullyQualifiedName(table.getFullyQualifiedName()).withName(table.getName()).withType("table");
            testSuite.setExecutableEntityReference(entityReference);
        }
        return testSuite;
    }

    public static TestSuite copy(TestSuite entity, CreateEntity request, String updatedBy) throws IOException {
        entity.setId(UUID.randomUUID());
        entity.setName(request.getName());
        entity.setDisplayName(request.getDisplayName());
        entity.setDescription(request.getDescription());
        entity.setExtension(request.getExtension());
        entity.setUpdatedBy(updatedBy);
        entity.setOwner(null);
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    public static void testSuitesMigration(CollectionDAO collectionDAO) {
        IngestionPipelineRepository ingestionPipelineRepository = new IngestionPipelineRepository(collectionDAO);
        TestSuiteRepository testSuiteRepository = new TestSuiteRepository(collectionDAO);
        TestCaseRepository testCaseRepository = new TestCaseRepository(collectionDAO);
        List testCases = testCaseRepository.listAll(new EntityUtil.Fields(List.of("id")), new ListFilter(Include.ALL));
        for (TestCase test : testCases) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
            String testSuiteFqn = entityLink.getEntityFQN() + ".testSuite";
            try {
                TestSuite stored = (TestSuite)testSuiteRepository.getByName(null, FullyQualifiedName.quoteName(testSuiteFqn), new EntityUtil.Fields(List.of("id")), Include.ALL);
                testSuiteRepository.addRelationship(stored.getId(), test.getId(), "testSuite", "testCase", Relationship.CONTAINS);
            }
            catch (EntityNotFoundException ex) {
                TestSuite newExecutableTestSuite = MigrationUtil.getTestSuite(collectionDAO, new CreateTestSuite().withName(testSuiteFqn).withExecutableEntityReference(entityLink.getEntityFQN()), "ingestion-bot").withExecutable(Boolean.valueOf(false));
                TestSuite testSuitePutResponse = testSuiteRepository.create(null, newExecutableTestSuite);
                testSuiteRepository.addRelationship(newExecutableTestSuite.getExecutableEntityReference().getId(), newExecutableTestSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
                testSuiteRepository.addRelationship(newExecutableTestSuite.getId(), test.getId(), "testSuite", "testCase", Relationship.CONTAINS);
                TestSuite temp = (TestSuite)testSuiteRepository.getDao().findEntityByName(FullyQualifiedName.quoteName(newExecutableTestSuite.getName()));
                temp.setExecutable(Boolean.valueOf(true));
                testSuiteRepository.getDao().update((EntityInterface)temp);
            }
        }
        ListFilter filter = new ListFilter(Include.ALL);
        filter.addQueryParam("testSuiteType", "logical");
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(List.of("id")), filter);
        for (TestSuite testSuiteRecord : testSuites) {
            TestSuite temp = (TestSuite)testSuiteRepository.getDao().findEntityById(testSuiteRecord.getId());
            if (Boolean.FALSE.equals(temp.getExecutable())) {
                temp.setExecutable(Boolean.valueOf(false));
                testSuiteRepository.getDao().update((EntityInterface)temp);
            }
            try {
                List<CollectionDAO.EntityRelationshipRecord> ingestionPipelineRecords = collectionDAO.relationshipDAO().findTo(testSuiteRecord.getId().toString(), "testSuite", Relationship.CONTAINS.ordinal(), "ingestionPipeline");
                for (CollectionDAO.EntityRelationshipRecord ingestionRecord : ingestionPipelineRecords) {
                    collectionDAO.relationshipDAO().deleteAll(ingestionRecord.getId().toString(), "ingestionPipeline");
                    ingestionPipelineRepository.getDao().delete(ingestionRecord.getId().toString());
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
        }
    }
}

