/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityResource<T extends EntityInterface, K extends EntityRepository<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    protected final Class<T> entityClass;
    protected final String entityType;
    protected final List<String> allowedFields;
    protected final K repository;
    protected final Authorizer authorizer;
    protected final Map<String, MetadataOperation> fieldsToViewOperations = new HashMap<String, MetadataOperation>();
    public static final MetadataOperation[] VIEW_ALL_OPERATIONS = new MetadataOperation[]{MetadataOperation.VIEW_ALL};
    public static final MetadataOperation[] VIEW_BASIC_OPERATIONS = new MetadataOperation[]{MetadataOperation.VIEW_BASIC};

    protected EntityResource(Class<T> entityClass, K repository, Authorizer authorizer) {
        this.entityClass = entityClass;
        this.entityType = ((EntityRepository)repository).getEntityType();
        this.allowedFields = ((EntityRepository)repository).getAllowedFields();
        this.repository = repository;
        this.authorizer = authorizer;
        this.addViewOperation("owner,followers,tags,extension", MetadataOperation.VIEW_BASIC);
        Entity.registerEntity(entityClass, this.entityType, repository, this.getEntitySpecificOperations());
    }

    public void initialize(OpenMetadataApplicationConfig config) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
    }

    protected void upgrade() throws IOException {
    }

    public final EntityUtil.Fields getFields(String fields) {
        return ((EntityRepository)this.repository).getFields(fields);
    }

    public abstract T addHref(UriInfo var1, T var2);

    protected List<MetadataOperation> getEntitySpecificOperations() {
        return null;
    }

    public final ResultList<T> addHref(UriInfo uriInfo, ResultList<T> list) {
        CommonUtil.listOrEmpty(list.getData()).forEach(i -> this.addHref(uriInfo, i));
        return list;
    }

    public ResultList<T> listInternal(UriInfo uriInfo, SecurityContext securityContext, String fieldsParam, ListFilter filter, int limitParam, String before, String after) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext listOperationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.listInternal(uriInfo, securityContext, fields, filter, limitParam, before, after, listOperationContext, this.getResourceContext());
    }

    public ResultList<T> listInternal(UriInfo uriInfo, SecurityContext securityContext, EntityUtil.Fields fields, ListFilter filter, int limitParam, String before, String after, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        RestUtil.validateCursors(before, after);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        ResultList resultList = before != null ? ((EntityRepository)this.repository).listBefore(uriInfo, fields, filter, limitParam, before) : ((EntityRepository)this.repository).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, resultList);
    }

    public T getInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, String fieldsParam, Include include) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.getInternal(uriInfo, securityContext, id, fields, include, operationContext, this.getResourceContextById(id));
    }

    public T getInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, EntityUtil.Fields fields, Include include, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.addHref(uriInfo, ((EntityRepository)this.repository).get(uriInfo, id, fields, include));
    }

    public T getVersionInternal(SecurityContext securityContext, UUID id, String version) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_BASIC);
        return this.getVersionInternal(securityContext, id, version, operationContext, this.getResourceContextById(id));
    }

    public T getVersionInternal(SecurityContext securityContext, UUID id, String version, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((EntityRepository)this.repository).getVersion(id, version);
    }

    protected EntityHistory listVersionsInternal(SecurityContext securityContext, UUID id) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_BASIC);
        return this.listVersionsInternal(securityContext, id, operationContext, this.getResourceContextById(id));
    }

    protected EntityHistory listVersionsInternal(SecurityContext securityContext, UUID id, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((EntityRepository)this.repository).listVersions(id);
    }

    public T getByNameInternal(UriInfo uriInfo, SecurityContext securityContext, String name, String fieldsParam, Include include) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext(this.entityType, this.getViewOperations(fields));
        return this.getByNameInternal(uriInfo, securityContext, name, fields, include, operationContext, this.getResourceContextByName(name));
    }

    public T getByNameInternal(UriInfo uriInfo, SecurityContext securityContext, String name, EntityUtil.Fields fields, Include include, OperationContext operationContext, ResourceContextInterface resourceContext) throws IOException {
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.addHref(uriInfo, ((EntityRepository)this.repository).getByName(uriInfo, name, fields, include));
    }

    public Response create(UriInfo uriInfo, SecurityContext securityContext, T entity) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContext());
        entity = this.addHref(uriInfo, ((EntityRepository)this.repository).create(uriInfo, entity));
        LOG.info("Created {}:{}", (Object)Entity.getEntityTypeFromObject(entity), (Object)entity.getId());
        return Response.created((URI)entity.getHref()).entity(entity).build();
    }

    public Response createOrUpdate(UriInfo uriInfo, SecurityContext securityContext, T entity) throws IOException {
        ((EntityRepository)this.repository).prepareInternal(entity);
        ResourceContext resourceContext = this.getResourceContextByName(entity.getFullyQualifiedName());
        OperationContext operationContext = new OperationContext(this.entityType, EntityUtil.createOrUpdateOperation(resourceContext));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        RestUtil.PutResponse<T> response = ((EntityRepository)this.repository).createOrUpdate(uriInfo, entity);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        return response.toResponse();
    }

    public Response patchInternal(UriInfo uriInfo, SecurityContext securityContext, UUID id, JsonPatch patch) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, patch);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.PatchResponse response = ((EntityRepository)this.repository).patch(uriInfo, id, securityContext.getUserPrincipal().getName(), patch);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        return response.toResponse();
    }

    public Response delete(UriInfo uriInfo, SecurityContext securityContext, UUID id, boolean recursive, boolean hardDelete) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.DeleteResponse<UUID> response = ((EntityRepository)this.repository).delete(securityContext.getUserPrincipal().getName(), (UUID)id, recursive, hardDelete);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        return response.toResponse();
    }

    public Response deleteByName(UriInfo uriInfo, SecurityContext securityContext, String name, boolean recursive, boolean hardDelete) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        RestUtil.DeleteResponse response = ((EntityRepository)this.repository).deleteByName(securityContext.getUserPrincipal().getName(), name, recursive, hardDelete);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        return response.toResponse();
    }

    public Response restoreEntity(UriInfo uriInfo, SecurityContext securityContext, UUID id) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.PutResponse response = ((EntityRepository)this.repository).restoreEntity(securityContext.getUserPrincipal().getName(), this.entityType, id);
        this.addHref(uriInfo, (EntityInterface)response.getEntity());
        LOG.info("Restored {}:{}", (Object)Entity.getEntityTypeFromObject(response.getEntity()), (Object)((EntityInterface)response.getEntity()).getId());
        return response.toResponse();
    }

    public String exportCsvInternal(SecurityContext securityContext, String name) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        return ((EntityRepository)this.repository).exportToCsv(name, securityContext.getUserPrincipal().getName());
    }

    protected CsvImportResult importCsvInternal(SecurityContext securityContext, String name, String csv, boolean dryRun) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        return ((EntityRepository)this.repository).importFromCsv(name, csv, dryRun, securityContext.getUserPrincipal().getName());
    }

    public T copy(T entity, CreateEntity request, String updatedBy) throws IOException {
        EntityReference owner = ((EntityRepository)this.repository).validateOwner(request.getOwner());
        entity.setId(UUID.randomUUID());
        entity.setName(request.getName());
        entity.setDisplayName(request.getDisplayName());
        entity.setDescription(request.getDescription());
        entity.setOwner(owner);
        entity.setExtension(request.getExtension());
        entity.setUpdatedBy(updatedBy);
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    protected ResourceContext getResourceContext() {
        return EntityResource.getResourceContext(this.entityType, this.repository).build();
    }

    protected ResourceContext getResourceContextById(UUID id) {
        return EntityResource.getResourceContext(this.entityType, this.repository).id(id).build();
    }

    protected ResourceContext getResourceContextByName(String name) {
        return EntityResource.getResourceContext(this.entityType, this.repository).name(name).build();
    }

    public static ResourceContext.ResourceContextBuilder getResourceContext(String entityType, EntityRepository<? extends EntityInterface> dao) {
        return ResourceContext.builder().resource(entityType).entityRepository(dao);
    }

    private MetadataOperation[] getViewOperations(EntityUtil.Fields fields) {
        if (fields.getFieldList().isEmpty()) {
            return VIEW_BASIC_OPERATIONS;
        }
        TreeSet<MetadataOperation> viewOperations = new TreeSet<MetadataOperation>();
        for (String field : fields.getFieldList()) {
            MetadataOperation operation = this.fieldsToViewOperations.get(field);
            if (operation == null) {
                return VIEW_ALL_OPERATIONS;
            }
            viewOperations.add(operation);
        }
        return viewOperations.toArray(new MetadataOperation[0]);
    }

    protected EntityReference getEntityReference(String entityType, String fqn) {
        return EntityUtil.getEntityReference(entityType, fqn);
    }

    protected List<EntityReference> getEntityReferences(String entityType, List<String> fqns) {
        return EntityUtil.getEntityReferences(entityType, fqns);
    }

    protected void addViewOperation(String fieldsParam, MetadataOperation operation) {
        String[] fields;
        for (String field : fields = fieldsParam.replace(" ", "").split(",")) {
            if (this.allowedFields.contains(field)) {
                this.fieldsToViewOperations.put(field, operation);
                continue;
            }
            if ("owner,followers,tags,extension".contains(field)) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
        }
    }

    public K getRepository() {
        return this.repository;
    }
}

