/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services;

import java.io.IOException;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.annotations.utils.AnnotationChecker;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.SecretsUtil;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public abstract class ServiceEntityResource<T extends ServiceEntityInterface, R extends ServiceEntityRepository<T, S>, S extends ServiceConnectionEntityInterface>
extends EntityResource<T, R> {
    private final ServiceEntityRepository<T, S> serviceEntityRepository;
    private final ServiceType serviceType;

    protected ServiceEntityResource(Class<T> entityClass, R serviceRepository, Authorizer authorizer, ServiceType serviceType) {
        super(entityClass, serviceRepository, authorizer);
        this.serviceEntityRepository = serviceRepository;
        this.serviceType = serviceType;
    }

    protected T decryptOrNullify(SecurityContext securityContext, T service) {
        if (service.getConnection() != null) {
            service.getConnection().setConfig(this.retrieveServiceConnectionConfig(service, this.authorizer.shouldMaskPasswords(securityContext)));
        }
        return service;
    }

    private Object retrieveServiceConnectionConfig(T service, boolean maskPassword) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        Object config = secretsManager.decryptServiceConnectionConfig(service.getConnection().getConfig(), this.extractServiceType(service), this.serviceType);
        if (maskPassword) {
            config = EntityMaskerFactory.getEntityMasker().maskServiceConnectionConfig(config, this.extractServiceType(service), this.serviceType);
        }
        return config;
    }

    protected ResultList<T> decryptOrNullify(SecurityContext securityContext, ResultList<T> services) {
        CommonUtil.listOrEmpty(services.getData()).forEach(service -> this.decryptOrNullify(securityContext, service));
        return services;
    }

    protected T nullifyRequiredConnectionParameters(T service) {
        Object connectionConfig = this.retrieveServiceConnectionConfig(service, true);
        if (AnnotationChecker.isExposedFieldPresent(connectionConfig.getClass())) {
            try {
                service.getConnection().setConfig(JsonUtils.toExposedEntity(connectionConfig, connectionConfig.getClass()));
                return service;
            }
            catch (IOException e) {
                throw new UnhandledServerException(e.getMessage(), e.getCause());
            }
        }
        return this.nullifyConnection(service);
    }

    protected T unmask(T service) {
        this.serviceEntityRepository.setFullyQualifiedName(service);
        ServiceEntityInterface originalService = (ServiceEntityInterface)this.serviceEntityRepository.findByNameOrNull(service.getFullyQualifiedName(), null, Include.NON_DELETED);
        String connectionType = this.extractServiceType(service);
        try {
            if (originalService != null && originalService.getConnection() != null) {
                Object serviceConnectionConfig = EntityMaskerFactory.getEntityMasker().unmaskServiceConnectionConfig(service.getConnection().getConfig(), originalService.getConnection().getConfig(), connectionType, this.serviceType);
                service.getConnection().setConfig(serviceConnectionConfig);
            }
            return service;
        }
        catch (Exception e) {
            String message = SecretsUtil.buildExceptionMessageConnectionMask(e.getMessage(), connectionType, false);
            if (message != null) {
                throw new InvalidServiceConnectionException(message);
            }
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to unmask connection instance of %s", connectionType));
        }
    }

    protected abstract T nullifyConnection(T var1);

    protected abstract String extractServiceType(T var1);

    public ServiceEntityRepository<T, S> getServiceEntityRepository() {
        return this.serviceEntityRepository;
    }
}

