/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import java.security.KeyStoreException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.type.IndexMappingLanguage;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.elasticSearch.ElasticSearchClientImpl;
import org.openmetadata.service.search.openSearch.OpenSearchClientImpl;
import org.openmetadata.service.util.SSLUtil;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IndexUtil.class);
    public static final String ELASTIC_SEARCH_EXTENSION = "service.eventPublisher";
    public static final String ELASTIC_SEARCH_ENTITY_FQN_STREAM = "eventPublisher:ElasticSearch:STREAM";
    public static final String MAPPINGS_KEY = "mappings";
    public static final String PROPERTIES_KEY = "properties";
    public static final String REASON_TRACE = "Reason: [%s] , Trace : [%s]";
    public static final String ENTITY_REPORT_DATA = "entityReportData";
    public static final String WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA = "webAnalyticEntityViewReportData";
    public static final String WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA = "webAnalyticUserActivityReportData";
    public static final Map<String, String> ENTITY_TYPE_TO_INDEX_MAP;
    private static final Map<ElasticSearchIndexDefinition.ElasticSearchIndexType, Set<String>> INDEX_TO_MAPPING_FIELDS_MAP;

    private IndexUtil() {
    }

    public static SearchClient getSearchClient(ElasticSearchConfiguration esConfig, CollectionDAO dao) {
        SearchClient client = esConfig.getSearchType().equals((Object)ElasticSearchConfiguration.SearchType.OPENSEARCH) ? new OpenSearchClientImpl(esConfig, dao) : new ElasticSearchClientImpl(esConfig, dao);
        return client;
    }

    public static void populateEsFieldsForIndexes(ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, IndexMappingLanguage lang) {
        if (!ReindexingUtil.isDataInsightIndex(elasticSearchIndexType.entityType)) {
            String indexData = ElasticSearchIndexDefinition.getIndexMapping(elasticSearchIndexType, lang.value());
            JSONObject object = new JSONObject(indexData).getJSONObject(MAPPINGS_KEY).getJSONObject(PROPERTIES_KEY);
            Set<String> keySet = Entity.getEntityRepository(elasticSearchIndexType.entityType).getCommonFields(object.keySet());
            INDEX_TO_MAPPING_FIELDS_MAP.put(elasticSearchIndexType, keySet);
        }
    }

    public static ElasticSearchIndexDefinition.ElasticSearchIndexType getIndexMappingByEntityType(String type) {
        if (type.equalsIgnoreCase("table")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("dashboard")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.DASHBOARD_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("pipeline")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.PIPELINE_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("topic")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.TOPIC_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("user")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("team")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.TEAM_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("glossary")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("mlmodel")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.MLMODEL_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("glossaryTerm")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("tag")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase(ENTITY_REPORT_DATA)) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase(WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA)) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase(WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA)) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase("container")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.CONTAINER_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("query")) {
            return ElasticSearchIndexDefinition.ElasticSearchIndexType.QUERY_SEARCH_INDEX;
        }
        throw new EventPublisherException("Failed to find index doc for type " + type);
    }

    public static Set<String> getIndexFields(String entityType, IndexMappingLanguage lang) {
        Set<String> fields = INDEX_TO_MAPPING_FIELDS_MAP.get((Object)IndexUtil.getIndexMappingByEntityType(entityType));
        if (fields != null) {
            return fields;
        }
        IndexUtil.populateEsFieldsForIndexes(IndexUtil.getIndexMappingByEntityType(entityType), lang);
        fields = INDEX_TO_MAPPING_FIELDS_MAP.get((Object)IndexUtil.getIndexMappingByEntityType(entityType));
        return fields;
    }

    public static String getContext(String type, String info) {
        return String.format("Failed While : %s %n Additional Info:  %s ", type, info);
    }

    public static SSLContext createElasticSearchSSLContext(ElasticSearchConfiguration elasticSearchConfiguration) throws KeyStoreException {
        if (elasticSearchConfiguration.getScheme().equals("https")) {
            return SSLUtil.createSSLContext(elasticSearchConfiguration.getTruststorePath(), elasticSearchConfiguration.getTruststorePassword(), "ElasticSearch");
        }
        return null;
    }

    static {
        INDEX_TO_MAPPING_FIELDS_MAP = new EnumMap<ElasticSearchIndexDefinition.ElasticSearchIndexType, Set<String>>(ElasticSearchIndexDefinition.ElasticSearchIndexType.class);
        ENTITY_TYPE_TO_INDEX_MAP = new HashMap<String, String>();
        for (ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexDefinition.ElasticSearchIndexType.values()) {
            ENTITY_TYPE_TO_INDEX_MAP.put(elasticSearchIndexType.entityType, elasticSearchIndexType.indexName);
        }
    }

    public static enum ElasticSearchIndexStatus {
        CREATED,
        NOT_CREATED,
        FAILED;

    }
}

