/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.openSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.DailyActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;

public class OsDailyActiveUsersAggregator
extends DataInsightAggregatorInterface {
    public OsDailyActiveUsersAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsOs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            long activeUsers = timestampBucket.getDocCount();
            data.add(new DailyActiveUsers().withTimestamp(timestamp).withActiveUsers(Integer.valueOf((int)activeUsers)));
        }
        return data;
    }
}

