/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.fasterxml.jackson.core.JsonProcessingException;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.teams.CreateUser;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.auth.ChangePasswordRequest;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.LoginRequest;
import org.openmetadata.schema.auth.PasswordResetRequest;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.RegistrationRequest;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.auth.TokenRefreshRequest;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.auth.AuthenticatorHandler;
import org.openmetadata.service.security.auth.LoginAttemptCache;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.TokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticator
implements AuthenticatorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticator.class);
    private static final int HASHING_COST = 12;
    private UserRepository userRepository;
    private TokenRepository tokenRepository;
    private LoginAttemptCache loginAttemptCache;
    private AuthorizerConfiguration authorizerConfiguration;
    private LoginConfiguration loginConfiguration;
    private boolean isEmailServiceEnabled;
    private boolean isSelfSignUpAvailable;

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        this.userRepository = new UserRepository((CollectionDAO)jdbi.onDemand(CollectionDAO.class));
        this.tokenRepository = new TokenRepository((CollectionDAO)jdbi.onDemand(CollectionDAO.class));
        this.authorizerConfiguration = config.getAuthorizerConfiguration();
        this.loginAttemptCache = new LoginAttemptCache(config);
        SmtpSettings smtpSettings = config.getSmtpSettings();
        this.isEmailServiceEnabled = smtpSettings != null && smtpSettings.getEnableSmtpServer() != false;
        this.isSelfSignUpAvailable = config.getAuthenticationConfiguration().getEnableSelfSignup();
        this.loginConfiguration = config.getApplicationConfiguration().getLoginConfig();
    }

    @Override
    public User registerUser(RegistrationRequest newRegistrationRequest) throws IOException {
        if (this.isSelfSignUpAvailable) {
            String newRegistrationRequestEmail = newRegistrationRequest.getEmail();
            String[] tokens = newRegistrationRequest.getEmail().split("@");
            String emailDomain = tokens[1];
            Set allowedDomains = this.authorizerConfiguration.getAllowedEmailRegistrationDomains();
            if (!allowedDomains.contains("all") && !allowedDomains.contains(emailDomain)) {
                LOG.error("Email with this Domain not allowed: " + newRegistrationRequestEmail);
                throw new BadRequestException("Email with the given domain is not allowed. Contact Administrator");
            }
            this.validateEmailAlreadyExists(newRegistrationRequestEmail);
            PasswordUtil.validatePassword(newRegistrationRequest.getPassword());
            LOG.info("Trying to register new user [" + newRegistrationRequestEmail + "]");
            User newUser = this.getUserFromRegistrationRequest(newRegistrationRequest);
            User registeredUser = this.userRepository.create(null, newUser);
            registeredUser.setAuthenticationMechanism(null);
            return registeredUser;
        }
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Signup is not supported.");
    }

    @Override
    public void confirmEmailRegistration(UriInfo uriInfo, String emailToken) throws IOException {
        EmailVerificationToken emailVerificationToken = (EmailVerificationToken)this.tokenRepository.findByToken(emailToken);
        User registeredUser = (User)this.userRepository.get(null, emailVerificationToken.getUserId(), this.userRepository.getFieldsWithUserAuth("*"));
        if (Boolean.TRUE.equals(registeredUser.getIsEmailVerified())) {
            LOG.info("User [{}] already registered.", (Object)emailToken);
            return;
        }
        if (emailVerificationToken.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, String.format("Email Verification Token %s is expired. Please issue a new request for email verification.", emailVerificationToken.getToken()));
        }
        registeredUser.setIsEmailVerified(Boolean.valueOf(true));
        this.userRepository.createOrUpdate(uriInfo, registeredUser);
        this.tokenRepository.deleteTokenByUserAndType(registeredUser.getId().toString(), TokenType.EMAIL_VERIFICATION.toString());
    }

    @Override
    public void resendRegistrationToken(UriInfo uriInfo, User registeredUser) throws IOException {
        this.tokenRepository.deleteTokenByUserAndType(registeredUser.getId().toString(), TokenType.EMAIL_VERIFICATION.toString());
        this.sendEmailVerification(uriInfo, registeredUser);
    }

    @Override
    public void sendEmailVerification(UriInfo uriInfo, User user) throws IOException {
        if (this.isEmailServiceEnabled) {
            UUID mailVerificationToken = UUID.randomUUID();
            EmailVerificationToken emailVerificationToken = TokenUtil.getEmailVerificationToken(user.getId(), mailVerificationToken);
            LOG.info("Generated Email verification token [" + mailVerificationToken + "]");
            String emailVerificationLink = String.format("%s/users/registrationConfirmation?user=%s&token=%s", EmailUtil.getInstance().buildBaseUrl(uriInfo.getRequestUri()), user.getFullyQualifiedName(), mailVerificationToken);
            try {
                EmailUtil.getInstance().sendEmailVerification(emailVerificationLink, user);
            }
            catch (TemplateException e) {
                LOG.error("Error in sending mail to the User : {}", (Object)e.getMessage(), (Object)e);
                throw new CustomExceptionMessage(424, "There is some issue in sending the Mail. Please contact your administrator.");
            }
            this.tokenRepository.insertToken((TokenInterface)emailVerificationToken);
        }
    }

    @Override
    public void sendPasswordResetLink(UriInfo uriInfo, User user, String subject, String templateFilePath) throws IOException {
        UUID mailVerificationToken = UUID.randomUUID();
        PasswordResetToken resetToken = TokenUtil.getPasswordResetToken(user.getId(), mailVerificationToken);
        LOG.info("Generated Password Reset verification token [" + mailVerificationToken + "]");
        String passwordResetLink = String.format("%s/users/password/reset?user=%s&token=%s", EmailUtil.getInstance().buildBaseUrl(uriInfo.getRequestUri()), user.getFullyQualifiedName(), mailVerificationToken);
        try {
            EmailUtil.getInstance().sendPasswordResetLink(passwordResetLink, user, subject, templateFilePath);
        }
        catch (TemplateException e) {
            LOG.error("Error in sending mail to the User : {}", (Object)e.getMessage(), (Object)e);
            throw new CustomExceptionMessage(424, "There is some issue in sending the Mail. Please contact your administrator.");
        }
        this.tokenRepository.deleteTokenByUserAndType(user.getId().toString(), TokenType.PASSWORD_RESET.toString());
        this.tokenRepository.insertToken((TokenInterface)resetToken);
    }

    @Override
    public void resetUserPasswordWithToken(UriInfo uriInfo, PasswordResetRequest request) throws IOException {
        String tokenID = request.getToken();
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.tokenRepository.findByToken(tokenID);
        List<String> fields = this.userRepository.getAllowedFieldsCopy();
        fields.add("authenticationMechanism");
        User storedUser = this.userRepository.getByName(uriInfo, request.getUsername(), new EntityUtil.Fields(fields, String.join((CharSequence)",", fields)));
        if (!passwordResetToken.getUserId().equals(storedUser.getId())) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Token does not belong to the user.");
        }
        this.verifyPasswordResetTokenExpiry(passwordResetToken);
        if (!request.getPassword().equals(request.getConfirmPassword())) {
            throw new IllegalArgumentException("Password and Confirm Password should match");
        }
        PasswordUtil.validatePassword(request.getPassword());
        String newHashedPwd = BCrypt.withDefaults().hashToString(12, request.getPassword().toCharArray());
        BasicAuthMechanism newAuthForUser = new BasicAuthMechanism().withPassword(newHashedPwd);
        storedUser.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthForUser));
        this.userRepository.createOrUpdate(uriInfo, storedUser);
        this.tokenRepository.deleteTokenByUserAndType(storedUser.getId().toString(), TokenType.PASSWORD_RESET.toString());
        try {
            EmailUtil.getInstance().sendAccountStatus(storedUser, "Update Password", "Change Successful");
        }
        catch (TemplateException ex) {
            LOG.error("Error in sending Password Change Mail to User. Reason : " + ex.getMessage(), (Throwable)ex);
            throw new CustomExceptionMessage(424, "There is some issue in sending the Mail. Please contact your administrator.");
        }
        this.loginAttemptCache.recordSuccessfulLogin(request.getUsername());
    }

    @Override
    public void changeUserPwdWithOldPwd(UriInfo uriInfo, String userName, ChangePasswordRequest request) throws IOException {
        if (!request.getNewPassword().equals(request.getConfirmPassword())) {
            throw new IllegalArgumentException("Password and Confirm Password should match");
        }
        PasswordUtil.validatePassword(request.getNewPassword());
        User storedUser = this.userRepository.getByName(uriInfo, userName, this.userRepository.getFieldsWithUserAuth("*"));
        if (storedUser.getAuthenticationMechanism() == null) {
            storedUser.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)new BasicAuthMechanism().withPassword("")));
        }
        BasicAuthMechanism storedBasicAuthMechanism = JsonUtils.convertValue(storedUser.getAuthenticationMechanism().getConfig(), BasicAuthMechanism.class);
        String storedHashPassword = storedBasicAuthMechanism.getPassword();
        String newHashedPassword = BCrypt.withDefaults().hashToString(12, request.getNewPassword().toCharArray());
        if (request.getRequestType() == ChangePasswordRequest.RequestType.SELF && !BCrypt.verifyer().verify((char[])request.getOldPassword().toCharArray(), (CharSequence)storedHashPassword).verified) {
            throw new CustomExceptionMessage(Response.Status.UNAUTHORIZED, "Old Password is not correct");
        }
        storedBasicAuthMechanism.setPassword(newHashedPassword);
        storedUser.getAuthenticationMechanism().setConfig((Object)storedBasicAuthMechanism);
        RestUtil.PutResponse<User> response = this.userRepository.createOrUpdate(uriInfo, storedUser);
        this.loginAttemptCache.recordSuccessfulLogin(userName);
        if (request.getRequestType() == ChangePasswordRequest.RequestType.USER && this.isEmailServiceEnabled) {
            this.sendInviteMailToUser(uriInfo, response.getEntity(), String.format("%s: Password Update", EmailUtil.getInstance().getEmailingEntity()), CreateUser.CreatePasswordType.ADMIN_CREATE, request.getNewPassword());
        }
    }

    @Override
    public void sendInviteMailToUser(UriInfo uriInfo, User user, String subject, CreateUser.CreatePasswordType requestType, String pwd) throws IOException {
        switch (requestType) {
            case ADMIN_CREATE: {
                HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
                templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
                templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
                templatePopulator.put("userName", user.getName());
                templatePopulator.put("password", pwd);
                templatePopulator.put("applicationLoginLink", EmailUtil.getInstance().getOMUrl());
                try {
                    EmailUtil.getInstance().sendMail(subject, templatePopulator, user.getEmail(), "/emailTemplates", "invite-randompwd.ftl");
                }
                catch (TemplateException ex) {
                    LOG.error("Failed in sending Mail to user [{}]. Reason : {}", new Object[]{user.getEmail(), ex.getMessage(), ex});
                }
                break;
            }
            case USER_CREATE: {
                this.sendPasswordResetLink(uriInfo, user, subject, "invite-createPassword.ftl");
                break;
            }
            default: {
                LOG.error("Invalid Password Create Type");
            }
        }
    }

    @Override
    public RefreshToken createRefreshTokenForLogin(UUID currentUserId) throws JsonProcessingException {
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }

    @Override
    public JwtResponse getNewAccessToken(TokenRefreshRequest request) throws IOException {
        if (CommonUtil.nullOrEmpty((String)request.getRefreshToken())) {
            throw new BadRequestException("Token Cannot be Null or Empty String");
        }
        TokenInterface tokenInterface = this.tokenRepository.findByToken(request.getRefreshToken());
        User storedUser = (User)this.userRepository.get(null, tokenInterface.getUserId(), this.userRepository.getFieldsWithUserAuth("*"));
        if (storedUser.getIsBot() != null && storedUser.getIsBot().booleanValue()) {
            throw new IllegalArgumentException("User are only allowed to login");
        }
        RefreshToken refreshToken = this.validateAndReturnNewRefresh(storedUser.getId(), request);
        JWTAuthMechanism jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(storedUser.getName(), storedUser.getEmail(), this.loginConfiguration.getJwtTokenExpiryTime().intValue(), false, ServiceTokenType.OM_USER);
        JwtResponse response = new JwtResponse();
        response.setTokenType("Bearer");
        response.setAccessToken(jwtAuthMechanism.getJWTToken());
        response.setRefreshToken(refreshToken.getToken().toString());
        response.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
        return response;
    }

    public void verifyPasswordResetTokenExpiry(PasswordResetToken token) {
        if (token.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, String.format("Password Reset Token %s Expired token. Please issue a new request", token.getToken()));
        }
        if (Boolean.FALSE.equals(token.getIsActive())) {
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, String.format("Password Reset Token %s Token was marked inactive", token.getToken()));
        }
    }

    public RefreshToken validateAndReturnNewRefresh(UUID currentUserId, TokenRefreshRequest tokenRefreshRequest) throws JsonProcessingException {
        String requestRefreshToken = tokenRefreshRequest.getRefreshToken();
        RefreshToken storedRefreshToken = (RefreshToken)this.tokenRepository.findByToken(requestRefreshToken);
        if (storedRefreshToken.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Expired token. Please login again : " + storedRefreshToken.getToken().toString());
        }
        this.tokenRepository.deleteToken(requestRefreshToken);
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }

    private User getUserFromRegistrationRequest(RegistrationRequest create) {
        String username = create.getEmail().split("@")[0];
        String hashedPwd = BCrypt.withDefaults().hashToString(12, create.getPassword().toCharArray());
        BasicAuthMechanism newAuthMechanism = new BasicAuthMechanism().withPassword(hashedPwd);
        return new User().withId(UUID.randomUUID()).withName(username).withFullyQualifiedName(username).withEmail(create.getEmail()).withDisplayName(create.getFirstName() + create.getLastName()).withIsBot(Boolean.valueOf(false)).withIsAdmin(Boolean.valueOf(false)).withUpdatedBy(username).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsEmailVerified(Boolean.valueOf(false)).withAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthMechanism));
    }

    public void validateEmailAlreadyExists(String email) {
        if (this.userRepository.checkEmailAlreadyExists(email)) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "User with Email Already Exists");
        }
    }

    @Override
    public JwtResponse loginUser(LoginRequest loginRequest) throws IOException, TemplateException {
        String userName = loginRequest.getEmail().contains("@") ? loginRequest.getEmail().split("@")[0] : loginRequest.getEmail();
        this.checkIfLoginBlocked(userName);
        User storedUser = this.lookUserInProvider(userName);
        this.validatePassword(storedUser, loginRequest.getPassword());
        return this.getJwtResponse(storedUser, this.loginConfiguration.getJwtTokenExpiryTime().intValue());
    }

    @Override
    public void checkIfLoginBlocked(String userName) {
        if (this.loginAttemptCache.isLoginBlocked(userName)) {
            throw new AuthenticationException("Failed Login Attempts Exceeded. Please try after some time.");
        }
    }

    @Override
    public void recordFailedLoginAttempt(User storedUser) throws TemplateException, IOException {
        this.loginAttemptCache.recordFailedLogin(storedUser.getName());
        int failedLoginAttempt = this.loginAttemptCache.getUserFailedLoginCount(storedUser.getName());
        if (failedLoginAttempt == this.loginConfiguration.getMaxLoginFailAttempts()) {
            EmailUtil.getInstance().sendAccountStatus(storedUser, "Multiple Failed Login Attempts.", String.format("Someone is trying to access your account. Login is Blocked for %s minutes. Please change your password.", this.loginConfiguration.getAccessBlockTime()));
        }
    }

    @Override
    public void validatePassword(User storedUser, String reqPassword) throws TemplateException, IOException {
        if (storedUser.getAuthenticationMechanism() == null) {
            throw new AuthenticationException("You have entered an invalid username or password.");
        }
        LinkedHashMap storedData = (LinkedHashMap)storedUser.getAuthenticationMechanism().getConfig();
        String storedHashPassword = (String)storedData.get("password");
        if (!BCrypt.verifyer().verify((char[])reqPassword.toCharArray(), (CharSequence)storedHashPassword).verified) {
            this.recordFailedLoginAttempt(storedUser);
            throw new AuthenticationException("You have entered an invalid username or password.");
        }
    }

    @Override
    public User lookUserInProvider(String userName) {
        User storedUser;
        try {
            storedUser = this.userRepository.getByName(null, userName, new EntityUtil.Fields(List.of("authenticationMechanism"), "authenticationMechanism"));
            if (storedUser != null && Boolean.TRUE.equals(storedUser.getIsBot())) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "You have entered an invalid username or password.");
            }
        }
        catch (Exception ex) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "You have entered an invalid username or password.");
        }
        return storedUser;
    }
}

