/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.ssl.SSLUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.UUID;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.Response;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.auth.LdapConfiguration;
import org.openmetadata.schema.auth.LoginRequest;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.auth.AuthenticatorHandler;
import org.openmetadata.service.security.auth.LoginAttemptCache;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.LdapUtil;
import org.openmetadata.service.util.TokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticator
implements AuthenticatorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticator.class);
    static final String LDAP_ERR_MSG = "[LDAP] Issue in creating a LookUp Connection SSL";
    private UserRepository userRepository;
    private TokenRepository tokenRepository;
    private LoginAttemptCache loginAttemptCache;
    private LdapConfiguration ldapConfiguration;
    private LDAPConnectionPool ldapLookupConnectionPool;
    private LoginConfiguration loginConfiguration;

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        if (!config.getAuthenticationConfiguration().getProvider().equals("ldap") || config.getAuthenticationConfiguration().getLdapConfiguration() == null) {
            throw new IllegalStateException("Invalid or Missing Ldap Configuration.");
        }
        this.ldapLookupConnectionPool = this.getLdapConnectionPool(config.getAuthenticationConfiguration().getLdapConfiguration());
        this.userRepository = new UserRepository((CollectionDAO)jdbi.onDemand(CollectionDAO.class));
        this.tokenRepository = new TokenRepository((CollectionDAO)jdbi.onDemand(CollectionDAO.class));
        this.ldapConfiguration = config.getAuthenticationConfiguration().getLdapConfiguration();
        this.loginAttemptCache = new LoginAttemptCache(config);
        this.loginConfiguration = config.getApplicationConfiguration().getLoginConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LDAPConnectionPool getLdapConnectionPool(LdapConfiguration ldapConfiguration) {
        try {
            if (ldapConfiguration.getSslEnabled().booleanValue()) {
                LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
                LdapUtil ldapUtil = new LdapUtil();
                SSLUtil sslUtil = new SSLUtil((TrustManager)ldapUtil.getLdapSSLConnection(ldapConfiguration, connectionOptions));
                try (LDAPConnection connection = new LDAPConnection((SocketFactory)sslUtil.createSSLSocketFactory(), connectionOptions, ldapConfiguration.getHost(), ldapConfiguration.getPort().intValue(), ldapConfiguration.getDnAdminPrincipal(), ldapConfiguration.getDnAdminPassword());){
                    LDAPConnectionPool lDAPConnectionPool = new LDAPConnectionPool(connection, ldapConfiguration.getMaxPoolSize().intValue());
                    return lDAPConnectionPool;
                }
                catch (GeneralSecurityException e) {
                    LOG.error(LDAP_ERR_MSG, (Throwable)e);
                    throw new IllegalStateException(LDAP_ERR_MSG, e);
                }
            }
            try (LDAPConnection conn = new LDAPConnection(ldapConfiguration.getHost(), ldapConfiguration.getPort().intValue(), ldapConfiguration.getDnAdminPrincipal(), ldapConfiguration.getDnAdminPassword());){
                LDAPConnectionPool lDAPConnectionPool = new LDAPConnectionPool(conn, ldapConfiguration.getMaxPoolSize().intValue());
                return lDAPConnectionPool;
            }
            catch (LDAPException e) {
                LOG.error("[LDAP] Issue in creating a LookUp Connection", (Throwable)e);
                throw new IllegalStateException("[LDAP] Issue in creating a LookUp Connection", e);
            }
        }
        catch (LDAPException e) {
            throw new IllegalStateException(LDAP_ERR_MSG, e);
        }
    }

    @Override
    public JwtResponse loginUser(LoginRequest loginRequest) throws IOException, TemplateException {
        this.checkIfLoginBlocked(loginRequest.getEmail());
        User storedUser = this.lookUserInProvider(loginRequest.getEmail());
        this.validatePassword(storedUser, loginRequest.getPassword());
        User omUser = this.checkAndCreateUser(loginRequest.getEmail());
        return this.getJwtResponse(omUser, this.loginConfiguration.getJwtTokenExpiryTime().intValue());
    }

    private User checkAndCreateUser(String email) throws IOException {
        try {
            return this.userRepository.getByName(null, email.split("@")[0], this.userRepository.getFields("id,name,email"));
        }
        catch (EntityNotFoundException ex) {
            return this.userRepository.create(null, this.getUserForLdap(email));
        }
    }

    @Override
    public void checkIfLoginBlocked(String email) {
        if (this.loginAttemptCache.isLoginBlocked(email)) {
            throw new AuthenticationException("Failed Login Attempts Exceeded. Please try after some time.");
        }
    }

    @Override
    public void recordFailedLoginAttempt(User storedUser) throws TemplateException, IOException {
        this.loginAttemptCache.recordFailedLogin(storedUser.getName());
        int failedLoginAttempt = this.loginAttemptCache.getUserFailedLoginCount(storedUser.getName());
        if (failedLoginAttempt == this.loginConfiguration.getMaxLoginFailAttempts()) {
            EmailUtil.getInstance().sendAccountStatus(storedUser, "Multiple Failed Login Attempts.", String.format("Someone is tried accessing your account. Login is Blocked for %s minutes.", this.loginConfiguration.getAccessBlockTime()));
        }
    }

    @Override
    public void validatePassword(User storedUser, String reqPassword) throws TemplateException, IOException {
        BindResult bindingResult;
        block4: {
            bindingResult = null;
            try {
                bindingResult = this.ldapLookupConnectionPool.bind(storedUser.getName(), reqPassword);
                if (Objects.equals(bindingResult.getResultCode().getName(), ResultCode.SUCCESS.getName())) {
                    return;
                }
            }
            catch (Exception ex) {
                if (bindingResult == null || !Objects.equals(bindingResult.getResultCode().getName(), ResultCode.INVALID_CREDENTIALS.getName())) break block4;
                this.recordFailedLoginAttempt(storedUser);
                throw new CustomExceptionMessage(Response.Status.UNAUTHORIZED, "You have entered an invalid email or password.");
            }
        }
        if (bindingResult != null) {
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, bindingResult.getResultCode().getName());
        }
        throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, "You have entered an invalid email or password.");
    }

    @Override
    public User lookUserInProvider(String email) {
        try {
            Filter emailFilter = Filter.create((String)String.format("%s=%s", this.ldapConfiguration.getMailAttributeName(), email));
            SearchRequest searchRequest = new SearchRequest(this.ldapConfiguration.getUserBaseDN(), SearchScope.SUB, emailFilter, new String[]{this.ldapConfiguration.getMailAttributeName()});
            SearchResult result = this.ldapLookupConnectionPool.search(searchRequest);
            if (result.getSearchEntries().size() == 1) {
                SearchResultEntry searchResultEntry = (SearchResultEntry)result.getSearchEntries().get(0);
                String userDN = searchResultEntry.getDN();
                Attribute emailAttr = searchResultEntry.getAttribute(this.ldapConfiguration.getMailAttributeName());
                if (!CommonUtil.nullOrEmpty((String)userDN) && emailAttr != null) {
                    return this.getUserForLdap(email).withName(userDN);
                }
                throw new CustomExceptionMessage(Response.Status.FORBIDDEN, "Username or Email Attribute is incorrect. Please check Openmetadata Configuration.");
            }
            if (result.getSearchEntries().size() > 1) {
                throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, "Email corresponds to multiple entries in Directory.");
            }
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, "You have entered an invalid email or password.");
        }
        catch (LDAPException ex) {
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }

    private User getUserForLdap(String email) {
        String userName = email.split("@")[0];
        return new User().withId(UUID.randomUUID()).withName(userName).withFullyQualifiedName(userName).withEmail(email).withIsBot(Boolean.valueOf(false)).withUpdatedBy(userName).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsEmailVerified(Boolean.valueOf(false)).withAuthenticationMechanism(null);
    }

    @Override
    public RefreshToken createRefreshTokenForLogin(UUID currentUserId) throws JsonProcessingException {
        this.tokenRepository.deleteTokenByUserAndType(currentUserId.toString(), TokenType.REFRESH_TOKEN.toString());
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }
}

