/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.DbtPipeline;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;

public final class IngestionPipelineBuilder {
    private IngestionPipelineBuilder() {
    }

    public static void addDefinedConfig(IngestionPipeline ingestionPipeline) {
        if (PipelineType.DBT.equals((Object)ingestionPipeline.getPipelineType()) && ingestionPipeline.getSourceConfig() != null) {
            ingestionPipeline.getSourceConfig().setConfig(ClassConverterFactory.getConverter(DbtPipeline.class).convert(ingestionPipeline.getSourceConfig().getConfig()));
        }
        if (ingestionPipeline.getOpenMetadataServerConnection() != null) {
            ingestionPipeline.setOpenMetadataServerConnection((OpenMetadataConnection)ClassConverterFactory.getConverter(OpenMetadataConnection.class).convert(ingestionPipeline.getOpenMetadataServerConnection()));
        }
    }
}

