/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.secrets.SecretsManagerClientLoader;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.schema.security.ssl.ValidateSSLClientConfig;
import org.openmetadata.schema.security.ssl.VerifySSL;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataConnectionBuilder.class);
    OpenMetadataConnection.AuthProvider authProvider;
    String bot;
    Object securityConfig;
    private final VerifySSL verifySSL;
    private final String openMetadataURL;
    private final String clusterName;
    private final SecretsManagerProvider secretsManagerProvider;
    private final SecretsManagerClientLoader secretsManagerLoader;
    private final Object openMetadataSSLConfig;
    BotRepository botRepository;
    UserRepository userRepository;

    public OpenMetadataConnectionBuilder(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        String provider = openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider();
        OpenMetadataConnection.AuthProvider authProvider = this.authProvider = "basic".equals(provider) || "ldap".equals(provider) || "saml".equals(provider) ? OpenMetadataConnection.AuthProvider.OPENMETADATA : OpenMetadataConnection.AuthProvider.fromValue((String)openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider());
        if (!OpenMetadataConnection.AuthProvider.NO_AUTH.equals((Object)this.authProvider)) {
            this.botRepository = (BotRepository)Entity.getEntityRepository("bot");
            this.userRepository = (UserRepository)Entity.getEntityRepository("user");
            User botUser = this.retrieveBotUser();
            this.securityConfig = this.extractSecurityConfig(botUser);
            this.authProvider = this.extractAuthProvider(botUser);
        }
        PipelineServiceClientConfiguration pipelineServiceClientConfiguration = openMetadataApplicationConfig.getPipelineServiceClientConfiguration();
        this.openMetadataURL = pipelineServiceClientConfiguration.getMetadataApiEndpoint();
        this.verifySSL = pipelineServiceClientConfiguration.getVerifySSL();
        this.openMetadataSSLConfig = this.getOMSSLConfigFromPipelineServiceClient(pipelineServiceClientConfiguration.getVerifySSL(), pipelineServiceClientConfiguration.getSslConfig());
        this.clusterName = openMetadataApplicationConfig.getClusterName();
        this.secretsManagerLoader = pipelineServiceClientConfiguration.getSecretsManagerLoader();
        this.secretsManagerProvider = SecretsManagerFactory.getSecretsManager().getSecretsManagerProvider();
    }

    private OpenMetadataConnection.AuthProvider extractAuthProvider(User botUser) {
        AuthenticationMechanism.AuthType authType = botUser.getAuthenticationMechanism().getAuthType();
        switch (authType) {
            case SSO: {
                return OpenMetadataConnection.AuthProvider.fromValue((String)JsonUtils.convertValue(botUser.getAuthenticationMechanism().getConfig(), SSOAuthMechanism.class).getSsoServiceType().value());
            }
            case JWT: {
                return OpenMetadataConnection.AuthProvider.OPENMETADATA;
            }
        }
        throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authType.value()));
    }

    private Object extractSecurityConfig(User botUser) {
        AuthenticationMechanism authMechanism = botUser.getAuthenticationMechanism();
        switch (botUser.getAuthenticationMechanism().getAuthType()) {
            case SSO: {
                return JsonUtils.convertValue(authMechanism.getConfig(), SSOAuthMechanism.class).getAuthConfig();
            }
            case JWT: {
                JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
                return new OpenMetadataJWTClientConfig().withJwtToken(jwtAuthMechanism.getJWTToken());
            }
        }
        throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authMechanism.getAuthType().value()));
    }

    public OpenMetadataConnection build() {
        return new OpenMetadataConnection().withAuthProvider(this.authProvider).withHostPort(this.openMetadataURL).withSecurityConfig(this.securityConfig).withVerifySSL(this.verifySSL).withClusterName(this.clusterName).withSecretsManagerProvider(this.secretsManagerProvider).withSecretsManagerLoader(this.secretsManagerLoader).withSslConfig(this.openMetadataSSLConfig);
    }

    private User retrieveBotUser() {
        User botUser = this.retrieveIngestionBotUser("ingestion-bot");
        if (botUser == null) {
            throw new IllegalArgumentException("Please, verify that the ingestion-bot is present.");
        }
        return botUser;
    }

    private User retrieveIngestionBotUser(String botName) {
        try {
            Bot bot1 = (Bot)this.botRepository.getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
            if (bot1.getBotUser() == null) {
                return null;
            }
            User user = this.userRepository.getByName(null, bot1.getBotUser().getFullyQualifiedName(), new EntityUtil.Fields(List.of("authenticationMechanism")));
            if (user.getAuthenticationMechanism() != null) {
                user.getAuthenticationMechanism().setConfig(user.getAuthenticationMechanism().getConfig());
            }
            return user;
        }
        catch (IOException | EntityNotFoundException ex) {
            LOG.debug((this.bot == null ? "Bot" : String.format("User for bot [%s]", botName)) + " [{}] not found.", (Object)botName);
            return null;
        }
    }

    protected Object getOMSSLConfigFromPipelineServiceClient(VerifySSL verifySSL, Object sslConfig) {
        switch (verifySSL) {
            case NO_SSL: 
            case IGNORE: {
                return null;
            }
            case VALIDATE: {
                return JsonUtils.convertValue(sslConfig, ValidateSSLClientConfig.class);
            }
        }
        throw new IllegalArgumentException("OpenMetadata doesn't support SSL verification type " + verifySSL.value());
    }
}

