/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openmetadata.api.configuration.airflow.AuthConfiguration;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.teams.RoleResource;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UserUtil.class);

    public static void addUsers(String providerType, Set<String> adminUsers, String domain, Boolean isAdmin) {
        try {
            for (String username : adminUsers) {
                UserUtil.createOrUpdateUser(providerType, username, domain, isAdmin);
            }
        }
        catch (Exception ex) {
            LOG.error("[BootstrapUser] Encountered Exception while bootstrapping admin user", (Throwable)ex);
        }
    }

    private static void createOrUpdateUser(String providerType, String username, String domain, Boolean isAdmin) throws IOException {
        User updatedUser;
        block5: {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            try {
                User originalUser;
                ArrayList<String> fieldList = new ArrayList<String>(userRepository.getPatchFields().getFieldList());
                fieldList.add("authenticationMechanism");
                updatedUser = originalUser = userRepository.getByName(null, username, new EntityUtil.Fields(fieldList));
                if (providerType.equals(SSOAuthMechanism.SsoServiceType.BASIC.value())) {
                    if (originalUser.getAuthenticationMechanism() == null || originalUser.getAuthenticationMechanism().equals((Object)new AuthenticationMechanism())) {
                        UserUtil.updateUserWithHashedPwd(updatedUser, UserUtil.getPassword());
                        EmailUtil.sendInviteMailToAdmin(updatedUser, "admin");
                    }
                } else {
                    updatedUser.setAuthenticationMechanism(new AuthenticationMechanism());
                }
                updatedUser.setIsAdmin(isAdmin);
                updatedUser.setEmail(String.format("%s@%s", username, domain));
            }
            catch (EntityNotFoundException e) {
                updatedUser = UserUtil.user(username, domain, username).withIsAdmin(isAdmin).withIsEmailVerified(Boolean.valueOf(true));
                if (!providerType.equals(SSOAuthMechanism.SsoServiceType.BASIC.value())) break block5;
                UserUtil.updateUserWithHashedPwd(updatedUser, UserUtil.getPassword());
                EmailUtil.sendInviteMailToAdmin(updatedUser, "admin");
            }
        }
        UserUtil.addOrUpdateUser(updatedUser);
    }

    private static String getPassword() {
        try {
            EmailUtil.getInstance().testConnection();
            return PasswordUtil.generateRandomPassword();
        }
        catch (Exception ex) {
            LOG.info("Password set to Default.");
            return "admin";
        }
    }

    public static void updateUserWithHashedPwd(User user, String pwd) {
        String hashedPwd = BCrypt.withDefaults().hashToString(12, pwd.toCharArray());
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)new BasicAuthMechanism().withPassword(hashedPwd)));
    }

    public static User addOrUpdateUser(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            RestUtil.PutResponse<User> addedUser = userRepository.createOrUpdate(null, user);
            LOG.debug("Added user entry: {}", (Object)addedUser.getEntity().getName());
            return addedUser.getEntity();
        }
        catch (Exception exception) {
            LOG.debug("Caught exception", (Throwable)exception);
            user.setAuthenticationMechanism(null);
            LOG.debug("User entry: {} already exists.", (Object)user.getName());
            return null;
        }
    }

    public static User user(String name, String domain, String updatedBy) {
        return new User().withId(UUID.randomUUID()).withName(name).withFullyQualifiedName(name).withEmail(name + "@" + domain).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsBot(Boolean.valueOf(false));
    }

    public static User addOrUpdateBotUser(User user, OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        AuthenticationMechanism authMechanism;
        User originalUser = UserUtil.retrieveWithAuthMechanism(user);
        PipelineServiceClientConfiguration pipelineServiceClientConfiguration = openMetadataApplicationConfig.getPipelineServiceClientConfiguration();
        AuthenticationMechanism authenticationMechanism = authMechanism = originalUser != null ? originalUser.getAuthenticationMechanism() : null;
        if (UserUtil.authConfigPresent(pipelineServiceClientConfiguration) && authMechanism == null) {
            AuthConfiguration authConfig = pipelineServiceClientConfiguration.getAuthConfig();
            String currentAuthProvider = openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider();
            if ("openmetadata".equals(pipelineServiceClientConfiguration.getAuthProvider()) && !"basic".equals(currentAuthProvider)) {
                OpenMetadataJWTClientConfig jwtClientConfig = authConfig.getOpenmetadata();
                authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(jwtClientConfig, user));
            } else if (!"basic".equals(currentAuthProvider)) {
                switch (currentAuthProvider) {
                    case "no-auth": {
                        break;
                    }
                    case "azure": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AZURE, authConfig.getAzure()));
                        break;
                    }
                    case "google": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.GOOGLE, authConfig.getGoogle()));
                        break;
                    }
                    case "okta": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.OKTA, authConfig.getOkta()));
                        break;
                    }
                    case "auth0": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AUTH_0, authConfig.getAuth0()));
                        break;
                    }
                    case "custom-oidc": {
                        authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, UserUtil.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.CUSTOM_OIDC, authConfig.getCustomOidc()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unexpected auth provider [%s] for bot [%s]", currentAuthProvider, user.getName()));
                    }
                }
            } else {
                authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(null, user));
            }
        } else if (authMechanism == null) {
            authMechanism = UserUtil.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, UserUtil.buildJWTAuthMechanism(null, user));
        }
        user.setAuthenticationMechanism(authMechanism);
        user.setDescription(user.getDescription());
        user.setDisplayName(user.getDisplayName());
        return UserUtil.addOrUpdateUser(user);
    }

    private static boolean authConfigPresent(PipelineServiceClientConfiguration pipelineServiceClientConfiguration) {
        return pipelineServiceClientConfiguration != null && pipelineServiceClientConfiguration.getAuthConfig() != null;
    }

    private static JWTAuthMechanism buildJWTAuthMechanism(OpenMetadataJWTClientConfig jwtClientConfig, User user) {
        return Objects.isNull(jwtClientConfig) || CommonUtil.nullOrEmpty((String)jwtClientConfig.getJwtToken()) ? JWTTokenGenerator.getInstance().generateJWTToken(user, JWTTokenExpiry.Unlimited) : new JWTAuthMechanism().withJWTToken(jwtClientConfig.getJwtToken()).withJWTTokenExpiry(JWTTokenExpiry.Unlimited);
    }

    private static SSOAuthMechanism buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType ssoServiceType, Object config) {
        return new SSOAuthMechanism().withSsoServiceType(ssoServiceType).withAuthConfig(config);
    }

    private static AuthenticationMechanism buildAuthMechanism(AuthenticationMechanism.AuthType authType, Object config) {
        return new AuthenticationMechanism().withAuthType(authType).withConfig(config);
    }

    private static User retrieveWithAuthMechanism(User user) {
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            return (User)userRepository.getByName(null, user.getName(), new EntityUtil.Fields(List.of("authenticationMechanism")));
        }
        catch (IOException | EntityNotFoundException e) {
            LOG.debug("Bot entity: {} does not exists.", (Object)user);
            return null;
        }
    }

    public static List<EntityReference> getRoleForBot(String botName) {
        String botRole;
        switch (botName) {
            case "ingestion-bot": {
                botRole = "IngestionBotRole";
                break;
            }
            case "quality-bot": {
                botRole = "QualityBotRole";
                break;
            }
            case "profiler-bot": {
                botRole = "ProfilerBotRole";
                break;
            }
            default: {
                throw new IllegalArgumentException("No role found for the bot " + botName);
            }
        }
        return CommonUtil.listOf((Object[])new EntityReference[]{RoleResource.getRole(botRole)});
    }
}

