/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.elasticsearch.indexes.ColumnIndex;
import org.openmetadata.service.elasticsearch.models.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.models.FlattenColumn;
import org.openmetadata.service.util.JsonUtils;

public class ContainerIndex
implements ColumnIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final Container container;

    public ContainerIndex(Container container) {
        this.container = container;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.container.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.container.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.container.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.container);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> columnSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        suggest.add(ElasticSearchSuggest.builder().input(this.container.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.container.getName()).weight(10).build());
        if (this.container.getDataModel() != null && this.container.getDataModel().getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.container.getDataModel().getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(ElasticSearchSuggest.builder().input(col.getName()).weight(5).build());
            }
        }
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.container.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("container", (EntityInterface)this.container));
        doc.put("displayName", this.container.getDisplayName() != null ? this.container.getDisplayName() : this.container.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.container.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("entityType", "container");
        doc.put("serviceType", this.container.getServiceType());
        return doc;
    }
}

