/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.models.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class QueryIndex
implements ElasticSearchIndex {
    final List<String> excludeTopicFields = List.of("changeDescription");
    final Query query;

    public QueryIndex(Query query) {
        this.query = query;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.query);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        if (this.query.getDisplayName() != null) {
            suggest.add(ElasticSearchSuggest.builder().input(this.query.getName()).weight(10).build());
        }
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeTopicFields);
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("query", (EntityInterface)this.query));
        doc.put("displayName", this.query.getDisplayName() != null ? this.query.getDisplayName() : "");
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.query.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("entityType", "query");
        return doc;
    }
}

