/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.models.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TagIndex
implements ElasticSearchIndex {
    final Tag tag;
    private static final List<String> excludeFields = List.of("changeDescription");

    public TagIndex(Tag tag) {
        this.tag = tag;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.tag);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.tag.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.tag.getName()).weight(10).build());
        if (this.tag.getDisabled() != null && this.tag.getDisabled().booleanValue()) {
            doc.put("disabled", this.tag.getDisabled());
        } else {
            doc.put("disabled", "false");
        }
        doc.put("suggest", suggest);
        doc.put("entityType", "tag");
        return doc;
    }
}

