/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.models.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.models.FlattenSchemaField;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class TopicIndex
implements ElasticSearchIndex {
    final List<String> excludeTopicFields = List.of("sampleData", "changeDescription", "messageSchema");
    final Topic topic;

    public TopicIndex(Topic topic) {
        this.topic = topic;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.topic.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.topic.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.topic.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.topic);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> fieldSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.topic.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.topic.getName()).weight(10).build());
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.topic.getService().getName()).weight(5).build());
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeTopicFields);
        if (this.topic.getMessageSchema() != null && this.topic.getMessageSchema().getSchemaFields() != null && !this.topic.getMessageSchema().getSchemaFields().isEmpty()) {
            ArrayList<FlattenSchemaField> flattenFields = new ArrayList<FlattenSchemaField>();
            this.parseSchemaFields(this.topic.getMessageSchema().getSchemaFields(), flattenFields, null);
            for (FlattenSchemaField field : flattenFields) {
                fieldSuggest.add(ElasticSearchSuggest.builder().input(field.getName()).weight(5).build());
            }
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("topic", (EntityInterface)this.topic));
        doc.put("displayName", this.topic.getDisplayName() != null ? this.topic.getDisplayName() : this.topic.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.topic.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("field_suggest", fieldSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "topic");
        doc.put("serviceType", this.topic.getServiceType());
        doc.put("messageSchema", this.topic.getMessageSchema() != null ? this.topic.getMessageSchema() : null);
        return doc;
    }

    private void parseSchemaFields(List<Field> fields, List<FlattenSchemaField> flattenSchemaFields, String parentSchemaField) {
        Optional<String> optParentField = Optional.ofNullable(parentSchemaField).filter(Predicate.not(String::isEmpty));
        List<TagLabel> tags = new ArrayList();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (optParentField.isPresent()) {
                fieldName = FullyQualifiedName.add(optParentField.get(), fieldName);
            }
            if (field.getTags() != null) {
                tags = field.getTags();
            }
            FlattenSchemaField flattenSchemaField = FlattenSchemaField.builder().name(fieldName).description(field.getDescription()).build();
            if (!tags.isEmpty()) {
                flattenSchemaField.setTags(tags);
            }
            flattenSchemaFields.add(flattenSchemaField);
            if (field.getChildren() == null) continue;
            this.parseSchemaFields(field.getChildren(), flattenSchemaFields, field.getName());
        }
    }
}

