/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.SecurityContext;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.FeedUtils;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.NotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEventHandler.class);
    private CollectionDAO dao;
    private FeedRepository feedDao;
    private ObjectMapper mapper;
    private NotificationHandler notificationHandler;

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        this.dao = (CollectionDAO)jdbi.onDemand(CollectionDAO.class);
        this.feedDao = new FeedRepository(this.dao);
        this.mapper = new ObjectMapper();
        this.notificationHandler = new NotificationHandler((CollectionDAO)jdbi.onDemand(CollectionDAO.class));
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String method = requestContext.getMethod();
        SecurityContext securityContext = requestContext.getSecurityContext();
        String loggedInUserName = securityContext.getUserPrincipal().getName();
        try {
            this.notificationHandler.processNotifications(responseContext);
            ChangeEvent changeEvent = FormatterUtil.getChangeEventFromResponseContext(responseContext, loggedInUserName, method);
            if (changeEvent == null) {
                return null;
            }
            changeEvent.setUserName(loggedInUserName);
            LOG.info("Recording change event {}:{}:{}:{}", new Object[]{changeEvent.getTimestamp(), changeEvent.getEntityId(), changeEvent.getEventType(), changeEvent.getEntityType()});
            EventPubSub.publish(changeEvent);
            if (changeEvent.getEntity() != null) {
                Object entity = changeEvent.getEntity();
                changeEvent = ChangeEventHandler.copyChangeEvent(changeEvent);
                changeEvent.setEntity((Object)JsonUtils.pojoToMaskedJson(entity));
            }
            this.dao.changeEventDAO().insert(JsonUtils.pojoToJson(changeEvent));
            if (Entity.shouldDisplayEntityChangeOnFeed(changeEvent.getEntityType()) && AlertUtil.shouldProcessActivityFeedRequest(changeEvent)) {
                for (Thread thread : CommonUtil.listOrEmpty(FeedUtils.getThreads(changeEvent, loggedInUserName))) {
                    if (thread.getMessage() == null || thread.getMessage().isEmpty()) continue;
                    this.feedDao.create(thread, responseContext);
                    String jsonThread = this.mapper.writeValueAsString((Object)thread);
                    WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
                    if (!changeEvent.getEventType().equals((Object)EventType.ENTITY_DELETED)) continue;
                    this.deleteAllConversationsRelatedToEntity(AlertsRuleEvaluator.getEntity(changeEvent));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to capture change event for method {} due to ", (Object)method, (Object)e);
        }
        return null;
    }

    private static ChangeEvent copyChangeEvent(ChangeEvent changeEvent) {
        return new ChangeEvent().withEventType(changeEvent.getEventType()).withEntityId(changeEvent.getEntityId()).withEntityType(changeEvent.getEntityType()).withUserName(changeEvent.getUserName()).withTimestamp(changeEvent.getTimestamp()).withChangeDescription(changeEvent.getChangeDescription()).withCurrentVersion(changeEvent.getCurrentVersion());
    }

    private void deleteAllConversationsRelatedToEntity(EntityInterface entityInterface) {
        String entityId = entityInterface.getId().toString();
        List<String> threadIds = this.dao.feedDAO().findByEntityId(entityId);
        for (String threadId : threadIds) {
            this.dao.relationshipDAO().deleteAll(threadId, "THREAD");
            this.dao.feedDAO().delete(threadId);
        }
    }

    @Override
    public void close() {
    }
}

