/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.slack;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.slack.SlackMessage;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.SlackMessageDecorator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackEventPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SlackEventPublisher.class);
    private final MessageDecorator<SlackMessage> slackMessageFormatter = new SlackMessageDecorator();
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final CollectionDAO daoCollection;

    public SlackEventPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() == CreateEventSubscription.SubscriptionType.SLACK_WEBHOOK) {
            String slackWebhookURL;
            this.daoCollection = dao;
            this.webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(eventSub.getTimeout(), eventSub.getReadTimeout());
            if (this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(slackWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = this.client.target(slackWebhookURL).request();
            }
        } else {
            throw new IllegalArgumentException("Slack Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Slack Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void sendAlert(EventResource.EventList list) {
        for (ChangeEvent event : list.getData()) {
            try {
                SlackMessage slackMessage = this.slackMessageFormatter.buildMessage(event);
                List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, CreateEventSubscription.SubscriptionType.SLACK_WEBHOOK, this.client, this.daoCollection, event);
                if (this.target != null) {
                    targets.add(this.target);
                }
                for (Invocation.Builder actionTarget : targets) {
                    SubscriptionUtil.postWebhookMessage(this, actionTarget, slackMessage);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to publish event {} to slack due to {} ", (Object)event, (Object)e.getMessage());
                throw new EventPublisherException(String.format("Failed to publish event %s to slack due to %s ", event, e.getMessage()));
            }
        }
    }
}

