/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import io.dropwizard.web.conf.WebConfiguration;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMErrorPageHandler
extends ErrorPageErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OMErrorPageHandler.class);
    private final WebConfiguration webConfiguration;

    public OMErrorPageHandler(WebConfiguration webConfiguration) {
        this.webConfiguration = webConfiguration;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doError(target, baseRequest, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doError(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        block11: {
            String cacheControl = this.getCacheControl();
            if (cacheControl != null) {
                response.setHeader(HttpHeader.CACHE_CONTROL.asString(), cacheControl);
            }
            this.webConfiguration.getHstsHeaderFactory().build().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            this.webConfiguration.getFrameOptionsHeaderFactory().build().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            this.webConfiguration.getContentTypeOptionsHeaderFactory().build().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            this.webConfiguration.getXssProtectionHeaderFactory().build().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            String errorPage = this.getErrorPage(request);
            ContextHandler.Context context = baseRequest.getErrorContext();
            Dispatcher errorDispatcher = errorPage != null && context != null ? (Dispatcher)context.getRequestDispatcher(errorPage) : null;
            try {
                String message;
                block10: {
                    if (errorDispatcher != null) {
                        try {
                            errorDispatcher.error((ServletRequest)request, (ServletResponse)response);
                            return;
                        }
                        catch (ServletException ex) {
                            LOG.debug("Error in OMErrorPageHandler", (Throwable)ex);
                            if (!response.isCommitted()) break block10;
                            baseRequest.setHandled(true);
                            return;
                        }
                    }
                }
                if ((message = (String)request.getAttribute("javax.servlet.error.message")) == null) {
                    message = baseRequest.getResponse().getReason();
                }
                this.generateAcceptableResponse(baseRequest, request, response, response.getStatus(), message);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                baseRequest.setHandled(true);
            }
        }
    }
}

