/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.fernet;

import com.google.common.annotations.VisibleForTesting;
import com.macasaet.fernet.Key;
import com.macasaet.fernet.StringValidator;
import com.macasaet.fernet.Token;
import com.macasaet.fernet.Validator;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.openmetadata.schema.api.fernet.FernetConfiguration;
import org.openmetadata.service.OpenMetadataApplicationConfig;

public class Fernet {
    private static Fernet instance = new Fernet();
    private String fernetKey;
    public static final String FERNET_PREFIX = "fernet:";
    public static final String FERNET_NO_ENCRYPTION = "no_encryption_at_rest";
    private final Validator<String> validator = new StringValidator(){

        public TemporalAmount getTimeToLive() {
            return Duration.ofSeconds(Instant.MAX.getEpochSecond());
        }
    };

    private Fernet() {
    }

    public static Fernet getInstance() {
        return instance;
    }

    public void setFernetKey(OpenMetadataApplicationConfig config) {
        FernetConfiguration fernetConfiguration = config.getFernetConfiguration();
        if (fernetConfiguration != null && !FERNET_NO_ENCRYPTION.equals(fernetConfiguration.getFernetKey())) {
            this.setFernetKey(fernetConfiguration.getFernetKey());
        }
    }

    @VisibleForTesting
    public void setFernetKey(String fernetKey) {
        this.fernetKey = fernetKey != null ? fernetKey.replace("/", "_").replace("+", "-").replace("=", "") : null;
    }

    public boolean isKeyDefined() {
        return this.fernetKey != null;
    }

    public String encrypt(@NonNull String secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (secret.startsWith(FERNET_PREFIX)) {
            throw new IllegalArgumentException("Field is already tokenized");
        }
        if (this.isKeyDefined()) {
            Key key = new Key(this.fernetKey.split(",")[0]);
            return FERNET_PREFIX + Token.generate((Key)key, (String)secret).serialise();
        }
        throw new IllegalArgumentException("Fernet key is null");
    }

    public static boolean isTokenized(String tokenized) {
        return tokenized != null && tokenized.startsWith(FERNET_PREFIX);
    }

    public String decrypt(String tokenized) {
        if (!this.isKeyDefined()) {
            throw new IllegalArgumentException("Fernet key is null");
        }
        if (tokenized != null && tokenized.startsWith(FERNET_PREFIX)) {
            String str = tokenized.split(FERNET_PREFIX, 2)[1];
            Token token = Token.fromString((String)str);
            List keys = Arrays.stream(this.fernetKey.split(",")).map(Key::new).collect(Collectors.toList());
            return (String)token.validateAndDecrypt(keys, this.validator);
        }
        throw new IllegalArgumentException("Field is not tokenized");
    }

    public String decryptIfApplies(String value) {
        return Fernet.isTokenized(value) ? this.decrypt(value) : value;
    }

    public String encryptIfApplies(@NonNull String secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        return Fernet.isTokenized(secret) ? secret : this.encrypt(secret);
    }
}

