/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.ChangeEventConfig;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.msteams.TeamsMessage;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public class MSTeamsMessageDecorator
implements MessageDecorator<TeamsMessage> {
    @Override
    public String getBold() {
        return "**%s**";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "**";
    }

    @Override
    public String getAddMarkerClose() {
        return "** ";
    }

    @Override
    public String getRemoveMarker() {
        return "~~";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "~~ ";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn) {
        return String.format("[%s](/%s/%s)", fqn.trim(), ChangeEventConfig.getInstance().getOmUri(), entityType);
    }

    @Override
    public TeamsMessage buildMessage(ChangeEvent event) throws IOException {
        TeamsMessage teamsMessage = new TeamsMessage();
        teamsMessage.setSummary("Change Event From OMD");
        TeamsMessage.Section teamsSections = new TeamsMessage.Section();
        if (event.getEntity() != null) {
            String headerTxt = "%s posted on " + event.getEntityType() + " %s";
            String headerText = String.format(headerTxt, event.getUserName(), this.getEntityUrl(event.getEntityType(), event.getEntityFullyQualifiedName()));
            teamsSections.setActivityTitle(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessages(this, event.getChangeDescription(), AlertsRuleEvaluator.getEntity(event));
        ArrayList<TeamsMessage.Section> attachmentList = new ArrayList<TeamsMessage.Section>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            TeamsMessage.Section section = new TeamsMessage.Section();
            section.setActivityTitle(teamsSections.getActivityTitle());
            section.setActivityText(entry.getValue());
            attachmentList.add(section);
        }
        teamsMessage.setSections(attachmentList);
        return teamsMessage;
    }
}

