/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBeanList;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.api.configuration.LogoConfiguration;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.connections.TestConnectionDefinition;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.FeedFilter;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelCache;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface CollectionDAO {
    @CreateSqlObject
    public DatabaseDAO databaseDAO();

    @CreateSqlObject
    public DatabaseSchemaDAO databaseSchemaDAO();

    @CreateSqlObject
    public EntityRelationshipDAO relationshipDAO();

    @CreateSqlObject
    public FieldRelationshipDAO fieldRelationshipDAO();

    @CreateSqlObject
    public EntityExtensionDAO entityExtensionDAO();

    @CreateSqlObject
    public EntityExtensionTimeSeriesDAO entityExtensionTimeSeriesDao();

    @CreateSqlObject
    public RoleDAO roleDAO();

    @CreateSqlObject
    public UserDAO userDAO();

    @CreateSqlObject
    public TeamDAO teamDAO();

    @CreateSqlObject
    public TagUsageDAO tagUsageDAO();

    @CreateSqlObject
    public TagDAO tagDAO();

    @CreateSqlObject
    public ClassificationDAO classificationDAO();

    @CreateSqlObject
    public TableDAO tableDAO();

    @CreateSqlObject
    public UsageDAO usageDAO();

    @CreateSqlObject
    public MetricsDAO metricsDAO();

    @CreateSqlObject
    public ChartDAO chartDAO();

    @CreateSqlObject
    public PipelineDAO pipelineDAO();

    @CreateSqlObject
    public DashboardDAO dashboardDAO();

    @CreateSqlObject
    public ReportDAO reportDAO();

    @CreateSqlObject
    public TopicDAO topicDAO();

    @CreateSqlObject
    public MlModelDAO mlModelDAO();

    @CreateSqlObject
    public GlossaryDAO glossaryDAO();

    @CreateSqlObject
    public GlossaryTermDAO glossaryTermDAO();

    @CreateSqlObject
    public BotDAO botDAO();

    @CreateSqlObject
    public DomainDAO domainDAO();

    @CreateSqlObject
    public DataProductDAO dataProductDAO();

    @CreateSqlObject
    public EventSubscriptionDAO eventSubscriptionDAO();

    @CreateSqlObject
    public PolicyDAO policyDAO();

    @CreateSqlObject
    public IngestionPipelineDAO ingestionPipelineDAO();

    @CreateSqlObject
    public DatabaseServiceDAO dbServiceDAO();

    @CreateSqlObject
    public MetadataServiceDAO metadataServiceDAO();

    @CreateSqlObject
    public PipelineServiceDAO pipelineServiceDAO();

    @CreateSqlObject
    public MlModelServiceDAO mlModelServiceDAO();

    @CreateSqlObject
    public DashboardServiceDAO dashboardServiceDAO();

    @CreateSqlObject
    public MessagingServiceDAO messagingServiceDAO();

    @CreateSqlObject
    public StorageServiceDAO storageServiceDAO();

    @CreateSqlObject
    public ContainerDAO containerDAO();

    @CreateSqlObject
    public FeedDAO feedDAO();

    @CreateSqlObject
    public QueryDAO queryDAO();

    @CreateSqlObject
    public ChangeEventDAO changeEventDAO();

    @CreateSqlObject
    public TypeEntityDAO typeEntityDAO();

    @CreateSqlObject
    public TestDefinitionDAO testDefinitionDAO();

    @CreateSqlObject
    public TestConnectionDefinitionDAO testConnectionDefinitionDAO();

    @CreateSqlObject
    public TestSuiteDAO testSuiteDAO();

    @CreateSqlObject
    public TestCaseDAO testCaseDAO();

    @CreateSqlObject
    public WebAnalyticEventDAO webAnalyticEventDAO();

    @CreateSqlObject
    public DataInsightChartDAO dataInsightChartDAO();

    @CreateSqlObject
    public SystemDAO systemDAO();

    @CreateSqlObject
    public TokenDAO getTokenDAO();

    @CreateSqlObject
    public KpiDAO kpiDAO();

    @CreateSqlObject
    public WorkflowDAO workflowDAO();

    @CreateSqlObject
    public DataModelDAO dashboardDataModelDAO();

    public static interface DataModelDAO
    extends EntityDAO<DashboardDataModel> {
        @Override
        default public String getTableName() {
            return "dashboard_data_model_entity";
        }

        @Override
        default public Class<DashboardDataModel> getEntityClass() {
            return DashboardDataModel.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface WorkflowDAO
    extends EntityDAO<Workflow> {
        @Override
        default public String getTableName() {
            return "automations_workflow";
        }

        @Override
        default public Class<Workflow> getEntityClass() {
            return Workflow.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listBefore(this.getTableName(), this.getNameHashColumn(), sqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listAfter(this.getTableName(), this.getNameHashColumn(), sqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listCount(this.getTableName(), this.getNameHashColumn(), sqlCondition.toString());
        }

        @Override
        @SqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <sqlCondition> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>")
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

        @Override
        @SqlQuery(value="SELECT json FROM <table> <sqlCondition> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit")
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);

        @Override
        @SqlQuery(value="SELECT count(*) FROM <table> <sqlCondition>")
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3);
    }

    public static interface KpiDAO
    extends EntityDAO<Kpi> {
        @Override
        default public String getTableName() {
            return "kpi_entity";
        }

        @Override
        default public Class<Kpi> getEntityClass() {
            return Kpi.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface TokenDAO {
        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE token = :token")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public TokenInterface findByToken(@Bind(value="token") String var1) throws StatementException;

        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE userId = :userId AND tokenType = :tokenType ")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public List<TokenInterface> getAllUserTokenWithType(@Bind(value="userId") String var1, @Bind(value="tokenType") String var2) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = :json WHERE token = :token", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = (:json :: jsonb) WHERE token = :token", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="token") String var1, @Bind(value="json") String var2);

        @SqlUpdate(value="DELETE from user_tokens WHERE token = :token")
        public void delete(@Bind(value="token") String var1);

        @SqlUpdate(value="DELETE from user_tokens WHERE token IN (<tokenIds>)")
        public void deleteAll(@BindList(value="tokenIds") List<String> var1);

        @SqlUpdate(value="DELETE from user_tokens WHERE userid = :userid AND tokenType = :tokenType")
        public void deleteTokenByUserAndType(@Bind(value="userid") String var1, @Bind(value="tokenType") String var2);
    }

    public static class TokenRowMapper
    implements RowMapper<TokenInterface> {
        public TokenInterface map(ResultSet rs, StatementContext ctx) throws SQLException {
            try {
                return TokenRowMapper.getToken(TokenType.fromValue((String)rs.getString("tokenType")), rs.getString("json"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static TokenInterface getToken(TokenType type, String json) throws IOException {
            TokenInterface resp;
            switch (type) {
                case EMAIL_VERIFICATION: {
                    resp = (TokenInterface)JsonUtils.readValue(json, EmailVerificationToken.class);
                    break;
                }
                case PASSWORD_RESET: {
                    resp = (TokenInterface)JsonUtils.readValue(json, PasswordResetToken.class);
                    break;
                }
                case REFRESH_TOKEN: {
                    resp = (TokenInterface)JsonUtils.readValue(json, RefreshToken.class);
                    break;
                }
                case PERSONAL_ACCESS_TOKEN: {
                    resp = (TokenInterface)JsonUtils.readValue(json, PersonalAccessToken.class);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Token Type.");
                }
            }
            return resp;
        }
    }

    public static class SettingsRowMapper
    implements RowMapper<Settings> {
        public Settings map(ResultSet rs, StatementContext ctx) throws SQLException {
            return SettingsRowMapper.getSettings(SettingsType.fromValue((String)rs.getString("configType")), rs.getString("json"));
        }

        public static Settings getSettings(SettingsType configType, String json) {
            Object value;
            Settings settings = new Settings();
            settings.setConfigType(configType);
            try {
                switch (configType) {
                    case EMAIL_CONFIGURATION: {
                        value = JsonUtils.readValue(json, SmtpSettings.class);
                        break;
                    }
                    case CUSTOM_LOGO_CONFIGURATION: {
                        value = JsonUtils.readValue(json, LogoConfiguration.class);
                        break;
                    }
                    case SLACK_APP_CONFIGURATION: {
                        value = JsonUtils.readValue(json, String.class);
                        break;
                    }
                    case SLACK_BOT: 
                    case SLACK_INSTALLER: {
                        value = JsonUtils.readValue(json, new TypeReference<HashMap<String, Object>>(){});
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Settings Type " + configType);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            settings.setConfigValue(value);
            return settings;
        }
    }

    public static interface SystemDAO {
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM table_entity <cond>) as tableCount, (SELECT COUNT(*) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(*) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(*) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(*) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT COUNT(*) FROM storage_container_entity <cond>) as storageContainerCount, (SELECT COUNT(*) FROM glossary_entity <cond>) as glossaryCount, (SELECT COUNT(*) FROM glossary_term_entity <cond>) as glossaryTermCount, (SELECT (SELECT COUNT(*) FROM metadata_service_entity <cond>) + (SELECT COUNT(*) FROM dbservice_entity <cond>)+(SELECT COUNT(*) FROM messaging_service_entity <cond>)+ (SELECT COUNT(*) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(*) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(*) FROM mlmodel_service_entity <cond>)+ (SELECT COUNT(*) FROM storage_service_entity <cond>)) as servicesCount, (SELECT COUNT(*) FROM user_entity <cond> AND (JSON_EXTRACT(json, '$.isBot') IS NULL OR JSON_EXTRACT(json, '$.isBot') = FALSE)) as userCount, (SELECT COUNT(*) FROM team_entity <cond>) as teamCount, (SELECT COUNT(*) FROM test_suite <cond>) as testSuiteCount", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM table_entity <cond>) as tableCount, (SELECT COUNT(*) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(*) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(*) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(*) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT COUNT(*) FROM storage_container_entity <cond>) as storageContainerCount, (SELECT COUNT(*) FROM glossary_entity <cond>) as glossaryCount, (SELECT COUNT(*) FROM glossary_term_entity <cond>) as glossaryTermCount, (SELECT (SELECT COUNT(*) FROM metadata_service_entity <cond>) + (SELECT COUNT(*) FROM dbservice_entity <cond>)+ (SELECT COUNT(*) FROM messaging_service_entity <cond>)+ (SELECT COUNT(*) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(*) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(*) FROM mlmodel_service_entity <cond>)+ (SELECT COUNT(*) FROM storage_service_entity <cond>)) as servicesCount, (SELECT COUNT(*) FROM user_entity <cond> AND (json#>'{isBot}' IS NULL OR ((json#>'{isBot}')::boolean) = FALSE)) as userCount, (SELECT COUNT(*) FROM team_entity <cond>) as teamCount, (SELECT COUNT(*) FROM test_suite <cond>) as testSuiteCount", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=EntitiesCountRowMapper.class)
        public EntitiesCount getAggregatedEntitiesCount(@Define(value="cond") String var1) throws StatementException;

        @SqlQuery(value="SELECT (SELECT COUNT(*) FROM database_entity <cond>) as databaseServiceCount, (SELECT COUNT(*) FROM messaging_service_entity <cond>) as messagingServiceCount, (SELECT COUNT(*) FROM dashboard_service_entity <cond>) as dashboardServiceCount, (SELECT COUNT(*) FROM pipeline_service_entity <cond>) as pipelineServiceCount, (SELECT COUNT(*) FROM mlmodel_service_entity <cond>) as mlModelServiceCount, (SELECT COUNT(*) FROM storage_service_entity <cond>) as storageServiceCount")
        @RegisterRowMapper(value=ServicesCountRowMapper.class)
        public ServicesCount getAggregatedServicesCount(@Define(value="cond") String var1) throws StatementException;

        @SqlQuery(value="SELECT configType,json FROM openmetadata_settings")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public List<Settings> getAllConfig() throws StatementException;

        @SqlQuery(value="SELECT configType, json FROM openmetadata_settings WHERE configType = :configType")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public Settings getConfigWithKey(@Bind(value="configType") String var1) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json :: jsonb) ON CONFLICT (configType) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insertSettings(@Bind(value="configType") String var1, @Bind(value="json") String var2);

        @SqlUpdate(value="DELETE from openmetadata_settings WHERE configType = :configType")
        public void delete(@Bind(value="configType") String var1);
    }

    public static class ServicesCountRowMapper
    implements RowMapper<ServicesCount> {
        public ServicesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ServicesCount().withDatabaseServiceCount(Integer.valueOf(rs.getInt("databaseServiceCount"))).withMessagingServiceCount(Integer.valueOf(rs.getInt("messagingServiceCount"))).withDashboardServiceCount(Integer.valueOf(rs.getInt("dashboardServiceCount"))).withPipelineServiceCount(Integer.valueOf(rs.getInt("pipelineServiceCount"))).withMlModelServiceCount(Integer.valueOf(rs.getInt("mlModelServiceCount"))).withStorageServiceCount(Integer.valueOf(rs.getInt("storageServiceCount")));
        }
    }

    public static class EntitiesCountRowMapper
    implements RowMapper<EntitiesCount> {
        public EntitiesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new EntitiesCount().withTableCount(Integer.valueOf(rs.getInt("tableCount"))).withTopicCount(Integer.valueOf(rs.getInt("topicCount"))).withDashboardCount(Integer.valueOf(rs.getInt("dashboardCount"))).withPipelineCount(Integer.valueOf(rs.getInt("pipelineCount"))).withMlmodelCount(Integer.valueOf(rs.getInt("mlmodelCount"))).withServicesCount(Integer.valueOf(rs.getInt("servicesCount"))).withUserCount(Integer.valueOf(rs.getInt("userCount"))).withTeamCount(Integer.valueOf(rs.getInt("teamCount"))).withTestSuiteCount(Integer.valueOf(rs.getInt("testSuiteCount"))).withStorageContainerCount(Integer.valueOf(rs.getInt("storageContainerCount"))).withGlossaryCount(Integer.valueOf(rs.getInt("glossaryCount"))).withGlossaryTermCount(Integer.valueOf(rs.getInt("glossaryTermCount")));
        }
    }

    public static interface EntityExtensionTimeSeriesDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension_time_series(entityFQNHash, extension, jsonSchema, json) VALUES (:entityFQNHash, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension_time_series(entityFQNHash, extension, jsonSchema, json) VALUES (:entityFQNHash, :extension, :jsonSchema, (:json :: jsonb))", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = :json where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = (:json :: jsonb) where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="json") String var3, @Bind(value="timestamp") Long var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = :json where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp and json -> '$.operation' = :operation", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = (:json :: jsonb) where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp and json #>>'{operation}' = :operation", connectionType=ConnectionType.POSTGRES)})
        public void updateExtensionByOperation(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="json") String var3, @Bind(value="timestamp") Long var4, @Bind(value="operation") String var5);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension")
        public String getExtension(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2);

        @SqlQuery(value="SELECT count(*) FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash")
        public int listCount(@Bind(value="entityFQNHash") String var1);

        @SqlQuery(value="SELECT COUNT(DISTINCT entityFQN) FROM entity_extension_time_series")
        @Deprecated
        public int listDistinctCount();

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num < :before LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num < (:before :: integer) LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=ReportDataMapper.class)
        public List<ReportDataRow> getBeforeExtension(@Bind(value="entityFQNHash") String var1, @Bind(value="limit") int var2, @Bind(value="before") String var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num > :after LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num > (:after :: integer) LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=ReportDataMapper.class)
        public List<ReportDataRow> getAfterExtension(@Bind(value="entityFQNHash") String var1, @Bind(value="limit") int var2, @Bind(value="after") String var3);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp")
        public String getExtensionAtTimestamp(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") long var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp AND json -> '$.operation' = :operation", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp AND json #>>'{operation}' = :operation", connectionType=ConnectionType.POSTGRES)})
        public String getExtensionAtTimestampWithOperation(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") long var3, @Bind(value="operation") String var5);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension ORDER BY timestamp DESC LIMIT 1")
        public String getLatestExtension(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2);

        @SqlQuery(value="SELECT ranked.json FROM (SELECT json, ROW_NUMBER() OVER(PARTITION BY entityFQNHash ORDER BY timestamp DESC) AS row_num FROM entity_extension_time_series WHERE entityFQNHash IN (<entityFQNHashes>) AND extension = :extension) ranked WHERE ranked.row_num = 1")
        public List<String> getLatestExtensionByFQNs(@BindList(value="entityFQNHashes") List<String> var1, @Bind(value="extension") String var2);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE extension = :extension ORDER BY timestamp DESC LIMIT 1")
        public String getLatestByExtension(@Bind(value="extension") String var1);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE extension = :extension ORDER BY timestamp DESC")
        public List<String> getAllByExtension(@Bind(value="extension") String var1);

        @RegisterRowMapper(value=ExtensionMapper.class)
        @SqlQuery(value="SELECT extension, json FROM entity_extension WHERE id = :id AND extension LIKE CONCAT (:extensionPrefix, '.%') ORDER BY extension")
        public List<ExtensionRecord> getExtensions(@Bind(value="id") String var1, @Bind(value="extensionPrefix") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash")
        public void deleteAll(@Bind(value="entityFQNHash") String var1);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension")
        public void delete(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE extension = :extension AND entityFQNHash NOT IN(SELECT entityFQNHash FROM (select * from entity_extension_time_series WHERE extension = :extension ORDER BY timestamp DESC LIMIT :records) AS subquery)")
        public void deleteLastRecords(@Bind(value="extension") String var1, @Bind(value="records") int var2);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp")
        public void deleteAtTimestamp(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") Long var3);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp < :timestamp")
        public void deleteBeforeTimestamp(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") Long var3);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND jsonSchema = :jsonSchema ORDER BY timestamp DESC LIMIT 1")
        public String getLatestExtensionByFQN(@Bind(value="entityFQNHash") String var1, @Bind(value="jsonSchema") String var2);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series where entityFQNHash = :entityFQNHash and jsonSchema = :jsonSchema  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp DESC")
        public List<String> listBetweenTimestampsByFQN(@Bind(value="entityFQNHash") String var1, @Bind(value="jsonSchema") String var2, @Bind(value="startTs") Long var3, @Bind(value="endTs") long var4);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series where entityFQNHash = :entityFQNHash and extension = :extension  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp DESC")
        public List<String> listBetweenTimestamps(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="startTs") Long var3, @Bind(value="endTs") long var4);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series where entityFQNHash = :entityFQNHash and extension = :extension  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp <orderBy>")
        public List<String> listBetweenTimestampsByOrder(@Bind(value="entityFQNHash") String var1, @Bind(value="extension") String var2, @Bind(value="startTs") Long var3, @Bind(value="endTs") long var4, @Define(value="orderBy") OrderBy var6);

        default public void updateExtensionByKey(String key, String value, String entityFQN, String extension, String json) {
            String entityFQNHash = FullyQualifiedName.buildHash(entityFQN);
            String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
            String psqlCond = String.format("AND json->>'%s' = :value", key);
            this.updateExtensionByKeyInternal(value, entityFQNHash, extension, json, mysqlCond, psqlCond);
        }

        default public String getExtensionByKey(String key, String value, String entityFQNHash, String extension) {
            String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
            String psqlCond = String.format("AND json->>'%s' = :value", key);
            return this.getExtensionByKeyInternal(value, entityFQNHash, extension, mysqlCond, psqlCond);
        }

        default public String getLatestExtensionByKey(String key, String value, String entityFQN, String extension) {
            String entityFQNHash = FullyQualifiedName.buildHash(entityFQN);
            String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
            String psqlCond = String.format("AND json->>'%s' = :value", key);
            return this.getLatestExtensionByKeyInternal(value, entityFQNHash, extension, mysqlCond, psqlCond);
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series SET json = :json WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series SET json = (:json :: jsonb) WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond>", connectionType=ConnectionType.POSTGRES)})
        public void updateExtensionByKeyInternal(@Bind(value="value") String var1, @Bind(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="json") String var4, @Define(value="mysqlCond") String var5, @Define(value="psqlCond") String var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json from entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json from entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond>", connectionType=ConnectionType.POSTGRES)})
        public String getExtensionByKeyInternal(@Bind(value="value") String var1, @Bind(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Define(value="mysqlCond") String var4, @Define(value="psqlCond") String var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json from entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond> ORDER BY timestamp DESC LIMIT 1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json from entity_extension_time_series WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond> ORDER BY timestamp DESC LIMIT 1", connectionType=ConnectionType.POSTGRES)})
        public String getLatestExtensionByKeyInternal(@Bind(value="value") String var1, @Bind(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Define(value="mysqlCond") String var4, @Define(value="psqlCond") String var5);

        @SqlQuery(value="SELECT DISTINCT entityFQN FROM entity_extension_time_series WHERE entityFQNHash = '' or entityFQNHash is null LIMIT :limit")
        @Deprecated
        public List<String> migrationListDistinctWithOffset(@Bind(value="limit") int var1);

        public static class ReportDataMapper
        implements RowMapper<ReportDataRow> {
            public ReportDataRow map(ResultSet rs, StatementContext ctx) throws SQLException {
                ReportData reportData;
                String rowNumber = rs.getString("row_num");
                String json = rs.getString("json");
                try {
                    reportData = JsonUtils.readValue(json, ReportData.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new ReportDataRow(rowNumber, reportData);
            }
        }

        public static enum OrderBy {
            ASC,
            DESC;

        }
    }

    public static interface DataInsightChartDAO
    extends EntityDAO<DataInsightChart> {
        @Override
        default public String getTableName() {
            return "data_insight_chart";
        }

        @Override
        default public Class<DataInsightChart> getEntityClass() {
            return DataInsightChart.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface WebAnalyticEventDAO
    extends EntityDAO<WebAnalyticEvent> {
        @Override
        default public String getTableName() {
            return "web_analytic_event";
        }

        @Override
        default public Class<WebAnalyticEvent> getEntityClass() {
            return WebAnalyticEvent.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TestCaseDAO
    extends EntityDAO<TestCase> {
        @Override
        default public String getTableName() {
            return "test_case";
        }

        @Override
        default public Class<TestCase> getEntityClass() {
            return TestCase.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        default public int countOfTestCases(List<UUID> testCaseIds) {
            return this.countOfTestCases(this.getTableName(), testCaseIds.stream().map(Object::toString).collect(Collectors.toList()));
        }

        @SqlQuery(value="SELECT count(*) FROM <table> WHERE id IN (<testCaseIds>)")
        public int countOfTestCases(@Define(value="table") String var1, @BindList(value="testCaseIds") List<String> var2);
    }

    public static interface TestSuiteDAO
    extends EntityDAO<TestSuite> {
        @Override
        default public String getTableName() {
            return "test_suite";
        }

        @Override
        default public Class<TestSuite> getEntityClass() {
            return TestSuite.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TestDefinitionDAO
    extends EntityDAO<TestDefinition> {
        @Override
        default public String getTableName() {
            return "test_definition";
        }

        @Override
        default public Class<TestDefinition> getEntityClass() {
            return TestDefinition.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listBefore(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listAfter(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString());
        }

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <mysqlCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <psqlCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> <mysqlCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> <psqlCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <psqlCond>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4);
    }

    public static interface TypeEntityDAO
    extends EntityDAO<Type> {
        @Override
        default public String getTableName() {
            return "type_entity";
        }

        @Override
        default public Class<Type> getEntityClass() {
            return Type.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface ChangeEventDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlUpdate(value="DELETE FROM change_event WHERE entityType = :entityType")
        public void deleteAll(@Bind(value="entityType") String var1);

        default public List<String> list(String eventType, List<String> entityTypes, long timestamp) {
            if (CommonUtil.nullOrEmpty(entityTypes)) {
                return Collections.emptyList();
            }
            if (entityTypes.get(0).equals("*")) {
                return this.listWithoutEntityFilter(eventType, timestamp);
            }
            return this.listWithEntityFilter(eventType, entityTypes, timestamp);
        }

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND (entityType IN (<entityTypes>)) AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithEntityFilter(@Bind(value="eventType") String var1, @BindList(value="entityTypes") List<String> var2, @Bind(value="timestamp") long var3);

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithoutEntityFilter(@Bind(value="eventType") String var1, @Bind(value="timestamp") long var2);
    }

    public static interface UserDAO
    extends EntityDAO<User> {
        @Override
        default public String getTableName() {
            return "user_entity";
        }

        @Override
        default public Class<User> getEntityClass() {
            return User.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String team = FullyQualifiedName.buildHash(EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team")));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean)  = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listCount(filter);
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String team = FullyQualifiedName.buildHash(EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team")));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, limit, before, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String team = FullyQualifiedName.buildHash(EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team")));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, limit, after, Relationship.HAS.ordinal());
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond>  AND (:team IS NULL OR te.nameHash = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond>  AND (:team IS NULL OR te.nameHash = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="relation") int var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.<nameColumn>, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.<nameColumn> < :before GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.<nameColumn>, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.<nameColumn> < :before GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="limit") int var6, @Bind(value="before") String var7, @Bind(value="relation") int var8);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.<nameColumn> > :after GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.<nameColumn> > :after GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="limit") int var6, @Bind(value="after") String var7, @Bind(value="relation") int var8);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM user_entity WHERE email = :email", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM user_entity WHERE email = :email", connectionType=ConnectionType.POSTGRES)})
        public int checkEmailExists(@Bind(value="email") String var1);

        @SqlQuery(value="SELECT json FROM user_entity WHERE email = :email")
        public String findUserByEmail(@Bind(value="email") String var1);
    }

    @RegisterRowMapper(value=UsageDetailsMapper.class)
    public static interface UsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY))ON DUPLICATE KEY UPDATE count7 = count7 - count1 + :count1, count30 = count30 - count1 + :count1, count1 = :count1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days'))ON CONFLICT (usageDate, id) DO UPDATE SET count7 = entity_usage.count7 - entity_usage.count1 + :count1,count30 = entity_usage.count30 - entity_usage.count1 + :count1, count1 = :count1", connectionType=ConnectionType.POSTGRES)})
        public void insertOrReplaceCount(@Bind(value="date") String var1, @Bind(value="id") String var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY)) ON DUPLICATE KEY UPDATE count1 = count1 + :count1, count7 = count7 + :count1, count30 = count30 + :count1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days')) ON CONFLICT (usageDate, id) DO UPDATE SET count1 = entity_usage.count1 + :count1, count7 = entity_usage.count7 + :count1, count30 = entity_usage.count30 + :count1", connectionType=ConnectionType.POSTGRES)})
        public void insertOrUpdateCount(@Bind(value="date") String var1, @Bind(value="id") String var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL :days DAY AND usageDate <= :date ORDER BY usageDate DESC", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - make_interval(days => :days) AND usageDate <= (:date :: date) ORDER BY usageDate DESC", connectionType=ConnectionType.POSTGRES)})
        public List<UsageDetails> getUsageById(@Bind(value="id") String var1, @Bind(value="date") String var2, @Bind(value="days") int var3);

        @SqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE usageDate IN (SELECT MAX(usageDate) FROM entity_usage WHERE id = :id) AND id = :id")
        public UsageDetails getLatestUsage(@Bind(value="id") String var1);

        @SqlUpdate(value="DELETE FROM entity_usage WHERE id = :id")
        public void delete(@Bind(value="id") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_usage u JOIN ( SELECT u1.id, (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 <  u1.count1 AND u2.entityType = :entityType AND u2.usageDate = :date) as p1, (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 <  u1.count7 AND u3.entityType = :entityType AND u3.usageDate = :date) as p7, (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 <  u1.count30 AND u4.entityType = :entityType AND u4.usageDate = :date) as p30, (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = :date) as total FROM entity_usage u1 WHERE u1.entityType = :entityType AND u1.usageDate = :date) vals ON u.id = vals.id AND usageDate = :date SET u.percentile1 = ROUND(100 * p1/total, 2), u.percentile7 = ROUND(p7 * 100/total, 2), u.percentile30 = ROUND(p30*100/total, 2)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_usage u SET percentile1 = ROUND(100 * p1 / total, 2), percentile7 = ROUND(p7 * 100 / total, 2), percentile30 = ROUND(p30 * 100 / total, 2) FROM (   SELECT u1.id,        (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 < u1.count1 AND u2.entityType = :entityType AND u2.usageDate = (:date :: date)) as p1,        (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 < u1.count7 AND u3.entityType = :entityType AND u3.usageDate = (:date :: date)) as p7,        (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 < u1.count30 AND u4.entityType = :entityType AND u4.usageDate = (:date :: date)) as p30,        (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = (:date :: date)   ) as total FROM entity_usage u1    WHERE u1.entityType = :entityType AND u1.usageDate = (:date :: date)) vals WHERE u.id = vals.id AND usageDate = (:date :: date);", connectionType=ConnectionType.POSTGRES)})
        public void computePercentile(@Bind(value="entityType") String var1, @Bind(value="date") String var2);

        public static class UsageDetailsMapper
        implements RowMapper<UsageDetails> {
            public UsageDetails map(ResultSet r, StatementContext ctx) throws SQLException {
                UsageStats dailyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count1"))).withPercentileRank(Double.valueOf(r.getDouble("percentile1")));
                UsageStats weeklyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count7"))).withPercentileRank(Double.valueOf(r.getDouble("percentile7")));
                UsageStats monthlyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count30"))).withPercentileRank(Double.valueOf(r.getDouble("percentile30")));
                return new UsageDetails().withDate(r.getString("usageDate")).withDailyStats(dailyStats).withWeeklyStats(weeklyStats).withMonthlyStats(monthlyStats);
            }
        }
    }

    public static interface TopicDAO
    extends EntityDAO<Topic> {
        @Override
        default public String getTableName() {
            return "topic_entity";
        }

        @Override
        default public Class<Topic> getEntityClass() {
            return Topic.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TeamDAO
    extends EntityDAO<Team> {
        @Override
        default public String getTableName() {
            return "team_entity";
        }

        @Override
        default public Class<Team> getEntityClass() {
            return Team.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam);
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            before = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(before) : before;
            return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            after = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(after) : after;
            return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, after);
        }

        default public List<String> listTeamsUnderOrganization(String teamId) {
            return this.listTeamsUnderOrganization(teamId, Relationship.PARENT_OF.ordinal());
        }

        @SqlQuery(value="SELECT te.id FROM team_entity te WHERE te.id NOT IN (SELECT :teamId) UNION (SELECT toId FROM entity_relationship WHERE fromId != :teamId AND fromEntity = 'team' AND relation = :relation AND toEntity = 'team')")
        public List<String> listTeamsUnderOrganization(@Bind(value="teamId") String var1, @Bind(value="relation") int var2);
    }

    public static interface RoleDAO
    extends EntityDAO<Role> {
        @Override
        default public String getTableName() {
            return "role_entity";
        }

        @Override
        default public Class<Role> getEntityClass() {
            return Role.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    @RegisterRowMapper(value=TagLabelMapper.class)
    public static interface TagUsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state) ON CONFLICT (source, tagFQNHash, targetFQNHash) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void applyTag(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2, @Bind(value="tagFQNHash") String var3, @Bind(value="targetFQNHash") String var4, @Bind(value="labelType") int var5, @Bind(value="state") int var6);

        @SqlQuery(value="SELECT targetFQNHash FROM tag_usage WHERE source = :source AND tagFQNHash = :tagFQNHash")
        public List<String> getTargetFQNs(@Bind(value="source") int var1, @Bind(value="tagFQNHash") String var2);

        default public List<TagLabel> getTags(String targetFQN) {
            List<TagLabel> tags = this.getTagsInternal(FullyQualifiedName.buildHash(targetFQN));
            tags.forEach(tagLabel -> tagLabel.setDescription(TagLabelCache.getInstance().getDescription((TagLabel)tagLabel)));
            return tags;
        }

        @SqlQuery(value="SELECT source, tagFQN,  labelType, state FROM tag_usage WHERE targetFQNHash = :targetFQNHash ORDER BY tagFQN")
        public List<TagLabel> getTagsInternal(@Bind(value="targetFQNHash") String var1);

        @SqlQuery(value="SELECT * FROM tag_usage")
        @Deprecated(since="Release 1.1")
        @RegisterRowMapper(value=TagLabelMapperMigration.class)
        public List<TagLabelMigration> listAll();

        @SqlQuery(value="SELECT COUNT(*) FROM tag_usage WHERE (tagFQNHash LIKE CONCAT(:tagFqnHash, '.%') OR tagFQNHash = :tagFqnHash) AND source = :source")
        public int getTagCount(@Bind(value="source") int var1, @Bind(value="tagFqnHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQNHash = :targetFQNHash")
        public void deleteTagsByTarget(@Bind(value="targetFQNHash") String var1);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash = :tagFQNHash AND source = :source")
        public void deleteTagLabels(@Bind(value="source") int var1, @Bind(value="tagFQNHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash = :tagFQNHash")
        public void deleteTagLabelsByFqn(@Bind(value="tagFQNHash") String var1);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash LIKE CONCAT(:tagFQNHash, '.%') AND source = :source")
        public void deleteTagLabelsByPrefix(@Bind(value="source") int var1, @Bind(value="tagFQNHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQNHash = :targetFQNHash OR targetFQNHash LIKE CONCAT(:targetFQNHash, '.%')")
        public void deleteTagLabelsByTargetPrefix(@Bind(value="targetFQNHash") String var1);

        @Deprecated(since="Release 1.1")
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state, targetFQN)VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state, :targetFQN) ON DUPLICATE KEY UPDATE tagFQNHash = :tagFQNHash, targetFQNHash = :targetFQNHash", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state, targetFQN) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state, :targetFQN) ON CONFLICT (source, tagFQN, targetFQN) DO UPDATE SET tagFQNHash = EXCLUDED.tagFQNHash, targetFQNHash = EXCLUDED.targetFQNHash", connectionType=ConnectionType.POSTGRES)})
        public void upsertFQNHash(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2, @Bind(value="tagFQNHash") String var3, @Bind(value="targetFQNHash") String var4, @Bind(value="labelType") int var5, @Bind(value="state") int var6, @Bind(value="targetFQN") String var7);

        default public void updateTagPrefix(int source, String oldPrefix, String newPrefix) {
            String update = String.format("UPDATE tag_usage SET tagFQN = REPLACE(tagFQN, '%s.', '%s.'), tagFQNHash = REPLACE(tagFQNHash, '%s.', '%s.') WHERE source = %s AND tagFQNHash LIKE '%s.%%'", ListFilter.escapeApostrophe(oldPrefix), ListFilter.escapeApostrophe(newPrefix), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), source, FullyQualifiedName.buildHash(oldPrefix));
            this.updateTagPrefixInternal(update);
        }

        default public void rename(int source, String oldFQN, String newFQN) {
            this.renameInternal(source, FullyQualifiedName.buildHash(oldFQN), newFQN, FullyQualifiedName.buildHash(newFQN));
            this.updateTagPrefix(source, oldFQN, newFQN);
        }

        @SqlUpdate(value="Update tag_usage set tagFQN = :newFQN, tagFQNHash = :newFQNHash WHERE source = :source AND tagFQNHash = :oldFQNHash")
        public void renameInternal(@Bind(value="source") int var1, @Bind(value="oldFQNHash") String var2, @Bind(value="newFQN") String var3, @Bind(value="newFQNHash") String var4);

        @SqlUpdate(value="<update>")
        public void updateTagPrefixInternal(@Define(value="update") String var1);

        @Deprecated(since="Release 1.1")
        public static class TagLabelMapperMigration
        implements RowMapper<TagLabelMigration> {
            public TagLabelMigration map(ResultSet r, StatementContext ctx) throws SQLException {
                TagLabelMigration tagLabel = new TagLabelMigration();
                tagLabel.setSource(r.getInt("source"));
                tagLabel.setLabelType(r.getInt("labelType"));
                tagLabel.setState(r.getInt("state"));
                tagLabel.setTagFQN(r.getString("tagFQN"));
                try {
                    tagLabel.setTargetFQN(r.getString("targetFQN"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tagLabel.setTagFQNHash(r.getString("tagFQNHash"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tagLabel.setTargetFQNHash(r.getString("targetFQNHash"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return tagLabel;
            }
        }

        @Deprecated(since="Release 1.1")
        public static class TagLabelMigration {
            public int source;
            public String tagFQN;
            public String targetFQN;
            public int labelType;
            public int state;
            private String tagFQNHash;
            public String targetFQNHash;

            public int getSource() {
                return this.source;
            }

            public String getTagFQN() {
                return this.tagFQN;
            }

            public String getTargetFQN() {
                return this.targetFQN;
            }

            public int getLabelType() {
                return this.labelType;
            }

            public int getState() {
                return this.state;
            }

            public String getTagFQNHash() {
                return this.tagFQNHash;
            }

            public String getTargetFQNHash() {
                return this.targetFQNHash;
            }

            public void setSource(int source) {
                this.source = source;
            }

            public void setTagFQN(String tagFQN) {
                this.tagFQN = tagFQN;
            }

            public void setTargetFQN(String targetFQN) {
                this.targetFQN = targetFQN;
            }

            public void setLabelType(int labelType) {
                this.labelType = labelType;
            }

            public void setState(int state) {
                this.state = state;
            }

            public void setTagFQNHash(String tagFQNHash) {
                this.tagFQNHash = tagFQNHash;
            }

            public void setTargetFQNHash(String targetFQNHash) {
                this.targetFQNHash = targetFQNHash;
            }
        }

        public static class TagLabelMapper
        implements RowMapper<TagLabel> {
            public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
                return new TagLabel().withSource(TagLabel.TagSource.values()[r.getInt("source")]).withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
            }
        }
    }

    public static interface TagDAO
    extends EntityDAO<Tag> {
        @Override
        default public String getTableName() {
            return "tag";
        }

        @Override
        default public Class<Tag> getEntityClass() {
            return Tag.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @SqlUpdate(value="DELETE FROM tag where fqnHash LIKE CONCAT(:fqnHashPrefix, '.%')")
        public void deleteTagsByPrefix(@Bind(value="fqnHashPrefix") String var1);

        @Override
        default public int listCount(ListFilter filter) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean) = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean) = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, after);
        }
    }

    public static interface ClassificationDAO
    extends EntityDAO<Classification> {
        @Override
        default public String getTableName() {
            return "classification";
        }

        @Override
        default public Class<Classification> getEntityClass() {
            return Classification.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface PipelineDAO
    extends EntityDAO<Pipeline> {
        @Override
        default public String getTableName() {
            return "pipeline_entity";
        }

        @Override
        default public Class<Pipeline> getEntityClass() {
            return Pipeline.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface QueryDAO
    extends EntityDAO<Query> {
        @Override
        default public String getTableName() {
            return "query_entity";
        }

        @Override
        default public Class<Query> getEntityClass() {
            return Query.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :id and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntityType", condition);
                bindMap.put("id", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntityType", "query");
                return this.listQueryCount(condition, bindMap);
            }
            return EntityDAO.super.listCount(filter);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :entityId and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntity and query_entity.name < :before order by query_entity.name DESC LIMIT :limit", condition);
                bindMap.put("entityId", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntity", "query");
                bindMap.put("before", before);
                bindMap.put("limit", limit);
                return this.listBeforeQueriesByEntityId(condition, bindMap);
            }
            return EntityDAO.super.listBefore(filter, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :entityId and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntity and query_entity.name > :after order by query_entity.name ASC LIMIT :limit", condition);
                bindMap.put("entityId", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntity", "query");
                bindMap.put("after", after);
                bindMap.put("limit", limit);
                return this.listAfterQueriesByEntityId(condition, bindMap);
            }
            return EntityDAO.super.listAfter(filter, limit, after);
        }

        @SqlQuery(value="SELECT query_entity.json FROM query_entity <cond>")
        public List<String> listAfterQueriesByEntityId(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT json FROM (SELECT query_entity.name, query_entity.json FROM query_entity <cond>) last_rows_subquery ORDER BY name")
        public List<String> listBeforeQueriesByEntityId(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT count(*) FROM query_entity <cond> ")
        public int listQueryCount(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);
    }

    public static interface TableDAO
    extends EntityDAO<Table> {
        @Override
        default public String getTableName() {
            return "table_entity";
        }

        @Override
        default public Class<Table> getEntityClass() {
            return Table.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listCount(this.getTableName(), this.getNameColumn(), condition, condition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, before);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listBefore(this.getTableName(), this.getNameColumn(), condition, condition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, after);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listAfter(this.getTableName(), this.getNameColumn(), condition, condition, limit, after);
        }
    }

    public static interface ReportDAO
    extends EntityDAO<Report> {
        @Override
        default public String getTableName() {
            return "report_entity";
        }

        @Override
        default public Class<Report> getEntityClass() {
            return Report.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface PolicyDAO
    extends EntityDAO<Policy> {
        @Override
        default public String getTableName() {
            return "policy_entity";
        }

        @Override
        default public Class<Policy> getEntityClass() {
            return Policy.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MlModelServiceDAO
    extends EntityDAO<MlModelService> {
        @Override
        default public String getTableName() {
            return "mlmodel_service_entity";
        }

        @Override
        default public Class<MlModelService> getEntityClass() {
            return MlModelService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface PipelineServiceDAO
    extends EntityDAO<PipelineService> {
        @Override
        default public String getTableName() {
            return "pipeline_service_entity";
        }

        @Override
        default public Class<PipelineService> getEntityClass() {
            return PipelineService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface IngestionPipelineDAO
    extends EntityDAO<IngestionPipeline> {
        @Override
        default public String getTableName() {
            return "ingestion_pipeline_entity";
        }

        @Override
        default public Class<IngestionPipeline> getEntityClass() {
            return IngestionPipeline.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String serviceType = filter.getQueryParam("serviceType");
            String service = filter.getQueryParam("service");
            Object condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                if (filter.getQueryParam("pipelineType") != null) {
                    String pipelineTypeCondition = String.format(" and %s", filter.getPipelineTypeCondition(null));
                    condition = (String)condition + pipelineTypeCondition;
                }
                condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.fullyQualifiedName LIKE :service", condition);
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("service", service + ".%");
                bindMap.put("serviceType", serviceType);
                return this.listIngestionPipelineCount((String)condition, bindMap);
            }
            return EntityDAO.super.listCount(filter);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String serviceType = filter.getQueryParam("serviceType");
            String service = filter.getQueryParam("service");
            String condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                if (filter.getQueryParam("pipelineType") != null) {
                    String pipelineTypeCondition = filter.getPipelineTypeCondition(null);
                    condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.fullyQualifiedName LIKE :service and ingestion_pipeline_entity.fullyQualifiedName > :after and %s order by ingestion_pipeline_entity.fullyQualifiedName ASC LIMIT :limit", condition, pipelineTypeCondition);
                } else {
                    condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.fullyQualifiedName LIKE :service and ingestion_pipeline_entity.fullyQualifiedName > :after order by ingestion_pipeline_entity.fullyQualifiedName ASC LIMIT :limit", condition);
                }
                bindMap.put("serviceType", serviceType);
                bindMap.put("service", service + ".%");
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("after", after);
                bindMap.put("limit", limit);
                return this.listAfterIngestionPipelineByserviceType(condition, bindMap);
            }
            return EntityDAO.super.listAfter(filter, limit, after);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String service = filter.getQueryParam("service");
            String serviceType = filter.getQueryParam("serviceType");
            String condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                if (filter.getQueryParam("pipelineType") != null) {
                    String pipelineTypeCondition = filter.getPipelineTypeCondition(null);
                    condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.fullyQualifiedName LIKE :service and ingestion_pipeline_entity.fullyQualifiedName < :before and %s order by ingestion_pipeline_entity.fullyQualifiedName DESC LIMIT :limit", condition, pipelineTypeCondition);
                } else {
                    condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.fullyQualifiedName LIKE :service and ingestion_pipeline_entity.fullyQualifiedName < :before order by ingestion_pipeline_entity.fullyQualifiedName DESC LIMIT :limit", condition);
                }
                bindMap.put("serviceType", serviceType);
                bindMap.put("service", service + ".%");
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("before", before);
                bindMap.put("limit", limit);
                return this.listBeforeIngestionPipelineByserviceType(condition, bindMap);
            }
            return EntityDAO.super.listBefore(filter, limit, before);
        }

        @SqlQuery(value="SELECT ingestion_pipeline_entity.json FROM ingestion_pipeline_entity <cond>")
        public List<String> listAfterIngestionPipelineByserviceType(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT json FROM (SELECT ingestion_pipeline_entity.fullyQualifiedName, ingestion_pipeline_entity.json FROM ingestion_pipeline_entity <cond>) last_rows_subquery ORDER BY fullyQualifiedName")
        public List<String> listBeforeIngestionPipelineByserviceType(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT count(*) FROM ingestion_pipeline_entity <cond> ")
        public int listIngestionPipelineCount(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);
    }

    public static interface GlossaryTermDAO
    extends EntityDAO<GlossaryTerm> {
        @Override
        default public String getTableName() {
            return "glossary_term_entity";
        }

        @Override
        default public Class<GlossaryTerm> getEntityClass() {
            return GlossaryTerm.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface GlossaryDAO
    extends EntityDAO<Glossary> {
        @Override
        default public String getTableName() {
            return "glossary_entity";
        }

        @Override
        default public Class<Glossary> getEntityClass() {
            return Glossary.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface MlModelDAO
    extends EntityDAO<MlModel> {
        @Override
        default public String getTableName() {
            return "ml_model_entity";
        }

        @Override
        default public Class<MlModel> getEntityClass() {
            return MlModel.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MetricsDAO
    extends EntityDAO<Metrics> {
        @Override
        default public String getTableName() {
            return "metric_entity";
        }

        @Override
        default public Class<Metrics> getEntityClass() {
            return Metrics.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MessagingServiceDAO
    extends EntityDAO<MessagingService> {
        @Override
        default public String getTableName() {
            return "messaging_service_entity";
        }

        @Override
        default public Class<MessagingService> getEntityClass() {
            return MessagingService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface ChartDAO
    extends EntityDAO<Chart> {
        @Override
        default public String getTableName() {
            return "chart_entity";
        }

        @Override
        default public Class<Chart> getEntityClass() {
            return Chart.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface EventSubscriptionDAO
    extends EntityDAO<EventSubscription> {
        @Override
        default public String getTableName() {
            return "event_subscription_entity";
        }

        @Override
        default public Class<EventSubscription> getEntityClass() {
            return EventSubscription.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @SqlQuery(value="SELECT json FROM <table>")
        public List<String> listAllEventsSubscriptions(@Define(value="table") String var1);
    }

    public static interface DataProductDAO
    extends EntityDAO<DataProduct> {
        @Override
        default public String getTableName() {
            return "data_product_entity";
        }

        @Override
        default public Class<DataProduct> getEntityClass() {
            return DataProduct.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface DomainDAO
    extends EntityDAO<Domain> {
        @Override
        default public String getTableName() {
            return "domain_entity";
        }

        @Override
        default public Class<Domain> getEntityClass() {
            return Domain.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface BotDAO
    extends EntityDAO<Bot> {
        @Override
        default public String getTableName() {
            return "bot_entity";
        }

        @Override
        default public Class<Bot> getEntityClass() {
            return Bot.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface FieldRelationshipDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, (:json :: jsonb)) ON CONFLICT (fromFQNHash, toFQNHash, relation) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="fromFQNHash") String var1, @Bind(value="toFQNHash") String var2, @Bind(value="fromFQN") String var3, @Bind(value="toFQN") String var4, @Bind(value="fromType") String var5, @Bind(value="toType") String var6, @Bind(value="relation") int var7, @Bind(value="json") String var8);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, (:json :: jsonb)) ON CONFLICT (fromFQNHash, toFQNHash, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void upsert(@Bind(value="fromFQNHash") String var1, @Bind(value="toFQNHash") String var2, @Bind(value="fromFQN") String var3, @Bind(value="toFQN") String var4, @Bind(value="fromType") String var5, @Bind(value="toType") String var6, @Bind(value="relation") int var7, @Bind(value="jsonSchema") String var8, @Bind(value="json") String var9);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, :json) ON DUPLICATE KEY UPDATE fromFQNHash = :fromFQNHash,toFQNHash = :toFQNHash", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, (:json :: jsonb)) ON CONFLICT (fromFQN, toFQN, relation) DO UPDATE SET fromFQNHash = EXCLUDED.fromFQNHash,toFQNHash = EXCLUDED.toFQNHash", connectionType=ConnectionType.POSTGRES)})
        public void upsertFQNHash(@Bind(value="fromFQNHash") String var1, @Bind(value="toFQNHash") String var2, @Bind(value="fromFQN") String var3, @Bind(value="toFQN") String var4, @Bind(value="fromType") String var5, @Bind(value="toType") String var6, @Bind(value="relation") int var7, @Bind(value="jsonSchema") String var8, @Bind(value="json") String var9);

        @SqlQuery(value="SELECT json FROM field_relationship WHERE fromFQNHash = :fromFQNHash AND toFQNHash = :toFQNHash AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public String find(@Bind(value="fromFQNHash") String var1, @Bind(value="toFQNHash") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND fromType = :fromType AND toType = :toType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listToByPrefix(@Bind(value="fqnPrefixHash") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4);

        @Deprecated
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(DISTINCT fromFQN, toFQN) FROM field_relationship", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT COUNT(*) FROM ( SELECT DISTINCT fromFQN, toFQN FROM field_relationship) AS subquery", connectionType=ConnectionType.POSTGRES)})
        public int listDistinctCount();

        @Deprecated
        @SqlQuery(value="SELECT DISTINCT fromFQN, toFQN FROM field_relationship WHERE fromFQNHash = '' or fromFQNHash is null or toFQNHash = '' or toFQNHash is null LIMIT :limit")
        @RegisterRowMapper(value=FieldRelationShipMapper.class)
        public List<Pair<String, String>> migrationListDistinctWithOffset(@Bind(value="limit") int var1);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash = :fqnHash AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQNHash = :fqnHash AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectional(@Bind(value="fqnHash") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectionalByPrefix(@Bind(value="fqnPrefixHash") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        default public void deleteAllByPrefix(String fqnPrefixHash) {
            String prefix = String.format("%s%s%%", fqnPrefixHash, ".");
            String condition = "WHERE (toFQNHash LIKE :prefix OR fromFQNHash LIKE :prefix)";
            HashMap<String, String> bindMap = new HashMap<String, String>();
            bindMap.put("prefix", prefix);
            this.deleteAllByPrefixInternal(condition, bindMap);
        }

        @SqlUpdate(value="DELETE from field_relationship <cond>")
        public void deleteAllByPrefixInternal(@Define(value="cond") String var1, @BindMap Map<String, String> var2);

        @SqlUpdate(value="DELETE from field_relationship WHERE fromFQNHash = :fromFQNHash AND toFQNHash = :toFQNHash AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public void delete(@Bind(value="fromFQNHash") String var1, @Bind(value="toFQNHash") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        public static class FieldRelationship {
            private String fromFQNHash;
            private String toFQNHash;
            private String fromFQN;
            private String toFQN;
            private String fromType;
            private String toType;
            private int relation;
            private String jsonSchema;
            private String json;

            public String getFromFQNHash() {
                return this.fromFQNHash;
            }

            public String getToFQNHash() {
                return this.toFQNHash;
            }

            public String getFromFQN() {
                return this.fromFQN;
            }

            public String getToFQN() {
                return this.toFQN;
            }

            public String getFromType() {
                return this.fromType;
            }

            public String getToType() {
                return this.toType;
            }

            public int getRelation() {
                return this.relation;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public String getJson() {
                return this.json;
            }

            public void setFromFQNHash(String fromFQNHash) {
                this.fromFQNHash = fromFQNHash;
            }

            public void setToFQNHash(String toFQNHash) {
                this.toFQNHash = toFQNHash;
            }

            public void setFromFQN(String fromFQN) {
                this.fromFQN = fromFQN;
            }

            public void setToFQN(String toFQN) {
                this.toFQN = toFQN;
            }

            public void setFromType(String fromType) {
                this.fromType = fromType;
            }

            public void setToType(String toType) {
                this.toType = toType;
            }

            public void setRelation(int relation) {
                this.relation = relation;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
            }

            public void setJson(String json) {
                this.json = json;
            }
        }

        public static class FieldRelationShipMapper
        implements RowMapper<Pair<String, String>> {
            public Pair<String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Pair.of((Object)rs.getString("fromFQN"), (Object)rs.getString("toFQN"));
            }
        }

        public static class ToFieldMapper
        implements RowMapper<Triple<String, String, String>> {
            public Triple<String, String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Triple.of((Object)rs.getString("fromFQN"), (Object)rs.getString("toFQN"), (Object)rs.getString("json"));
            }
        }
    }

    public static interface FeedDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE id = :id")
        public String findById(@Bind(value="id") String var1);

        @SqlQuery(value="SELECT json FROM thread_entity ORDER BY createdAt DESC")
        public List<String> list();

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition>")
        public int listCount(@Define(value="condition") String var1);

        @SqlUpdate(value="DELETE FROM thread_entity WHERE id = :id")
        public void delete(@Bind(value="id") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=LAST_INSERT_ID(id+1)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=(id+1) RETURNING id", connectionType=ConnectionType.POSTGRES)})
        public void updateTaskId();

        @SqlQuery(value="SELECT id FROM task_sequence LIMIT 1")
        public int getTaskId();

        @SqlQuery(value="SELECT json FROM thread_entity WHERE taskId = :id")
        public String findByTaskId(@Bind(value="id") int var1);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> ORDER BY createdAt DESC LIMIT :limit")
        public List<String> list(@Bind(value="limit") int var1, @Define(value="condition") String var2);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE type='Announcement' AND (:threadId IS NULL OR id != :threadId) AND entityId = :entityId AND (( :startTs >= announcementStart AND :startTs < announcementEnd) OR (:endTs > announcementStart AND :endTs < announcementEnd) OR (:startTs <= announcementStart AND :endTs >= announcementEnd))")
        public List<String> listAnnouncementBetween(@Bind(value="threadId") String var1, @Bind(value="entityId") String var2, @Bind(value="startTs") long var3, @Bind(value="endTs") long var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksAssigned(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="limit") int var3, @Define(value="condition") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[])", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksAssignedTo(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Define(value="condition") String var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND (JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksOfUser(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Bind(value="limit") int var4, @Define(value="condition") String var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) OR createdBy = :username) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksOfUser(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND createdBy = :username ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listTasksAssigned(@Bind(value="username") String var1, @Bind(value="limit") int var2, @Define(value="condition") String var3);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND createdBy = :username")
        public int listCountTasksAssignedBy(@Bind(value="username") String var1, @Define(value="condition") String var2);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByOwner(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ")
        public int listCountThreadsByOwner(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Define(value="condition") String var3);

        default public List<String> listThreadsByEntityLink(FeedFilter filter, MessageParser.EntityLink entityLink, int limit, int relation, String userName, List<String> teamNames) {
            int filterRelation = -1;
            if (userName != null && filter.getFilterType() == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listThreadsByEntityLink(FullyQualifiedName.buildHash(entityLink.getFullyQualifiedFieldValue()), entityLink.getFullyQualifiedFieldType(), limit, relation, userName, teamNames, filterRelation, filter.getCondition());
        }

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND MD5(id) in (SELECT fromFQNHash FROM field_relationship WHERE (:fqnPrefixHash IS NULL OR toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR toFQNHash=:fqnPrefixHash) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE  ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByEntityLink(@Bind(value="fqnPrefixHash") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @Bind(value="userName") String var5, @BindList(value="teamNames") List<String> var6, @Bind(value="filterRelation") int var7, @Define(value="condition") String var8);

        default public int listCountThreadsByEntityLink(FeedFilter filter, MessageParser.EntityLink entityLink, int relation, String userName, List<String> teamNames) {
            int filterRelation = -1;
            if (userName != null && filter.getFilterType() == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listCountThreadsByEntityLink(FullyQualifiedName.buildHash(entityLink.getFullyQualifiedFieldValue()), entityLink.getFullyQualifiedFieldType(), relation, userName, teamNames, filterRelation, filter.getCondition(false));
        }

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND MD5(id) in (SELECT fromFQNHash FROM field_relationship WHERE (:fqnPrefixHash IS NULL OR toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR toFQNHash=:fqnPrefixHash) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR id in (SELECT toFQNHash FROM field_relationship WHERE  ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )")
        public int listCountThreadsByEntityLink(@Bind(value="fqnPrefixHash") String var1, @Bind(value="toType") String var2, @Bind(value="relation") int var3, @Bind(value="userName") String var4, @BindList(value="teamNames") List<String> var5, @Bind(value="filterRelation") int var6, @Define(value="condition") String var7);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = :json where id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = (:json :: jsonb) where id = :id", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="id") String var1, @Bind(value="json") String var2);

        @SqlQuery(value="SELECT entityLink, COUNT(id) count FROM field_relationship fr INNER JOIN thread_entity te ON fr.fromFQNHash=MD5(te.id) WHERE (:fqnPrefixHash IS NULL OR fr.toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR fr.toFQNHash=:fqnPrefixHash) AND (:toType IS NULL OR fr.toType like concat(:toType, '.%') OR fr.toType=:toType) AND fr.fromType = :fromType AND fr.relation = :relation AND te.resolved= :isResolved AND (:status IS NULL OR te.taskStatus = :status) AND (:type IS NULL OR te.type = :type) GROUP BY entityLink")
        @RegisterRowMapper(value=CountFieldMapper.class)
        public List<List<String>> listCountByEntityLink(@Bind(value="fqnPrefixHash") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4, @Bind(value="type") ThreadType var5, @Bind(value="status") TaskStatus var6, @Bind(value="isResolved") boolean var7);

        @SqlQuery(value="SELECT entityLink, COUNT(id) count FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) GROUP BY entityLink")
        @RegisterRowMapper(value=CountFieldMapper.class)
        public List<List<String>> listCountByOwner(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Define(value="condition") String var3);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByFollows(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @Define(value="condition") String var5);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation)")
        public int listCountThreadsByFollows(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="relation") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByMentions(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @Define(value="condition") String var5);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ")
        public int listCountThreadsByMentions(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="relation") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="select id from thread_entity where entityId = :entityId")
        public List<String> findByEntityId(@Bind(value="entityId") String var1);

        public static class CountFieldMapper
        implements RowMapper<List<String>> {
            public List<String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Arrays.asList(rs.getString("entityLink"), rs.getString("count"));
            }
        }
    }

    public static interface EntityRelationshipDAO {
        default public void insert(UUID fromId, UUID toId, String fromEntity, String toEntity, int relation) {
            this.insert(fromId, toId, fromEntity, toEntity, relation, null);
        }

        default public void insert(UUID fromId, UUID toId, String fromEntity, String toEntity, int relation, String json) {
            this.insert(fromId.toString(), toId.toString(), fromEntity, toEntity, relation, json);
        }

        default public void bulkInsertToRelationship(UUID fromId, List<UUID> toIds, String fromEntity, String toEntity, int relation) {
            List<EntityRelationshipObject> insertToRelationship = toIds.stream().map(testCase -> EntityRelationshipObject.builder().fromId(fromId.toString()).toId(testCase.toString()).fromEntity(fromEntity).toEntity(toEntity).relation(relation).build()).collect(Collectors.toList());
            this.bulkInsertTo(insertToRelationship);
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, (:json :: jsonb)) ON CONFLICT (fromId, toId, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="fromId") String var1, @Bind(value="toId") String var2, @Bind(value="fromEntity") String var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5, @Bind(value="json") String var6);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation) VALUES <values>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation) VALUES <values>ON CONFLICT DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void bulkInsertTo(@BindBeanList(value="values", propertyNames={"fromId", "toId", "fromEntity", "toEntity", "relation"}) List<EntityRelationshipObject> var1);

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation IN (<relation>) ORDER BY toId")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @BindList(value="relation") List<Integer> var3);

        default public List<EntityRelationshipRecord> findTo(String fromId, String fromEntity, int relation) {
            return this.findTo(fromId, fromEntity, List.of(Integer.valueOf(relation)));
        }

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity ORDER BY toId")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.pipeline.id')) =:fromId OR fromId = :fromId AND relation = :relation ORDER BY toId", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE  json->'pipeline'->>'id' =:fromId OR fromId = :fromId AND relation = :relation ORDER BY toId", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findToPipeline(@Bind(value="fromId") String var1, @Bind(value="relation") int var2);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.pipeline.id')) = :toId OR toId = :toId AND relation = :relation ORDER BY fromId", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE  json->'pipeline'->>'id' = :toId OR toId = :toId AND relation = :relation ORDER BY fromId", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFromPipleine(@Bind(value="toId") String var1, @Bind(value="relation") int var2);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1);

        @SqlQuery(value="SELECT count(*) FROM entity_relationship WHERE fromEntity = :fromEntity AND toEntity = :toEntity")
        public int findIfAnyRelationExist(@Bind(value="fromEntity") String var1, @Bind(value="toEntity") String var2);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND toId = :toId AND toEntity = :toEntity AND relation = :relation")
        public int delete(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="toId") String var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity")
        public void deleteFrom(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity")
        public void deleteTo(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE (toId = :id AND toEntity = :entity) OR (fromId = :id AND fromEntity = :entity)")
        public void deleteAll(@Bind(value="id") String var1, @Bind(value="entity") String var2);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :id or toId = :id")
        public void deleteAllWithId(@Bind(value="id") String var1);

        public static class ToRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("toId"))).type(rs.getString("toEntity")).json(rs.getString("json")).build();
            }
        }

        public static class FromRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("fromId"))).type(rs.getString("fromEntity")).json(rs.getString("json")).build();
            }
        }
    }

    public static class QueryList {
        private String fqn;
        private Query query;

        QueryList(String fqn, Query query) {
            this.fqn = fqn;
            this.query = query;
        }

        public static QueryListBuilder builder() {
            return new QueryListBuilder();
        }

        public String getFqn() {
            return this.fqn;
        }

        public Query getQuery() {
            return this.query;
        }

        public static class QueryListBuilder {
            private String fqn;
            private Query query;

            QueryListBuilder() {
            }

            public QueryListBuilder fqn(String fqn) {
                this.fqn = fqn;
                return this;
            }

            public QueryListBuilder query(Query query) {
                this.query = query;
                return this;
            }

            public QueryList build() {
                return new QueryList(this.fqn, this.query);
            }

            public String toString() {
                return "CollectionDAO.QueryList.QueryListBuilder(fqn=" + this.fqn + ", query=" + this.query + ")";
            }
        }
    }

    public static class ReportDataRow {
        private String rowNum;
        private ReportData reportData;

        ReportDataRow(String rowNum, ReportData reportData) {
            this.rowNum = rowNum;
            this.reportData = reportData;
        }

        public static ReportDataRowBuilder builder() {
            return new ReportDataRowBuilder();
        }

        public String getRowNum() {
            return this.rowNum;
        }

        public ReportData getReportData() {
            return this.reportData;
        }

        public static class ReportDataRowBuilder {
            private String rowNum;
            private ReportData reportData;

            ReportDataRowBuilder() {
            }

            public ReportDataRowBuilder rowNum(String rowNum) {
                this.rowNum = rowNum;
                return this;
            }

            public ReportDataRowBuilder reportData(ReportData reportData) {
                this.reportData = reportData;
                return this;
            }

            public ReportDataRow build() {
                return new ReportDataRow(this.rowNum, this.reportData);
            }

            public String toString() {
                return "CollectionDAO.ReportDataRow.ReportDataRowBuilder(rowNum=" + this.rowNum + ", reportData=" + this.reportData + ")";
            }
        }
    }

    public static class EntityRelationshipObject {
        private String fromId;
        private String toId;
        private String fromEntity;
        private String toEntity;
        private int relation;

        EntityRelationshipObject(String fromId, String toId, String fromEntity, String toEntity, int relation) {
            this.fromId = fromId;
            this.toId = toId;
            this.fromEntity = fromEntity;
            this.toEntity = toEntity;
            this.relation = relation;
        }

        public static EntityRelationshipObjectBuilder builder() {
            return new EntityRelationshipObjectBuilder();
        }

        public String getFromId() {
            return this.fromId;
        }

        public String getToId() {
            return this.toId;
        }

        public String getFromEntity() {
            return this.fromEntity;
        }

        public String getToEntity() {
            return this.toEntity;
        }

        public int getRelation() {
            return this.relation;
        }

        public static class EntityRelationshipObjectBuilder {
            private String fromId;
            private String toId;
            private String fromEntity;
            private String toEntity;
            private int relation;

            EntityRelationshipObjectBuilder() {
            }

            public EntityRelationshipObjectBuilder fromId(String fromId) {
                this.fromId = fromId;
                return this;
            }

            public EntityRelationshipObjectBuilder toId(String toId) {
                this.toId = toId;
                return this;
            }

            public EntityRelationshipObjectBuilder fromEntity(String fromEntity) {
                this.fromEntity = fromEntity;
                return this;
            }

            public EntityRelationshipObjectBuilder toEntity(String toEntity) {
                this.toEntity = toEntity;
                return this;
            }

            public EntityRelationshipObjectBuilder relation(int relation) {
                this.relation = relation;
                return this;
            }

            public EntityRelationshipObject build() {
                return new EntityRelationshipObject(this.fromId, this.toId, this.fromEntity, this.toEntity, this.relation);
            }

            public String toString() {
                return "CollectionDAO.EntityRelationshipObject.EntityRelationshipObjectBuilder(fromId=" + this.fromId + ", toId=" + this.toId + ", fromEntity=" + this.fromEntity + ", toEntity=" + this.toEntity + ", relation=" + this.relation + ")";
            }
        }
    }

    public static class EntityRelationshipRecord {
        private UUID id;
        private String type;
        private String json;

        EntityRelationshipRecord(UUID id, String type, String json) {
            this.id = id;
            this.type = type;
            this.json = json;
        }

        public static EntityRelationshipRecordBuilder builder() {
            return new EntityRelationshipRecordBuilder();
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getJson() {
            return this.json;
        }

        public static class EntityRelationshipRecordBuilder {
            private UUID id;
            private String type;
            private String json;

            EntityRelationshipRecordBuilder() {
            }

            public EntityRelationshipRecordBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            public EntityRelationshipRecordBuilder type(String type) {
                this.type = type;
                return this;
            }

            public EntityRelationshipRecordBuilder json(String json) {
                this.json = json;
                return this;
            }

            public EntityRelationshipRecord build() {
                return new EntityRelationshipRecord(this.id, this.type, this.json);
            }

            public String toString() {
                return "CollectionDAO.EntityRelationshipRecord.EntityRelationshipRecordBuilder(id=" + this.id + ", type=" + this.type + ", json=" + this.json + ")";
            }
        }
    }

    public static class ExtensionMapper
    implements RowMapper<ExtensionRecord> {
        public ExtensionRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ExtensionRecord(rs.getString("extension"), rs.getString("json"));
        }
    }

    public static class ExtensionRecord {
        private final String extensionName;
        private final String extensionJson;

        public ExtensionRecord(String extensionName, String extensionJson) {
            this.extensionName = extensionName;
            this.extensionJson = extensionJson;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public String getExtensionJson() {
            return this.extensionJson;
        }
    }

    public static class EntityVersionPair {
        private final Double version;
        private final String entityJson;

        public EntityVersionPair(ExtensionRecord extensionRecord) {
            this.version = EntityUtil.getVersion(extensionRecord.getExtensionName());
            this.entityJson = extensionRecord.getExtensionJson();
        }

        public Double getVersion() {
            return this.version;
        }

        public String getEntityJson() {
            return this.entityJson;
        }
    }

    public static interface EntityExtensionDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="REPLACE INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, (:json :: jsonb)) ON CONFLICT (id, extension) DO UPDATE SET jsonSchema = EXCLUDED.jsonSchema, json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="id") String var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @SqlQuery(value="SELECT json FROM entity_extension WHERE id = :id AND extension = :extension")
        public String getExtension(@Bind(value="id") String var1, @Bind(value="extension") String var2);

        @RegisterRowMapper(value=ExtensionMapper.class)
        @SqlQuery(value="SELECT extension, json FROM entity_extension WHERE id = :id AND extension LIKE CONCAT (:extensionPrefix, '.%') ORDER BY extension")
        public List<ExtensionRecord> getExtensions(@Bind(value="id") String var1, @Bind(value="extensionPrefix") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id AND extension = :extension")
        public void delete(@Bind(value="id") String var1, @Bind(value="extension") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE extension = :extension")
        public void deleteExtension(@Bind(value="extension") String var1);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id")
        public void deleteAll(@Bind(value="id") String var1);
    }

    public static interface ContainerDAO
    extends EntityDAO<Container> {
        @Override
        default public String getTableName() {
            return "storage_container_entity";
        }

        @Override
        default public Class<Container> getEntityClass() {
            return Container.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listBefore(this.getTableName(), this.getNameColumn(), sqlCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listAfter(this.getTableName(), this.getNameColumn(), sqlCondition, limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listCount(filter);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listCount(this.getTableName(), this.getNameColumn(), sqlCondition);
        }

        @Override
        @SqlQuery(value="SELECT json FROM (SELECT <nameColumn>, ce.json FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>")
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

        @Override
        @SqlQuery(value="SELECT ce.json FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit")
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);

        @Override
        @SqlQuery(value="SELECT count(*) FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition>")
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="sqlCondition") String var3);
    }

    public static interface StorageServiceDAO
    extends EntityDAO<StorageService> {
        @Override
        default public String getTableName() {
            return "storage_service_entity";
        }

        @Override
        default public Class<StorageService> getEntityClass() {
            return StorageService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface TestConnectionDefinitionDAO
    extends EntityDAO<TestConnectionDefinition> {
        @Override
        default public String getTableName() {
            return "test_connection_definition";
        }

        @Override
        default public Class<TestConnectionDefinition> getEntityClass() {
            return TestConnectionDefinition.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface MetadataServiceDAO
    extends EntityDAO<MetadataService> {
        @Override
        default public String getTableName() {
            return "metadata_service_entity";
        }

        @Override
        default public Class<MetadataService> getEntityClass() {
            return MetadataService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface DatabaseServiceDAO
    extends EntityDAO<DatabaseService> {
        @Override
        default public String getTableName() {
            return "dbservice_entity";
        }

        @Override
        default public Class<DatabaseService> getEntityClass() {
            return DatabaseService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface DatabaseSchemaDAO
    extends EntityDAO<DatabaseSchema> {
        @Override
        default public String getTableName() {
            return "database_schema_entity";
        }

        @Override
        default public Class<DatabaseSchema> getEntityClass() {
            return DatabaseSchema.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface DatabaseDAO
    extends EntityDAO<Database> {
        @Override
        default public String getTableName() {
            return "database_entity";
        }

        @Override
        default public Class<Database> getEntityClass() {
            return Database.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface DashboardServiceDAO
    extends EntityDAO<DashboardService> {
        @Override
        default public String getTableName() {
            return "dashboard_service_entity";
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public Class<DashboardService> getEntityClass() {
            return DashboardService.class;
        }
    }

    public static interface DashboardDAO
    extends EntityDAO<Dashboard> {
        @Override
        default public String getTableName() {
            return "dashboard_entity";
        }

        @Override
        default public Class<Dashboard> getEntityClass() {
            return Dashboard.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }
}

