/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProductRepository
extends EntityRepository<DataProduct> {
    private static final Logger LOG = LoggerFactory.getLogger(DataProductRepository.class);
    private static final String UPDATE_FIELDS = "experts";

    public DataProductRepository(CollectionDAO dao) {
        super("/v1/dataProducts/", "dataProduct", DataProduct.class, dao.dataProductDAO(), dao, UPDATE_FIELDS, UPDATE_FIELDS);
    }

    @Override
    public DataProduct setFields(DataProduct entity, EntityUtil.Fields fields) throws IOException {
        return entity.withExperts(fields.contains(UPDATE_FIELDS) ? this.getExperts(entity) : null);
    }

    private List<EntityReference> getExperts(DataProduct entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(entity.getId(), "dataProduct", Relationship.EXPERT, "user");
        return EntityUtil.populateEntityReferences(ids, "user");
    }

    @Override
    public void prepare(DataProduct entity) throws IOException {
    }

    @Override
    public void storeEntity(DataProduct entity, boolean update) throws IOException {
        EntityReference domain = entity.getDomain();
        List experts = entity.getExperts();
        entity.withDomain(null).withExperts(null);
        this.store(entity, update);
        entity.withDomain(domain).withExperts(experts);
    }

    @Override
    public void storeRelationships(DataProduct entity) {
        this.addRelationship(entity.getDomain().getId(), entity.getId(), "domain", "dataProduct", Relationship.CONTAINS);
        for (EntityReference expert : CommonUtil.listOrEmpty((List)entity.getExperts())) {
            this.addRelationship(entity.getId(), expert.getId(), "dataProduct", "user", Relationship.EXPERT);
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DataProduct original, DataProduct updated, EntityRepository.Operation operation) {
        return new DataProductUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(DataProduct original, DataProduct updated) {
        updated.withDomain(original.getDomain());
    }

    @Override
    public void setFullyQualifiedName(DataProduct entity) {
        EntityReference domain = entity.getDomain();
        entity.setFullyQualifiedName(FullyQualifiedName.add(domain.getFullyQualifiedName(), entity.getName()));
    }

    @Override
    public String getFullyQualifiedNameHash(DataProduct entity) {
        return FullyQualifiedName.buildHash(entity.getFullyQualifiedName());
    }

    public class DataProductUpdater
    extends EntityRepository.EntityUpdater {
        public DataProductUpdater(DataProduct original, DataProduct updated, EntityRepository.Operation operation) {
            super((EntityRepository)DataProductRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateExperts();
        }

        private void updateExperts() throws JsonProcessingException {
            List origExperts = CommonUtil.listOrEmpty((List)((DataProduct)this.original).getExperts());
            List updatedExperts = CommonUtil.listOrEmpty((List)((DataProduct)this.updated).getExperts());
            this.updateToRelationships(DataProductRepository.UPDATE_FIELDS, "dataProduct", ((DataProduct)this.original).getId(), Relationship.EXPERT, "user", origExperts, updatedExperts, false);
        }
    }
}

