/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRepository
extends EntityRepository<Domain> {
    private static final Logger LOG = LoggerFactory.getLogger(DomainRepository.class);
    private static final String UPDATE_FIELDS = "parent,children,experts";

    public DomainRepository(CollectionDAO dao) {
        super("/v1/domains/", "domain", Domain.class, dao.domainDAO(), dao, UPDATE_FIELDS, UPDATE_FIELDS);
    }

    @Override
    public Domain setFields(Domain entity, EntityUtil.Fields fields) throws IOException {
        entity.withParent(fields.contains("parent") ? this.getParent(entity) : null);
        entity.withChildren(fields.contains("children") ? this.getChildren(entity) : null);
        return entity.withExperts(fields.contains("experts") ? this.getExperts(entity) : null);
    }

    private EntityReference getParent(Domain entity) throws IOException {
        return this.getFromEntityRef(entity.getId(), Relationship.CONTAINS, "domain", false);
    }

    private List<EntityReference> getChildren(Domain entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(entity.getId(), "domain", Relationship.CONTAINS, "domain");
        return EntityUtil.populateEntityReferences(ids, "glossaryTerm");
    }

    private List<EntityReference> getExperts(Domain entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(entity.getId(), "domain", Relationship.EXPERT, "user");
        return EntityUtil.populateEntityReferences(ids, "user");
    }

    @Override
    public void prepare(Domain entity) throws IOException {
    }

    @Override
    public void storeEntity(Domain entity, boolean update) throws IOException {
        EntityReference parent = entity.getParent();
        List children = entity.getChildren();
        List experts = entity.getExperts();
        entity.withParent(null).withChildren(null).withExperts(null);
        this.store(entity, update);
        entity.withParent(parent).withChildren(children).withExperts(experts);
    }

    @Override
    public void storeRelationships(Domain entity) {
        if (entity.getParent() != null) {
            this.addRelationship(entity.getParent().getId(), entity.getId(), "domain", "domain", Relationship.CONTAINS);
        }
        for (EntityReference expert : CommonUtil.listOrEmpty((List)entity.getExperts())) {
            this.addRelationship(entity.getId(), expert.getId(), "domain", "user", Relationship.EXPERT);
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Domain original, Domain updated, EntityRepository.Operation operation) {
        return new DomainUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(Domain original, Domain updated) {
        updated.withParent(original.getParent());
        updated.withChildren(original.getChildren());
    }

    @Override
    public void setFullyQualifiedName(Domain entity) {
        if (entity.getParent() == null) {
            entity.setFullyQualifiedName(FullyQualifiedName.build(entity.getName()));
        } else {
            EntityReference parent = entity.getParent();
            entity.setFullyQualifiedName(FullyQualifiedName.add(parent.getFullyQualifiedName(), entity.getName()));
        }
    }

    @Override
    public String getFullyQualifiedNameHash(Domain entity) {
        return FullyQualifiedName.buildHash(entity.getFullyQualifiedName());
    }

    public class DomainUpdater
    extends EntityRepository.EntityUpdater {
        public DomainUpdater(Domain original, Domain updated, EntityRepository.Operation operation) {
            super((EntityRepository)DomainRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateExperts();
        }

        private void updateExperts() throws JsonProcessingException {
            List origExperts = CommonUtil.listOrEmpty((List)((Domain)this.original).getExperts());
            List updatedExperts = CommonUtil.listOrEmpty((List)((Domain)this.updated).getExperts());
            this.updateToRelationships("experts", "domain", ((Domain)this.original).getId(), Relationship.EXPERT, "user", origExperts, updatedExperts, false);
        }
    }
}

