/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EntityDAO<T extends EntityInterface> {
    public static final Logger LOG = LoggerFactory.getLogger(EntityDAO.class);

    public String getTableName();

    public Class<T> getEntityClass();

    default public String getNameColumn() {
        return "name";
    }

    default public String getNameHashColumn() {
        return "nameHash";
    }

    default public boolean supportsSoftDelete() {
        return true;
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO <table> (<nameHashColumn>, json) VALUES (:nameHashColumnValue, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO <table> (<nameHashColumn>, json) VALUES (:nameHashColumnValue, :json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
    public int insert(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Bind(value="nameHashColumnValue") String var3, @Bind(value="json") String var4);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = :json, <nameHashColumn> = :nameHashColumnValue WHERE id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = (:json :: jsonb), <nameHashColumn> = :nameHashColumnValue WHERE id = :id", connectionType=ConnectionType.POSTGRES)})
    public void update(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Bind(value="nameHashColumnValue") String var3, @Bind(value="id") String var4, @Bind(value="json") String var5);

    default public void updateFqn(String oldPrefix, String newPrefix) {
        LOG.info("Updating FQN for {} from {} to {}", new Object[]{this.getTableName(), oldPrefix, newPrefix});
        if (!this.getNameHashColumn().equals("fqnHash")) {
            return;
        }
        String mySqlUpdate = String.format("UPDATE %s SET json = JSON_REPLACE(json, '$.fullyQualifiedName', REGEXP_REPLACE(JSON_UNQUOTE(JSON_EXTRACT(json, '$.fullyQualifiedName')), '^%s\\.', '%s.')) , fqnHash = REPLACE(fqnHash, '%s.', '%s.') WHERE fqnHash LIKE '%s.%%'", this.getTableName(), ListFilter.escape(oldPrefix), ListFilter.escapeApostrophe(newPrefix), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), FullyQualifiedName.buildHash(oldPrefix));
        String postgresUpdate = String.format("UPDATE %s SET json = REPLACE(json::text, '\"fullyQualifiedName\": \"%s.', '\"fullyQualifiedName\": \"%s.')::jsonb , fqnHash = REPLACE(fqnHash, '%s.', '%s.') WHERE fqnHash LIKE '%s.%%'", this.getTableName(), ListFilter.escapeApostrophe(oldPrefix), ListFilter.escapeApostrophe(newPrefix), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), FullyQualifiedName.buildHash(oldPrefix));
        this.updateFqnInternal(mySqlUpdate, postgresUpdate);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="<mySqlUpdate>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="<postgresUpdate>", connectionType=ConnectionType.POSTGRES)})
    public void updateFqnInternal(@Define(value="mySqlUpdate") String var1, @Define(value="postgresUpdate") String var2);

    @SqlQuery(value="SELECT json FROM <table> WHERE id = :id <cond>")
    public String findById(@Define(value="table") String var1, @Bind(value="id") String var2, @Define(value="cond") String var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE <nameColumn> = :name <cond>")
    public String findByName(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="name") String var3, @Define(value="cond") String var4);

    @SqlQuery(value="SELECT count(*) FROM <table> <cond>")
    public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <postgresCond>", connectionType=ConnectionType.POSTGRES)})
    public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.<nameColumn>, <table>.json FROM <table> <mysqlCond> AND <table>.<nameColumn> < :before ORDER BY <table>.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.<nameColumn>, <table>.json FROM <table> <postgresCond> AND <table>.<nameColumn> < :before ORDER BY <table>.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
    public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <mysqlCond> AND <table>.<nameColumn> > :after ORDER BY <table>.<nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <postgresCond> AND <table>.<nameColumn> > :after ORDER BY <table>.<nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
    public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6);

    @SqlQuery(value="SELECT count(*) FROM <table>")
    public int listTotalCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2);

    @SqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <cond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>")
    public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

    @SqlQuery(value="SELECT json FROM <table> <cond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit")
    public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);

    @SqlQuery(value="SELECT json FROM <table> LIMIT :limit OFFSET :offset")
    public List<String> listAfterWithOffset(@Define(value="table") String var1, @Bind(value="limit") int var2, @Bind(value="offset") int var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE <nameHashColumn> = '' or <nameHashColumn> is null LIMIT :limit")
    public List<String> migrationListAfterWithOffset(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Bind(value="limit") int var3);

    @SqlQuery(value="SELECT json FROM <table> <cond> AND ORDER BY <nameColumn> LIMIT :limit OFFSET :offset")
    public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="offset") int var5);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE id = :id)")
    public boolean exists(@Define(value="table") String var1, @Bind(value="id") String var2);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE <nameColumnHash> = :fqnHash)")
    public boolean existsByName(@Define(value="table") String var1, @Define(value="nameColumnHash") String var2, @Bind(value="fqnHash") String var3);

    @SqlUpdate(value="DELETE FROM <table> WHERE id = :id")
    public int delete(@Define(value="table") String var1, @Bind(value="id") String var2);

    default public void insert(EntityInterface entity, String fqnHash) throws JsonProcessingException {
        this.insert(this.getTableName(), this.getNameHashColumn(), fqnHash, JsonUtils.pojoToJson(entity));
    }

    default public void insert(String nameHash, EntityInterface entity, String fqnHash) throws JsonProcessingException {
        this.insert(this.getTableName(), nameHash, fqnHash, JsonUtils.pojoToJson(entity));
    }

    default public void update(UUID id, String fqnHash, String json) {
        this.update(this.getTableName(), this.getNameHashColumn(), fqnHash, id.toString(), json);
    }

    default public void update(EntityInterface entity) throws JsonProcessingException {
        this.update(this.getTableName(), this.getNameHashColumn(), FullyQualifiedName.buildHash(entity.getFullyQualifiedName()), entity.getId().toString(), JsonUtils.pojoToJson(entity));
    }

    default public void update(String nameHashColumnName, EntityInterface entity) throws JsonProcessingException {
        this.update(this.getTableName(), nameHashColumnName, FullyQualifiedName.buildHash(entity.getFullyQualifiedName()), entity.getId().toString(), JsonUtils.pojoToJson(entity));
    }

    default public String getCondition(Include include) {
        if (!this.supportsSoftDelete()) {
            return "";
        }
        if (include == null || include == Include.NON_DELETED) {
            return "AND deleted = FALSE";
        }
        return include == Include.DELETED ? " AND deleted = TRUE" : "";
    }

    default public T findEntityById(UUID id, Include include) throws IOException {
        return this.jsonToEntity(this.findById(this.getTableName(), id.toString(), this.getCondition(include)), id.toString());
    }

    default public T findEntityById(UUID id) throws IOException {
        return this.findEntityById(id, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn) {
        return this.findEntityByName(fqn, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn, Include include) {
        return this.jsonToEntity(this.findByName(this.getTableName(), this.getNameHashColumn(), FullyQualifiedName.buildHash(fqn), this.getCondition(include)), fqn);
    }

    default public T findEntityByName(String fqn, String nameHashColumn, Include include) {
        return this.jsonToEntity(this.findByName(this.getTableName(), nameHashColumn, FullyQualifiedName.buildHash(fqn), this.getCondition(include)), fqn);
    }

    default public T jsonToEntity(String json, String identity) throws IOException {
        EntityInterface entity;
        Class<T> clz = this.getEntityClass();
        EntityInterface entityInterface = entity = json != null ? (EntityInterface)JsonUtils.readValue(json, clz) : null;
        if (entity == null) {
            String entityType = Entity.getEntityTypeFromClass(clz);
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, identity));
        }
        return (T)entity;
    }

    default public EntityReference findEntityReferenceById(UUID id) throws IOException {
        return this.findEntityById(id).getEntityReference();
    }

    default public EntityReference findEntityReferenceByName(String fqn) {
        return this.findEntityByName(fqn).getEntityReference();
    }

    default public EntityReference findEntityReferenceById(UUID id, Include include) throws IOException {
        return this.findEntityById(id, include).getEntityReference();
    }

    default public EntityReference findEntityReferenceByName(String fqn, Include include) {
        return this.findEntityByName(fqn, include).getEntityReference();
    }

    default public String findJsonById(UUID id, Include include) {
        return this.findById(this.getTableName(), id.toString(), this.getCondition(include));
    }

    default public String findJsonByFqn(String fqn, Include include) {
        return this.findByName(this.getTableName(), this.getNameHashColumn(), FullyQualifiedName.buildHash(fqn), this.getCondition(include));
    }

    default public int listCount(ListFilter filter) {
        return this.listCount(this.getTableName(), this.getNameHashColumn(), filter.getCondition());
    }

    default public int listTotalCount() {
        return this.listTotalCount(this.getTableName(), this.getNameHashColumn());
    }

    default public List<String> listBefore(ListFilter filter, int limit, String before) {
        before = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(before) : before;
        return this.listBefore(this.getTableName(), this.getNameColumn(), filter.getCondition(), limit, before);
    }

    default public List<String> listAfter(ListFilter filter, int limit, String after) {
        after = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(after) : after;
        return this.listAfter(this.getTableName(), this.getNameColumn(), filter.getCondition(), limit, after);
    }

    default public List<String> listAfterWithOffset(int limit, int offset) {
        return this.listAfterWithOffset(this.getTableName(), limit, offset);
    }

    default public List<String> migrationListAfterWithOffset(int limit, String nameHashColumn) {
        return this.migrationListAfterWithOffset(this.getTableName(), nameHashColumn, limit);
    }

    default public List<String> listAfter(ListFilter filter, int limit, int offset) {
        return this.listAfter(this.getTableName(), this.getNameHashColumn(), filter.getCondition(), limit, offset);
    }

    default public void exists(UUID id) {
        if (!this.exists(this.getTableName(), id.toString())) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
    }

    default public void existsByName(String fqn) {
        if (!this.existsByName(this.getTableName(), this.getNameHashColumn(), FullyQualifiedName.buildHash(fqn))) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, fqn));
        }
    }

    default public int delete(String id) {
        int rowsDeleted = this.delete(this.getTableName(), id);
        if (rowsDeleted <= 0) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
        return rowsDeleted;
    }
}

