/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;

public interface MigrationDAO {
    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT MAX(version) FROM DATABASE_CHANGE_LOG", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT max(version) FROM \"DATABASE_CHANGE_LOG\"", connectionType=ConnectionType.POSTGRES)})
    @SingleValue
    public Optional<String> getMaxVersion() throws StatementException;

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT MAX(version) FROM SERVER_CHANGE_LOG", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT max(version) FROM SERVER_CHANGE_LOG", connectionType=ConnectionType.POSTGRES)})
    @SingleValue
    public Optional<String> getMaxServerMigrationVersion() throws StatementException;

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_CHANGE_LOG where version = :version", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_CHANGE_LOG where version = :version", connectionType=ConnectionType.POSTGRES)})
    public String getVersionMigrationChecksum(@Bind(value="version") String var1) throws StatementException;

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_CHANGE_LOG (version, migrationFileName, checksum, installed_on)VALUES (:version, :migrationFileName, :checksum, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE migrationFileName = :migrationFileName, checksum = :checksum, installed_on = CURRENT_TIMESTAMP", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO server_change_log (version, migrationFileName, checksum, installed_on)VALUES (:version, :migrationFileName, :checksum, current_timestamp) ON CONFLICT (version) DO UPDATE SET migrationFileName = EXCLUDED.migrationFileName, checksum = EXCLUDED.checksum, installed_on = EXCLUDED.installed_on", connectionType=ConnectionType.POSTGRES)})
    public void upsertServerMigration(@Bind(value="version") String var1, @Bind(value="migrationFileName") String var2, @Bind(value="checksum") String var3);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_MIGRATION_SQL_LOGS (version, sqlStatement, checksum, executedAt)VALUES (:version, :sqlStatement, :checksum, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE version = :version, sqlStatement = :sqlStatement, executedAt = CURRENT_TIMESTAMP", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_MIGRATION_SQL_LOGS (version, sqlStatement, checksum, executedAt)VALUES (:version, :sqlStatement, :checksum, current_timestamp) ON CONFLICT (checksum) DO UPDATE SET version = EXCLUDED.version, sqlStatement = EXCLUDED.sqlStatement, executedAt = EXCLUDED.executedAt", connectionType=ConnectionType.POSTGRES)})
    public void upsertServerMigrationSQL(@Bind(value="version") String var1, @Bind(value="sqlStatement") String var2, @Bind(value="checksum") String var3);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_MIGRATION_SQL_LOGS where version = :version", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_MIGRATION_SQL_LOGS where version = :version", connectionType=ConnectionType.POSTGRES)})
    public List<String> getServerMigrationSQLWithVersion(@Bind(value="version") String var1);

    public static class ServerMigrationSQLTable {
        private String version;
        private String sqlStatement;
        private String checkSum;

        public String getVersion() {
            return this.version;
        }

        public String getSqlStatement() {
            return this.sqlStatement;
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setSqlStatement(String sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        public void setCheckSum(String checkSum) {
            this.checkSum = checkSum;
        }
    }
}

