/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonPatch;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MlFeature;
import org.openmetadata.schema.type.MlFeatureSource;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MlModelRepository
extends EntityRepository<MlModel> {
    private static final Logger LOG = LoggerFactory.getLogger(MlModelRepository.class);
    private static final String MODEL_UPDATE_FIELDS = "dashboard";
    private static final String MODEL_PATCH_FIELDS = "dashboard";

    public MlModelRepository(CollectionDAO dao) {
        super("v1/mlmodels/", "mlmodel", MlModel.class, dao.mlModelDAO(), dao, "dashboard", "dashboard");
    }

    @Override
    public void setFullyQualifiedName(MlModel mlModel) {
        mlModel.setFullyQualifiedName(FullyQualifiedName.add(mlModel.getService().getFullyQualifiedName(), mlModel.getName()));
        if (!CommonUtil.nullOrEmpty((List)mlModel.getMlFeatures())) {
            this.setMlFeatureFQN(mlModel.getFullyQualifiedName(), mlModel.getMlFeatures());
        }
    }

    @Override
    public String getFullyQualifiedNameHash(MlModel mlModel) {
        return FullyQualifiedName.buildHash(mlModel.getFullyQualifiedName());
    }

    @Override
    public MlModel setFields(MlModel mlModel, EntityUtil.Fields fields) throws IOException {
        mlModel.setService(this.getContainer(mlModel.getId()));
        mlModel.setDashboard(fields.contains("dashboard") ? this.getDashboard(mlModel) : null);
        mlModel.setFollowers(fields.contains("followers") ? this.getFollowers(mlModel) : null);
        return mlModel.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), mlModel.getId()) : null);
    }

    @Override
    public void restorePatchAttributes(MlModel original, MlModel updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withService(original.getService()).withName(original.getName()).withId(original.getId());
    }

    private void setMlFeatureSourcesFQN(List<MlFeatureSource> mlSources) {
        mlSources.forEach(s -> {
            if (s.getDataSource() != null) {
                s.setFullyQualifiedName(FullyQualifiedName.add(s.getDataSource().getFullyQualifiedName(), s.getName()));
            } else {
                s.setFullyQualifiedName(s.getName());
            }
        });
    }

    private void setMlFeatureFQN(String parentFQN, List<MlFeature> mlFeatures) {
        mlFeatures.forEach(f -> {
            String featureFqn = FullyQualifiedName.add(parentFQN, f.getName());
            f.setFullyQualifiedName(featureFqn);
            if (f.getFeatureSources() != null) {
                this.setMlFeatureSourcesFQN(f.getFeatureSources());
            }
        });
    }

    private void validateReferences(List<MlFeature> mlFeatures) throws IOException {
        for (MlFeature feature : mlFeatures) {
            if (CommonUtil.nullOrEmpty((List)feature.getFeatureSources())) continue;
            for (MlFeatureSource source : feature.getFeatureSources()) {
                this.validateMlDataSource(source);
            }
        }
    }

    private void validateMlDataSource(MlFeatureSource source) throws IOException {
        if (source.getDataSource() != null) {
            Entity.getEntityReferenceById(source.getDataSource().getType(), source.getDataSource().getId(), Include.NON_DELETED);
        }
    }

    @Override
    public void prepare(MlModel mlModel) throws IOException {
        this.populateService(mlModel);
        if (!CommonUtil.nullOrEmpty((List)mlModel.getMlFeatures())) {
            this.validateReferences(mlModel.getMlFeatures());
            mlModel.getMlFeatures().forEach(feature -> this.checkMutuallyExclusive(feature.getTags()));
        }
        if (mlModel.getDashboard() != null) {
            mlModel.setDashboard(Entity.getEntityReference(mlModel.getDashboard(), Include.NON_DELETED));
        }
    }

    @Override
    public void storeEntity(MlModel mlModel, boolean update) throws IOException {
        EntityReference dashboard = mlModel.getDashboard();
        EntityReference service = mlModel.getService();
        mlModel.withService(null).withDashboard(null);
        this.store(mlModel, update);
        mlModel.withService(service).withDashboard(dashboard);
    }

    @Override
    public void storeRelationships(MlModel mlModel) {
        EntityReference service = mlModel.getService();
        this.addRelationship(service.getId(), mlModel.getId(), service.getType(), "mlmodel", Relationship.CONTAINS);
        this.setDashboard(mlModel, mlModel.getDashboard());
        if (mlModel.getDashboard() != null) {
            this.addRelationship(mlModel.getId(), mlModel.getDashboard().getId(), "mlmodel", "dashboard", Relationship.USES);
        }
        this.setMlFeatureSourcesLineage(mlModel);
    }

    private void setMlFeatureSourcesLineage(MlModel mlModel) {
        if (mlModel.getMlFeatures() != null) {
            mlModel.getMlFeatures().forEach(mlFeature -> {
                if (mlFeature.getFeatureSources() != null) {
                    mlFeature.getFeatureSources().forEach(mlFeatureSource -> {
                        EntityReference targetEntity = mlFeatureSource.getDataSource();
                        if (targetEntity != null) {
                            this.addRelationship(targetEntity.getId(), mlModel.getId(), targetEntity.getType(), "mlmodel", Relationship.UPSTREAM);
                        }
                    });
                }
            });
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(MlModel original, MlModel updated, EntityRepository.Operation operation) {
        return new MlModelUpdater(original, updated, operation);
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        MlModel mlModel = (MlModel)entity;
        EntityUtil.mergeTags(allTags, mlModel.getTags());
        for (MlFeature feature : CommonUtil.listOrEmpty((List)mlModel.getMlFeatures())) {
            EntityUtil.mergeTags(allTags, feature.getTags());
            for (MlFeatureSource source : CommonUtil.listOrEmpty((List)feature.getFeatureSources())) {
                EntityUtil.mergeTags(allTags, source.getTags());
            }
        }
        return allTags;
    }

    @Override
    public void update(TaskDetails task, MessageParser.EntityLink entityLink, String newValue, String user) throws IOException {
        if (entityLink.getFieldName().equals("mlFeatures")) {
            MlModel mlModel = (MlModel)this.getByName(null, entityLink.getEntityFQN(), this.getFields("tags"), Include.ALL);
            MlFeature mlFeature = mlModel.getMlFeatures().stream().filter(c -> c.getName().equals(entityLink.getArrayFieldName())).findFirst().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("chart", entityLink.getArrayFieldName())));
            String origJson = JsonUtils.pojoToJson(mlModel);
            if (EntityUtil.isDescriptionTask(task.getType())) {
                mlFeature.setDescription(newValue);
            } else if (EntityUtil.isTagTask(task.getType())) {
                List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                mlFeature.setTags(tags);
            }
            String updatedEntityJson = JsonUtils.pojoToJson(mlModel);
            JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedEntityJson);
            this.patch(null, mlModel.getId(), user, patch);
            return;
        }
        super.update(task, entityLink, newValue, user);
    }

    private void populateService(MlModel mlModel) throws IOException {
        MlModelService service = (MlModelService)Entity.getEntity(mlModel.getService(), "", Include.NON_DELETED);
        mlModel.setService(service.getEntityReference());
        mlModel.setServiceType(service.getServiceType());
    }

    private EntityReference getDashboard(MlModel mlModel) throws IOException {
        return mlModel == null ? null : this.getToEntityRef(mlModel.getId(), Relationship.USES, "dashboard", false);
    }

    public void setDashboard(MlModel mlModel, EntityReference dashboard) {
        if (dashboard != null) {
            this.addRelationship(mlModel.getId(), mlModel.getDashboard().getId(), "mlmodel", "dashboard", Relationship.USES);
        }
    }

    public class MlModelUpdater
    extends EntityRepository.EntityUpdater {
        public MlModelUpdater(MlModel original, MlModel updated, EntityRepository.Operation operation) {
            super((EntityRepository)MlModelRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateAlgorithm((MlModel)this.original, (MlModel)this.updated);
            this.updateDashboard((MlModel)this.original, (MlModel)this.updated);
            this.updateMlFeatures((MlModel)this.original, (MlModel)this.updated);
            this.updateMlHyperParameters((MlModel)this.original, (MlModel)this.updated);
            this.updateMlStore((MlModel)this.original, (MlModel)this.updated);
            this.updateServer((MlModel)this.original, (MlModel)this.updated);
            this.updateTarget((MlModel)this.original, (MlModel)this.updated);
        }

        private void updateAlgorithm(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            if (this.recordChange("algorithm", origModel.getAlgorithm(), updatedModel.getAlgorithm())) {
                this.majorVersionChange = true;
            }
        }

        private void updateMlFeatures(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            ArrayList addedList = new ArrayList();
            ArrayList deletedList = new ArrayList();
            this.recordListChange("mlFeatures", origModel.getMlFeatures(), updatedModel.getMlFeatures(), addedList, deletedList, EntityUtil.mlFeatureMatch);
        }

        private void updateMlHyperParameters(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            ArrayList addedList = new ArrayList();
            ArrayList deletedList = new ArrayList();
            this.recordListChange("mlHyperParameters", origModel.getMlHyperParameters(), updatedModel.getMlHyperParameters(), addedList, deletedList, EntityUtil.mlHyperParameterMatch);
        }

        private void updateMlStore(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            this.recordChange("mlStore", origModel.getMlStore(), updatedModel.getMlStore(), true);
        }

        private void updateServer(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            if (this.recordChange("server", origModel.getServer(), updatedModel.getServer())) {
                this.majorVersionChange = true;
            }
        }

        private void updateTarget(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            if (this.recordChange("target", origModel.getTarget(), updatedModel.getTarget())) {
                this.majorVersionChange = true;
            }
        }

        private void updateDashboard(MlModel origModel, MlModel updatedModel) throws JsonProcessingException {
            EntityReference updatedDashboard;
            EntityReference origDashboard = origModel.getDashboard();
            if (this.recordChange("dashboard", origDashboard, updatedDashboard = updatedModel.getDashboard(), true, EntityUtil.entityReferenceMatch)) {
                if (origModel.getDashboard() != null) {
                    MlModelRepository.this.deleteTo(updatedModel.getId(), "mlmodel", Relationship.USES, "dashboard");
                }
                if (updatedDashboard != null) {
                    MlModelRepository.this.addRelationship(updatedModel.getId(), updatedDashboard.getId(), "mlmodel", "dashboard", Relationship.USES);
                }
            }
        }
    }
}

