/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRepository
extends EntityRepository<Report> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRepository.class);

    public ReportRepository(CollectionDAO dao) {
        super("/v1/reports/", "report", Report.class, dao.reportDAO(), dao, "", "");
    }

    @Override
    public Report setFields(Report report, EntityUtil.Fields fields) {
        report.setService(this.getService(report));
        return report.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), report.getId()) : null);
    }

    @Override
    public void prepare(Report report) {
    }

    @Override
    public void storeEntity(Report report, boolean update) throws IOException {
        this.store(report, update);
    }

    @Override
    public void storeRelationships(Report report) {
        EntityReference service = report.getService();
        this.addRelationship(service.getId(), report.getId(), service.getType(), "chart", Relationship.CONTAINS);
    }

    private EntityReference getService(Report report) {
        return null;
    }
}

