/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestSummary;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteRepository
extends EntityRepository<TestSuite> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteRepository.class);
    private static final String UPDATE_FIELDS = "tests";
    private static final String PATCH_FIELDS = "tests";

    public TestSuiteRepository(CollectionDAO dao) {
        super("/v1/dataQuality/testSuites", "testSuite", TestSuite.class, dao.testSuiteDAO(), dao, "tests", "tests");
    }

    @Override
    public TestSuite setFields(TestSuite entity, EntityUtil.Fields fields) throws IOException {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : null);
        entity.setSummary(fields.contains("summary") ? this.getTestSummary(entity) : null);
        return entity.withTests(fields.contains("tests") ? this.getTestCases(entity) : null);
    }

    private TestSummary getTestSummary(TestSuite entity) throws IOException {
        List<EntityReference> testCases = this.getTestCases(entity);
        List<String> testCaseFQNs = testCases.stream().map(EntityReference::getFullyQualifiedName).collect(Collectors.toList());
        return EntityUtil.getTestCaseExecutionSummary(this.daoCollection.entityExtensionTimeSeriesDao(), testCaseFQNs, "testCase.testCaseResult");
    }

    @Override
    public void prepare(TestSuite entity) {
    }

    private List<EntityReference> getTestCases(TestSuite entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> testCases = this.findTo(entity.getId(), "testSuite", Relationship.CONTAINS, "testCase");
        return EntityUtil.getEntityReferences(testCases);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
        return new TestSuiteUpdater(original, updated, operation);
    }

    @Override
    public void storeEntity(TestSuite entity, boolean update) throws IOException {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(TestSuite entity) throws IOException {
        if (Boolean.TRUE.equals(entity.getExecutable())) {
            this.storeExecutableRelationship(entity);
        }
    }

    public void storeExecutableRelationship(TestSuite testSuite) throws IOException {
        Table table = (Table)Entity.getEntityByName("table", testSuite.getExecutableEntityReference().getFullyQualifiedName(), null, null);
        this.addRelationship(table.getId(), testSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
    }

    public RestUtil.DeleteResponse<TestSuite> deleteLogicalTestSuite(SecurityContext securityContext, TestSuite original, boolean hardDelete) throws IOException {
        String changeType;
        String updatedBy = securityContext.getUserPrincipal().getName();
        this.preDelete(original);
        this.setFieldsInternal(original, this.putFields);
        TestSuite updated = JsonUtils.readValue(JsonUtils.pojoToJson(original), TestSuite.class);
        this.setFieldsInternal(updated, this.putFields);
        if (this.supportsSoftDelete && !hardDelete) {
            updated.setUpdatedBy(updatedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            updated.setDeleted(Boolean.valueOf(true));
            EntityRepository.EntityUpdater updater = this.getUpdater(original, updated, EntityRepository.Operation.SOFT_DELETE);
            updater.update();
            changeType = "entitySoftDeleted";
        } else {
            this.cleanup(updated);
            changeType = "entityDeleted";
        }
        LOG.info("{} deleted {}", (Object)(hardDelete ? "Hard" : "Soft"), (Object)updated.getFullyQualifiedName());
        return new RestUtil.DeleteResponse<TestSuite>(updated, changeType);
    }

    public class TestSuiteUpdater
    extends EntityRepository.EntityUpdater {
        public TestSuiteUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestSuiteRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            List origTests = CommonUtil.listOrEmpty((List)((TestSuite)this.original).getTests());
            List updatedTests = CommonUtil.listOrEmpty((List)((TestSuite)this.updated).getTests());
            this.recordChange("tests", origTests, updatedTests);
        }
    }
}

