/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.DailyCount;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EntityUsage;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageRepository {
    private static final Logger LOG = LoggerFactory.getLogger(UsageRepository.class);
    private static final String PUT = "createOrUpdate";
    private static final String POST = "createNew";
    private final CollectionDAO dao;

    public UsageRepository(CollectionDAO dao) {
        this.dao = dao;
    }

    @Transaction
    public EntityUsage get(String entityType, String id, String date, int days) throws IOException {
        EntityReference ref = Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.NON_DELETED);
        List<UsageDetails> usageDetails = this.dao.usageDAO().getUsageById(id, date, days - 1);
        return new EntityUsage().withUsage(usageDetails).withEntity(ref);
    }

    @Transaction
    public EntityUsage getByName(String entityType, String fqn, String date, int days) throws IOException {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fqn, Include.NON_DELETED);
        List<UsageDetails> usageDetails = this.dao.usageDAO().getUsageById(ref.getId().toString(), date, days - 1);
        return new EntityUsage().withUsage(usageDetails).withEntity(ref);
    }

    @Transaction
    public RestUtil.PutResponse<?> create(String entityType, String id, DailyCount usage) throws IOException {
        Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.NON_DELETED);
        return this.addUsage(POST, entityType, id, usage);
    }

    @Transaction
    public RestUtil.PutResponse<?> createByName(String entityType, String fullyQualifiedName, DailyCount usage) throws IOException {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fullyQualifiedName, Include.NON_DELETED);
        return this.addUsage(POST, entityType, ref.getId().toString(), usage);
    }

    @Transaction
    public RestUtil.PutResponse<?> createOrUpdate(String entityType, UUID id, DailyCount usage) throws IOException {
        Entity.getEntityReferenceById(entityType, id, Include.NON_DELETED);
        return this.addUsage(PUT, entityType, id.toString(), usage);
    }

    @Transaction
    public RestUtil.PutResponse<?> createOrUpdateByName(String entityType, String fullyQualifiedName, DailyCount usage) throws IOException {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fullyQualifiedName, Include.NON_DELETED);
        return this.addUsage(PUT, entityType, ref.getId().toString(), usage);
    }

    @Transaction
    public void computePercentile(String entityType, String date) {
        this.dao.usageDAO().computePercentile(entityType, date);
    }

    private RestUtil.PutResponse<?> addUsage(String method, String entityType, String entityId, DailyCount usage) throws IOException {
        String type;
        String fields = "usageSummary";
        switch (type = entityType.toLowerCase()) {
            case "table": {
                return this.tableEntityUsage(method, fields, entityId, entityType, usage);
            }
            case "dashboard": {
                return this.dashboardEntityUsage(method, fields, entityId, entityType, usage);
            }
            case "chart": {
                return this.chartEntityUsage(method, fields, entityId, entityType, usage);
            }
            case "mlmodel": {
                return this.mlModelEntityUsage(method, fields, entityId, entityType, usage);
            }
        }
        LOG.error("Invalid Usage Entity Type");
        throw new UnhandledServerException(CatalogExceptionMessage.entityTypeNotSupported(entityType));
    }

    private RestUtil.PutResponse<?> tableEntityUsage(String method, String fields, String entityId, String entityType, DailyCount usage) throws IOException {
        Table table = (Table)Entity.getEntity("table", UUID.fromString(entityId), fields, Include.ALL);
        this.insertToUsageRepository(method, entityId, entityType, usage);
        Table updated = (Table)Entity.getEntity("table", UUID.fromString(entityId), fields, Include.ALL);
        this.dao.usageDAO().insertOrUpdateCount(usage.getDate(), table.getDatabaseSchema().getId().toString(), "databaseSchema", usage.getCount());
        this.dao.usageDAO().insertOrUpdateCount(usage.getDate(), table.getDatabase().getId().toString(), "database", usage.getCount());
        ChangeDescription change = this.getChangeDescription(table.getVersion(), updated.getUsageSummary(), table.getUsageSummary());
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)updated, change, entityType, table.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private RestUtil.PutResponse<?> dashboardEntityUsage(String method, String fields, String entityId, String entityType, DailyCount usage) throws IOException {
        Dashboard dashboard = (Dashboard)Entity.getEntity("dashboard", UUID.fromString(entityId), fields, Include.ALL);
        this.insertToUsageRepository(method, entityId, entityType, usage);
        Dashboard updated = (Dashboard)Entity.getEntity("dashboard", UUID.fromString(entityId), fields, Include.ALL);
        ChangeDescription change = this.getChangeDescription(dashboard.getVersion(), updated.getUsageSummary(), dashboard.getUsageSummary());
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)updated, change, entityType, dashboard.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private RestUtil.PutResponse<?> chartEntityUsage(String method, String fields, String entityId, String entityType, DailyCount usage) throws IOException {
        Chart chart = (Chart)Entity.getEntity("chart", UUID.fromString(entityId), fields, Include.ALL);
        this.insertToUsageRepository(method, entityId, entityType, usage);
        Chart updated = (Chart)Entity.getEntity("chart", UUID.fromString(entityId), fields, Include.ALL);
        ChangeDescription change = this.getChangeDescription(chart.getVersion(), updated.getUsageSummary(), chart.getUsageSummary());
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)updated, change, entityType, chart.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private RestUtil.PutResponse<?> mlModelEntityUsage(String method, String fields, String entityId, String entityType, DailyCount usage) throws IOException {
        MlModel mlModel = (MlModel)Entity.getEntity("mlmodel", UUID.fromString(entityId), fields, Include.ALL);
        this.insertToUsageRepository(method, entityId, entityType, usage);
        MlModel updated = (MlModel)Entity.getEntity("chart", UUID.fromString(entityId), fields, Include.ALL);
        ChangeDescription change = this.getChangeDescription(mlModel.getVersion(), updated.getUsageSummary(), mlModel.getUsageSummary());
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)updated, change, entityType, mlModel.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private void insertToUsageRepository(String method, String entityId, String entityType, DailyCount usage) {
        if (method.equals(POST)) {
            this.dao.usageDAO().insertOrReplaceCount(usage.getDate(), entityId, entityType, usage.getCount());
        } else if (method.equals(PUT)) {
            this.dao.usageDAO().insertOrUpdateCount(usage.getDate(), entityId, entityType, usage.getCount());
        }
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    private ChangeDescription getChangeDescription(Double version, Object newValue, Object oldValue) {
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        EntityUtil.fieldUpdated(change, "usageSummary", oldValue, newValue);
        return change;
    }

    public static class UsageDetailsMapper
    implements RowMapper<UsageDetails> {
        public UsageDetails map(ResultSet r, StatementContext ctx) throws SQLException {
            UsageStats dailyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count1"))).withPercentileRank(Double.valueOf(r.getDouble("percentile1")));
            UsageStats weeklyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count7"))).withPercentileRank(Double.valueOf(r.getDouble("percentile7")));
            UsageStats monthlyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count30"))).withPercentileRank(Double.valueOf(r.getDouble("percentile30")));
            return new UsageDetails().withDate(r.getString("usageDate")).withDailyStats(dailyStats).withWeeklyStats(weeklyStats).withMonthlyStats(monthlyStats);
        }
    }
}

