/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public class WebAnalyticEventRepository
extends EntityRepository<WebAnalyticEvent> {
    public static final String COLLECTION_PATH = "/v1/analytics/web/events";
    private static final String WEB_ANALYTICS_EVENT_DATA_EXTENSION = "webAnalyticEvent.webAnalyticEventData";

    public WebAnalyticEventRepository(CollectionDAO dao) {
        super(COLLECTION_PATH, "webAnalyticEvent", WebAnalyticEvent.class, dao.webAnalyticEventDAO(), dao, "", "");
    }

    @Override
    public WebAnalyticEvent setFields(WebAnalyticEvent entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public void prepare(WebAnalyticEvent entity) {
    }

    @Override
    public void storeEntity(WebAnalyticEvent entity, boolean update) throws IOException {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(WebAnalyticEvent entity) {
    }

    @Transaction
    public Response addWebAnalyticEventData(WebAnalyticEventData webAnalyticEventData) throws IOException {
        webAnalyticEventData.setEventId(UUID.randomUUID());
        this.storeTimeSeries(webAnalyticEventData.getEventType().value(), WEB_ANALYTICS_EVENT_DATA_EXTENSION, "webAnalyticEventData", JsonUtils.pojoToJson(webAnalyticEventData), webAnalyticEventData.getTimestamp(), false);
        return Response.ok((Object)webAnalyticEventData).build();
    }

    @Transaction
    public void deleteWebAnalyticEventData(WebAnalyticEventType name, Long timestamp) {
        this.deleteExtensionBeforeTimestamp(name.value(), WEB_ANALYTICS_EVENT_DATA_EXTENSION, timestamp);
    }

    public ResultList<WebAnalyticEventData> getWebAnalyticEventData(String eventType, Long startTs, Long endTs) throws IOException {
        List<WebAnalyticEventData> webAnalyticEventData = JsonUtils.readObjects(this.getResultsFromAndToTimestamps(eventType, WEB_ANALYTICS_EVENT_DATA_EXTENSION, startTs, endTs), WebAnalyticEventData.class);
        return new ResultList<WebAnalyticEventData>(webAnalyticEventData, String.valueOf(startTs), String.valueOf(endTs), webAnalyticEventData.size());
    }
}

