/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.versions.mysql.v111;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.migration.MigrationFile;
import org.openmetadata.service.migration.api.MigrationStep;
import org.openmetadata.service.migration.versions.utils.v110.MigrationUtil;
import org.openmetadata.service.migration.versions.utils.v111.MigrationUtilV111;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MigrationFile(name="v111_MySQLMigration")
public class MySQLMigration
implements MigrationStep {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLMigration.class);
    private CollectionDAO collectionDAO;
    private MigrationDAO migrationDAO;
    private Handle handle;

    @Override
    public String getMigrationVersion() {
        return "1.1.1";
    }

    @Override
    public String getMigrationFileName() {
        return "v111_MySQLMigration";
    }

    @Override
    public String getFileUuid() {
        return "b5ba61a5-f4e7-48f0-8702-770c1af5757a";
    }

    @Override
    public ConnectionType getDatabaseConnectionType() {
        return ConnectionType.MYSQL;
    }

    @Override
    public void initialize(Handle handle) {
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
        this.migrationDAO = (MigrationDAO)handle.attach(MigrationDAO.class);
    }

    @Override
    public void preDDL() {
        List<String> queryList = List.of("ALTER TABLE test_suite CHANGE COLUMN nameHash fqnHash VARCHAR(256);");
        MigrationUtil.performSqlExecutionAndUpdation(this, this.migrationDAO, this.handle, queryList);
    }

    @Override
    public void runDataMigration() {
        String getSql = "SELECT t1.id AS id1, t2.id AS id2 FROM test_suite t1 JOIN test_suite t2 ON JSON_EXTRACT(t1.json, '$.executableEntityReference.fullyQualifiedName') = JSON_EXTRACT(t2.json, '$.executableEntityReference.fullyQualifiedName') AND t1.id != t2.id";
        MigrationUtilV111.removeDuplicateTestCases(this.collectionDAO, this.handle, getSql);
        String updateSql = "UPDATE test_suite SET json = :json, fqnHash = :fqnHash WHERE id = :id";
        String resultListSql = "select json from test_suite  where JSON_EXTRACT(json, '$.executable') = true";
        MigrationUtilV111.runTestSuiteMigration(this.collectionDAO, this.handle, getSql, updateSql, resultListSql);
    }

    @Override
    public void postDDL() {
    }

    @Override
    public void close() {
    }
}

