/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.versions.postgres.v111;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.migration.MigrationFile;
import org.openmetadata.service.migration.api.MigrationStep;
import org.openmetadata.service.migration.versions.utils.v110.MigrationUtil;
import org.openmetadata.service.migration.versions.utils.v111.MigrationUtilV111;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MigrationFile(name="v111_PostgresMigration")
public class PostgresMigration
implements MigrationStep {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresMigration.class);
    private CollectionDAO collectionDAO;
    private MigrationDAO migrationDAO;
    private Handle handle;

    @Override
    public String getMigrationVersion() {
        return "1.1.1";
    }

    @Override
    public String getMigrationFileName() {
        return "v111_PostgresMigration";
    }

    @Override
    public String getFileUuid() {
        return "a3b76f92-e7cd-461c-90de-e394c91b73d3";
    }

    @Override
    public ConnectionType getDatabaseConnectionType() {
        return ConnectionType.POSTGRES;
    }

    @Override
    public void initialize(Handle handle) {
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
        this.migrationDAO = (MigrationDAO)handle.attach(MigrationDAO.class);
    }

    @Override
    public void preDDL() {
        List<String> queryList = List.of("ALTER TABLE test_suite RENAME COLUMN nameHash TO fqnHash;");
        MigrationUtil.performSqlExecutionAndUpdation(this, this.migrationDAO, this.handle, queryList);
    }

    @Override
    public void runDataMigration() {
        String getSql = "SELECT t1.id AS id1, t2.id AS id2 FROM test_suite t1 JOIN test_suite t2 ON t1.json -> 'executableEntityReference' -> 'fullyQualifiedName' = t2.json -> 'executableEntityReference' -> 'fullyQualifiedName' AND t1.id != t2.id;";
        MigrationUtilV111.removeDuplicateTestCases(this.collectionDAO, this.handle, getSql);
        String updateSql = "UPDATE test_suite SET json = :json::jsonb, fqnHash = :fqnHash WHERE id = :id;";
        String resultListSql = "SELECT json FROM test_suite WHERE json -> 'executable' = 'true'";
        MigrationUtilV111.runTestSuiteMigration(this.collectionDAO, this.handle, getSql, updateSql, resultListSql);
    }

    @Override
    public void postDDL() {
    }

    @Override
    public void close() {
    }
}

