/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.versions.utils.v110;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.api.tests.CreateTestSuite;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.connections.TestConnectionDefinition;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.migration.api.MigrationStep;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final String MYSQL_ENTITY_UPDATE = "UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id";
    private static final String POSTGRES_ENTITY_UPDATE = "UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id";
    private static final String MYSQL_ENTITY_EXTENSION_TIME_SERIES_UPDATE = "UPDATE entity_extension_time_series set entityFQNHash = :entityFQNHash where entityFQN=:entityFQN";
    private static final String POSTGRES_ENTITY_EXTENSION_TIME_SERIES_UPDATE = "UPDATE entity_extension_time_series set entityFQNHash = :entityFQNHash  where entityFQN=:entityFQN";
    private static final String MYSQL_FIELD_RELATIONSHIP_UPDATE = "UPDATE field_relationship SET fromFQNHash = :fromFQNHash, toFQNHash = :toFQNHash where fromFQN= :fromFQN and toFQN = :toFQN";
    private static final String POSTGRES_FIELD_RELATIONSHIP_UPDATE = "UPDATE field_relationship SET fromFQNHash = :fromFQNHash, toFQNHash = :toFQNHash where fromFQN= :fromFQN and toFQN = :toFQN";

    private MigrationUtil() {
    }

    public static <T extends EntityInterface> void updateFQNHashForEntity(Handle handle, Class<T> clazz, EntityDAO<T> dao, int limitParam) {
        String nameHashColumn = dao.getNameHashColumn();
        if (dao instanceof CollectionDAO.TestSuiteDAO) {
            nameHashColumn = "nameHash";
        }
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            MigrationUtil.readAndProcessEntity(handle, String.format("UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id", dao.getTableName(), nameHashColumn), clazz, dao, false, limitParam);
        } else {
            MigrationUtil.readAndProcessEntity(handle, String.format("UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id", dao.getTableName(), nameHashColumn), clazz, dao, false, limitParam);
        }
    }

    public static <T extends EntityInterface> void updateFQNHashForEntityWithName(Handle handle, Class<T> clazz, EntityDAO<T> dao, int limitParam) {
        String nameHashColumn = dao.getNameHashColumn();
        if (dao instanceof CollectionDAO.TestSuiteDAO) {
            nameHashColumn = "nameHash";
        }
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            MigrationUtil.readAndProcessEntity(handle, String.format("UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id", dao.getTableName(), nameHashColumn), clazz, dao, true, limitParam);
        } else {
            MigrationUtil.readAndProcessEntity(handle, String.format("UPDATE %s SET %s = :nameHashColumnValue WHERE id = :id", dao.getTableName(), nameHashColumn), clazz, dao, true, limitParam);
        }
    }

    public static <T extends EntityInterface> void readAndProcessEntity(Handle handle, String updateSql, Class<T> clazz, EntityDAO<T> dao, boolean withName, int limitParam) throws IOException {
        LOG.debug("Starting Migration for table : {}", (Object)dao.getTableName());
        String nameHashColumn = dao.getNameHashColumn();
        if (dao instanceof CollectionDAO.TestSuiteDAO) {
            nameHashColumn = "nameHash";
        }
        block2: while (true) {
            List<String> jsons = dao.migrationListAfterWithOffset(limitParam, nameHashColumn);
            LOG.debug("[{}]Read a Batch of Size: {}", (Object)dao.getTableName(), (Object)jsons.size());
            if (jsons.isEmpty()) break;
            Iterator<String> iterator = jsons.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                String json = iterator.next();
                EntityInterface entity = (EntityInterface)JsonUtils.readValue(json, clazz);
                try {
                    String hash;
                    String string = hash = withName ? FullyQualifiedName.buildHash(EntityInterfaceUtil.quoteName((String)entity.getFullyQualifiedName())) : FullyQualifiedName.buildHash(entity.getFullyQualifiedName());
                    int result = ((Update)((Update)handle.createUpdate(updateSql).bind("nameHashColumnValue", hash)).bind("id", entity.getId().toString())).execute();
                    if (result > 0) continue;
                    LOG.error("No Rows Affected for Updating Hash with Entity Name : {}", (Object)entity.getFullyQualifiedName());
                }
                catch (Exception ex) {
                    LOG.error("Failed in creating FQN Hash for Entity Name : {}", (Object)entity.getFullyQualifiedName(), (Object)ex);
                }
            }
            break;
        }
        LOG.debug("End Migration for table : {}", (Object)dao.getTableName());
    }

    public static MigrationDAO.ServerMigrationSQLTable buildServerMigrationTable(String version, String statement) {
        MigrationDAO.ServerMigrationSQLTable result = new MigrationDAO.ServerMigrationSQLTable();
        result.setVersion(String.valueOf(version));
        result.setSqlStatement(statement);
        result.setCheckSum(EntityUtil.hash(statement));
        return result;
    }

    public static List<MigrationDAO.ServerMigrationSQLTable> addInListIfToBeExecuted(String version, Set<String> lookUp, List<String> queries) {
        ArrayList<MigrationDAO.ServerMigrationSQLTable> result = new ArrayList<MigrationDAO.ServerMigrationSQLTable>();
        for (String query : queries) {
            MigrationDAO.ServerMigrationSQLTable tableContent = MigrationUtil.buildServerMigrationTable(version, query);
            if (!lookUp.contains(tableContent.getCheckSum())) {
                result.add(tableContent);
                continue;
            }
            LOG.debug("Query will be skipped in Migration Step , as this has already been executed");
        }
        return result;
    }

    public static void dataMigrationFQNHashing(Handle handle, CollectionDAO collectionDAO, int limitParam) {
        MigrationUtil.updateFQNHashForEntityWithName(handle, Bot.class, collectionDAO.botDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, User.class, collectionDAO.userDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, Team.class, collectionDAO.teamDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, DatabaseService.class, collectionDAO.dbServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, DashboardService.class, collectionDAO.dashboardServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, MessagingService.class, collectionDAO.messagingServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, MetadataService.class, collectionDAO.metadataServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, MlModelService.class, collectionDAO.mlModelServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, StorageService.class, collectionDAO.storageServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntityWithName(handle, PipelineService.class, collectionDAO.pipelineServiceDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, IngestionPipeline.class, collectionDAO.ingestionPipelineDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Database.class, collectionDAO.databaseDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, DatabaseSchema.class, collectionDAO.databaseSchemaDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Table.class, collectionDAO.tableDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Query.class, collectionDAO.queryDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Topic.class, collectionDAO.topicDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Dashboard.class, collectionDAO.dashboardDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, DashboardDataModel.class, collectionDAO.dashboardDataModelDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Chart.class, collectionDAO.chartDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Container.class, collectionDAO.containerDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, MlModel.class, collectionDAO.mlModelDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Pipeline.class, collectionDAO.pipelineDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Metrics.class, collectionDAO.metricsDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Report.class, collectionDAO.reportDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Classification.class, collectionDAO.classificationDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Glossary.class, collectionDAO.glossaryDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, GlossaryTerm.class, collectionDAO.glossaryTermDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Tag.class, collectionDAO.tagDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, DataInsightChart.class, collectionDAO.dataInsightChartDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Kpi.class, collectionDAO.kpiDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, TestCase.class, collectionDAO.testCaseDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, TestConnectionDefinition.class, collectionDAO.testConnectionDefinitionDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, TestDefinition.class, collectionDAO.testDefinitionDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, TestSuite.class, collectionDAO.testSuiteDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Policy.class, collectionDAO.policyDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, EventSubscription.class, collectionDAO.eventSubscriptionDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Role.class, collectionDAO.roleDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Type.class, collectionDAO.typeEntityDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, WebAnalyticEvent.class, collectionDAO.webAnalyticEventDAO(), limitParam);
        MigrationUtil.updateFQNHashForEntity(handle, Workflow.class, collectionDAO.workflowDAO(), limitParam);
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            MigrationUtil.updateFQNHashForFieldRelationship(handle, "UPDATE field_relationship SET fromFQNHash = :fromFQNHash, toFQNHash = :toFQNHash where fromFQN= :fromFQN and toFQN = :toFQN", collectionDAO, limitParam);
        } else {
            MigrationUtil.updateFQNHashForFieldRelationship(handle, "UPDATE field_relationship SET fromFQNHash = :fromFQNHash, toFQNHash = :toFQNHash where fromFQN= :fromFQN and toFQN = :toFQN", collectionDAO, limitParam);
        }
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            MigrationUtil.updateFQNHashEntityExtensionTimeSeries(handle, MYSQL_ENTITY_EXTENSION_TIME_SERIES_UPDATE, collectionDAO, limitParam);
        } else {
            MigrationUtil.updateFQNHashEntityExtensionTimeSeries(handle, POSTGRES_ENTITY_EXTENSION_TIME_SERIES_UPDATE, collectionDAO, limitParam);
        }
        MigrationUtil.updateFQNHashTagUsage(collectionDAO);
    }

    private static void updateFQNHashForFieldRelationship(Handle handle, String updateSql, CollectionDAO collectionDAO, int limitParam) {
        LOG.debug("Starting Migration for Field Relationship");
        while (true) {
            List<Pair<String, String>> entityFQNPairList = collectionDAO.fieldRelationshipDAO().migrationListDistinctWithOffset(limitParam);
            LOG.debug("[FieldRelationship] Read a Batch of Size: {}", (Object)entityFQNPairList.size());
            if (entityFQNPairList.isEmpty()) break;
            for (Pair<String, String> entityFQNPair : entityFQNPairList) {
                try {
                    String fromFQNHash = FullyQualifiedName.buildHash((String)entityFQNPair.getLeft());
                    String toFQNHash = FullyQualifiedName.buildHash((String)entityFQNPair.getRight());
                    int result = ((Update)((Update)((Update)((Update)handle.createUpdate(updateSql).bind("fromFQNHash", fromFQNHash)).bind("toFQNHash", toFQNHash)).bind("fromFQN", (String)entityFQNPair.getLeft())).bind("toFQN", (String)entityFQNPair.getRight())).execute();
                    if (result > 0) continue;
                    LOG.error("No Rows Affected for Updating Field Relationship fromFQN : {}, toFQN : {}", entityFQNPair.getLeft(), entityFQNPair.getRight());
                }
                catch (Exception ex) {
                    LOG.error("Failed in creating fromFQN : {} , toFQN : {}", new Object[]{entityFQNPair.getLeft(), entityFQNPair.getRight(), ex});
                }
            }
            LOG.debug("[FieldRelationship] Committing a Batch of Size: {}", (Object)entityFQNPairList.size());
        }
        LOG.debug("End Migration for Field Relationship");
    }

    private static void updateFQNHashEntityExtensionTimeSeries(Handle handle, String updateSql, CollectionDAO collectionDAO, int limitParam) {
        LOG.debug("Starting Migration for Entity Extension Time Series");
        try {
            collectionDAO.entityExtensionTimeSeriesDao().listDistinctCount();
        }
        catch (Exception ex) {
            return;
        }
        while (true) {
            List<String> entityFQNLists = collectionDAO.entityExtensionTimeSeriesDao().migrationListDistinctWithOffset(limitParam);
            LOG.debug("[TimeSeries] Read a Batch of Size: {}", (Object)entityFQNLists.size());
            if (entityFQNLists.isEmpty()) break;
            for (String entityFQN : entityFQNLists) {
                try {
                    int result = ((Update)((Update)handle.createUpdate(updateSql).bind("entityFQNHash", FullyQualifiedName.buildHash(entityFQN))).bind("entityFQN", entityFQN)).execute();
                    if (result > 0) continue;
                    LOG.error("No Rows Affected for Updating entity_extension_time_series entityFQN : {}", (Object)entityFQN);
                }
                catch (Exception ex) {
                    LOG.error("Failed in creating EntityFQN : {}", (Object)entityFQN, (Object)ex);
                }
            }
            LOG.debug("[TimeSeries] Committing a Batch of Size: {}", (Object)entityFQNLists.size());
        }
        LOG.debug("Ended Migration for Entity Extension Time Series");
    }

    public static void updateFQNHashTagUsage(CollectionDAO collectionDAO) {
        LOG.debug("Starting Migration for Tag Usage");
        List<CollectionDAO.TagUsageDAO.TagLabelMigration> tagLabelMigrationList = collectionDAO.tagUsageDAO().listAll();
        for (CollectionDAO.TagUsageDAO.TagLabelMigration tagLabel : tagLabelMigrationList) {
            if (!CommonUtil.nullOrEmpty((String)tagLabel.getTagFQNHash()) || !CommonUtil.nullOrEmpty((String)tagLabel.getTargetFQNHash())) continue;
            try {
                String tagFQNHash = FullyQualifiedName.buildHash(tagLabel.getTagFQN());
                String targetFQNHash = FullyQualifiedName.buildHash(tagLabel.getTargetFQN());
                collectionDAO.tagUsageDAO().upsertFQNHash(tagLabel.getSource(), tagLabel.getTagFQN(), tagFQNHash, targetFQNHash, tagLabel.getLabelType(), tagLabel.getState(), tagLabel.getTargetFQN());
            }
            catch (Exception ex) {
                LOG.error("Failed in creating tagFQN : {}, targetFQN: {}", new Object[]{tagLabel.getTagFQN(), tagLabel.getTargetFQN(), ex});
            }
        }
        LOG.debug("Ended Migration for Tag Usage");
    }

    public static void performSqlExecutionAndUpdation(MigrationStep step, MigrationDAO migrationDAO, Handle handle, List<String> queryList) {
        HashSet<String> executedSQLChecksums = new HashSet<String>(migrationDAO.getServerMigrationSQLWithVersion(String.valueOf(step.getMigrationVersion())));
        List<MigrationDAO.ServerMigrationSQLTable> toBeExecuted = MigrationUtil.addInListIfToBeExecuted(String.valueOf(step.getMigrationVersion()), executedSQLChecksums, queryList);
        for (MigrationDAO.ServerMigrationSQLTable tableData : toBeExecuted) {
            handle.execute(tableData.getSqlStatement(), new Object[0]);
            migrationDAO.upsertServerMigrationSQL(tableData.getVersion(), tableData.getSqlStatement(), tableData.getCheckSum());
        }
    }

    public static TestSuite getTestSuite(CollectionDAO dao, CreateTestSuite create, String user) throws IOException {
        TestSuite testSuite = MigrationUtil.copy(new TestSuite(), (CreateEntity)create, user).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withName(create.getName());
        if (create.getExecutableEntityReference() != null) {
            TableRepository tableRepository = new TableRepository(dao);
            Table table = JsonUtils.readValue(tableRepository.getDao().findJsonByFqn(create.getExecutableEntityReference(), Include.ALL), Table.class);
            EntityReference entityReference = new EntityReference().withId(table.getId()).withFullyQualifiedName(table.getFullyQualifiedName()).withName(table.getName()).withType("table");
            testSuite.setExecutableEntityReference(entityReference);
        }
        return testSuite;
    }

    public static TestSuite copy(TestSuite entity, CreateEntity request, String updatedBy) {
        entity.setId(UUID.randomUUID());
        entity.setName(request.getName());
        entity.setDisplayName(request.getDisplayName());
        entity.setDescription(request.getDescription());
        entity.setExtension(request.getExtension());
        entity.setUpdatedBy(updatedBy);
        entity.setOwner(null);
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    public static void testSuitesMigration(CollectionDAO collectionDAO) {
        IngestionPipelineRepository ingestionPipelineRepository = new IngestionPipelineRepository(collectionDAO);
        TestSuiteRepository testSuiteRepository = new TestSuiteRepository(collectionDAO);
        TestCaseRepository testCaseRepository = new TestCaseRepository(collectionDAO);
        List testCases = testCaseRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        for (TestCase test : testCases) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
            String testSuiteFqn = entityLink.getEntityFQN() + ".testSuite";
            try {
                testSuiteRepository.getDao().findEntityByName(EntityInterfaceUtil.quoteName((String)testSuiteFqn), "nameHash", Include.ALL);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                try {
                    TestSuite stored = (TestSuite)testSuiteRepository.getDao().findEntityByName(EntityInterfaceUtil.quoteName((String)testSuiteFqn), "nameHash", Include.ALL);
                    testSuiteRepository.addRelationship(stored.getId(), test.getId(), "testSuite", "testCase", Relationship.CONTAINS);
                    stored.setExecutable(Boolean.valueOf(true));
                    stored.setName(FullyQualifiedName.buildHash(testSuiteFqn));
                    stored.setFullyQualifiedName(EntityInterfaceUtil.quoteName((String)FullyQualifiedName.buildHash(testSuiteFqn)));
                    stored.setDisplayName(testSuiteFqn);
                    testSuiteRepository.getDao().update("nameHash", (EntityInterface)stored);
                }
                catch (EntityNotFoundException ex) {
                    try {
                        TestSuite newExecutableTestSuite = MigrationUtil.getTestSuite(collectionDAO, new CreateTestSuite().withName(FullyQualifiedName.buildHash(testSuiteFqn)).withDisplayName(testSuiteFqn).withExecutableEntityReference(entityLink.getEntityFQN()), "ingestion-bot").withExecutable(Boolean.valueOf(false));
                        testSuiteRepository.prepareInternal(newExecutableTestSuite);
                        testSuiteRepository.getDao().insert("nameHash", (EntityInterface)newExecutableTestSuite, FullyQualifiedName.buildHash(EntityInterfaceUtil.quoteName((String)newExecutableTestSuite.getFullyQualifiedName())));
                        testSuiteRepository.addRelationship(newExecutableTestSuite.getExecutableEntityReference().getId(), newExecutableTestSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
                        testSuiteRepository.addRelationship(newExecutableTestSuite.getId(), test.getId(), "testSuite", "testCase", Relationship.CONTAINS);
                        TestSuite temp = (TestSuite)testSuiteRepository.getDao().findEntityByName(EntityInterfaceUtil.quoteName((String)FullyQualifiedName.buildHash(testSuiteFqn)), "nameHash", Include.ALL);
                        temp.setExecutable(Boolean.valueOf(true));
                        testSuiteRepository.setFullyQualifiedName(temp);
                        testSuiteRepository.getDao().update("nameHash", (EntityInterface)temp);
                    }
                    catch (Exception exIgnore) {
                        LOG.warn("Ignoring error since already added: {}", (Object)ex.getMessage());
                    }
                }
            }
        }
        ListFilter filter = new ListFilter(Include.ALL);
        filter.addQueryParam("testSuiteType", "logical");
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(Set.of("id")), filter);
        for (TestSuite testSuiteRecord : testSuites) {
            TestSuite temp = (TestSuite)testSuiteRepository.getDao().findEntityById(testSuiteRecord.getId());
            if (Boolean.FALSE.equals(temp.getExecutable())) {
                temp.setExecutable(Boolean.valueOf(false));
                testSuiteRepository.getDao().update("nameHash", (EntityInterface)temp);
            }
            try {
                List<CollectionDAO.EntityRelationshipRecord> ingestionPipelineRecords = collectionDAO.relationshipDAO().findTo(testSuiteRecord.getId().toString(), "testSuite", Relationship.CONTAINS.ordinal(), "ingestionPipeline");
                for (CollectionDAO.EntityRelationshipRecord ingestionRecord : ingestionPipelineRecords) {
                    collectionDAO.relationshipDAO().deleteAll(ingestionRecord.getId().toString(), "ingestionPipeline");
                    ingestionPipelineRepository.getDao().delete(ingestionRecord.getId().toString());
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
        }
    }
}

