/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.versions.utils.v111;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtilV111 {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtilV111.class);

    private MigrationUtilV111() {
    }

    public static void removeDuplicateTestCases(CollectionDAO collectionDAO, Handle handle, String getSql) {
        List resultList = handle.createQuery(getSql).mapToMap().list();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map idMap : resultList) {
            String id1 = (String)idMap.get("id1");
            String id2 = (String)idMap.get("id2");
            if (resultMap.containsKey(id1) || resultMap.containsKey(id2)) continue;
            resultMap.put(id1, id2);
        }
        resultMap.forEach((k, v) -> {
            Object toId;
            List<CollectionDAO.EntityRelationshipRecord> records = collectionDAO.relationshipDAO().findTo((String)k, "testSuite", Relationship.CONTAINS.ordinal(), "testCase");
            List<CollectionDAO.EntityRelationshipRecord> ingestionRecords = collectionDAO.relationshipDAO().findTo((String)k, "testSuite", Relationship.CONTAINS.ordinal(), "ingestionPipeline");
            for (CollectionDAO.EntityRelationshipRecord record : records) {
                toId = record.getId();
                collectionDAO.relationshipDAO().insert(UUID.fromString(v), (UUID)toId, "testSuite", "testCase", Relationship.CONTAINS.ordinal());
            }
            try {
                collectionDAO.testSuiteDAO().delete((String)k);
                collectionDAO.relationshipDAO().deleteAllWithId((String)k);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CollectionDAO.EntityRelationshipRecord record : ingestionRecords) {
                try {
                    toId = record.getId().toString();
                    collectionDAO.ingestionPipelineDAO().delete((String)toId);
                    collectionDAO.relationshipDAO().deleteAllWithId((String)toId);
                }
                catch (Exception exception) {}
            }
        });
    }

    public static void runTestSuiteMigration(CollectionDAO collectionDAO, Handle handle, String getSql, String updateSql, String resultListSql) throws IOException {
        List resultList = handle.createQuery(resultListSql).mapToMap().list();
        for (Map row : resultList) {
            if (!row.containsKey("json")) continue;
            TestSuite suite = null;
            if (row.get("json") instanceof String) {
                suite = JsonUtils.readValue((String)row.get("json"), TestSuite.class);
            } else if (row.get("json") instanceof PGobject) {
                suite = JsonUtils.readValue(((PGobject)row.get("json")).getValue(), TestSuite.class);
            }
            if (!Boolean.TRUE.equals(suite.getExecutable())) continue;
            if (suite.getExecutableEntityReference() != null) {
                MigrationUtilV111.updateTestSuite(handle, suite, updateSql);
                continue;
            }
            String entityName = StringUtils.replaceOnce((String)suite.getDisplayName(), (String)".testSuite", (String)"");
            try {
                Table table = (Table)collectionDAO.tableDAO().findEntityByName(entityName, Include.ALL);
                suite.setExecutable(Boolean.valueOf(true));
                suite.setExecutableEntityReference(table.getEntityReference());
                MigrationUtilV111.updateTestSuite(handle, suite, updateSql);
                MigrationUtilV111.removeDuplicateTestCases(collectionDAO, handle, getSql);
            }
            catch (Exception ex) {
                try {
                    collectionDAO.testSuiteDAO().delete(suite.getId().toString());
                    collectionDAO.relationshipDAO().deleteAllWithId(suite.getId().toString());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void updateTestSuite(Handle handle, TestSuite suite, String updateSql) throws JsonProcessingException {
        if (suite.getExecutableEntityReference() != null) {
            try {
                EntityReference executableEntityRef = suite.getExecutableEntityReference();
                suite.setName(String.format("%s.testSuite", executableEntityRef.getName()));
                suite.setFullyQualifiedName(String.format("%s.testSuite", executableEntityRef.getFullyQualifiedName()));
                int result = ((Update)((Update)((Update)handle.createUpdate(updateSql).bind("json", JsonUtils.pojoToJson(suite))).bind("fqnHash", FullyQualifiedName.buildHash(suite.getFullyQualifiedName()))).bind("id", suite.getId().toString())).execute();
                if (result <= 0) {
                    LOG.error("No Rows Affected for 1.1.1 test suite Migration");
                }
            }
            catch (Exception ex) {
                LOG.error("Error in Updating Test Suite with FQN : {}", (Object)suite.getFullyQualifiedName(), (Object)ex);
                throw ex;
            }
        }
    }
}

