/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.domains;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.domains.CreateDataProduct;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataProductRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/dataProducts")
@Tag(name="Domains", description="A `Data Product` or `Data as a Product` is a logical unit that contains all components to process and store domain data for analytical or data-intensive use cases made available to data consumers.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="dataProducts", order=4)
public class DataProductResource
extends EntityResource<DataProduct, DataProductRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(DataProductResource.class);
    public static final String COLLECTION_PATH = "/v1/dataProducts/";
    static final String FIELDS = "domain,owner,experts";

    public DataProductResource(CollectionDAO dao, Authorizer authorizer) {
        super(DataProduct.class, new DataProductRepository(dao), authorizer);
    }

    @Override
    public DataProduct addHref(UriInfo uriInfo, DataProduct dataProduct) {
        dataProduct.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, dataProduct.getId()));
        Entity.withHref(uriInfo, dataProduct.getExperts());
        Entity.withHref(uriInfo, dataProduct.getOwner());
        Entity.withHref(uriInfo, dataProduct.getDomain());
        return dataProduct;
    }

    @GET
    @Operation(operationId="listDataProducts", summary="List dataProducts", description="Get a list of DataProducts.", responses={@ApiResponse(responseCode="200", description="List of DataProducts", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProductList.class))})})
    public ResultList<DataProduct> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="domain,owner,experts")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of DataProduct before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of DataProduct after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) throws IOException {
        return this.listInternal(uriInfo, securityContext, fieldsParam, new ListFilter(null), limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDataProductByID", summary="Get a dataProduct by Id", description="Get a dataProduct by `Id`.", responses={@ApiResponse(responseCode="200", description="The dataProduct", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProduct.class))}), @ApiResponse(responseCode="404", description="DataProduct for instance {id} is not found")})
    public DataProduct get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="domain,owner,experts")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Id of the dataProduct", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return (DataProduct)this.getInternal(uriInfo, securityContext, id, fieldsParam, null);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getDataProductByFQN", summary="Get a dataProduct by name", description="Get a dataProduct by `name`.", responses={@ApiResponse(responseCode="200", description="dataProduct", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProduct.class))}), @ApiResponse(responseCode="404", description="DataProduct for instance {name} is not found")})
    public DataProduct getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the dataProduct", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="domain,owner,experts")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        return (DataProduct)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, null);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDataProductVersion", summary="List dataProduct versions", description="Get a list of all the versions of a dataProduct identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of dataProduct versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dataProduct", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="listSpecificDataProductVersion", summary="Get a version of the dataProduct", description="Get a version of the dataProduct by given `Id`", responses={@ApiResponse(responseCode="200", description="dataProduct", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProduct.class))}), @ApiResponse(responseCode="404", description="DataProduct for instance {id} and version {version} is not found")})
    public DataProduct getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dataProduct", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="DataProduct version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (DataProduct)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDataProduct", summary="Create a dataProduct", description="Create a new dataProduct.", responses={@ApiResponse(responseCode="200", description="The dataProduct ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProduct.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDataProduct create) throws IOException {
        DataProduct dataProduct = this.getDataProduct(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, dataProduct);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDataProduct", summary="Create or update a dataProduct", description="Create a dataProduct. if it does not exist. If a dataProduct already exists, update the dataProduct.", responses={@ApiResponse(responseCode="200", description="The dataProduct", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataProduct.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDataProduct create) throws IOException {
        DataProduct dataProduct = this.getDataProduct(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, dataProduct);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDataProduct", summary="Update a dataProduct", description="Update an existing dataProduct using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dataProduct", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDataProduct", summary="Delete a dataProduct by Id", description="Delete a dataProduct by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DataProduct for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dataProduct", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, true, true);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteDataProductByFQN", summary="Delete a dataProduct by name", description="Delete a dataProduct by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DataProduct for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the dataProduct", schema=@Schema(type="string")) @PathParam(value="name") String name) throws IOException {
        return this.deleteByName(uriInfo, securityContext, name, true, true);
    }

    private DataProduct getDataProduct(CreateDataProduct create, String user) throws IOException {
        List<String> experts = create.getExperts() == null ? create.getExperts() : create.getExperts().stream().map(EntityInterfaceUtil::quoteName).collect(Collectors.toList());
        return this.copy(new DataProduct(), (CreateEntity)create, user).withFullyQualifiedName(create.getName()).withExperts(EntityUtil.populateEntityReferences(this.getEntityReferences("user", experts)));
    }

    public static class DataProductList
    extends ResultList<DataProduct> {
    }
}

