/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.domains;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.domains.CreateDomain;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DomainRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/domains")
@Tag(name="Domains", description="A `Domain` is a bounded context that is aligned with a Business Unit or a function within an organization.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="domains", order=4)
public class DomainResource
extends EntityResource<Domain, DomainRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(DomainResource.class);
    public static final String COLLECTION_PATH = "/v1/domains/";
    static final String FIELDS = "children,owner,parent,experts";

    public DomainResource(CollectionDAO dao, Authorizer authorizer) {
        super(Domain.class, new DomainRepository(dao), authorizer);
    }

    @Override
    public Domain addHref(UriInfo uriInfo, Domain domain) {
        domain.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, domain.getId()));
        Entity.withHref(uriInfo, domain.getParent());
        Entity.withHref(uriInfo, domain.getChildren());
        Entity.withHref(uriInfo, domain.getExperts());
        Entity.withHref(uriInfo, domain.getOwner());
        return domain;
    }

    @GET
    @Operation(operationId="listDomains", summary="List domains", description="Get a list of Domains.", responses={@ApiResponse(responseCode="200", description="List of Domains", content={@Content(mediaType="application/json", schema=@Schema(implementation=DomainList.class))})})
    public ResultList<Domain> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,owner,parent,experts")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of Domain before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of Domain after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) throws IOException {
        return this.listInternal(uriInfo, securityContext, fieldsParam, new ListFilter(null), limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDomainByID", summary="Get a domain by Id", description="Get a domain by `Id`.", responses={@ApiResponse(responseCode="200", description="The domain", content={@Content(mediaType="application/json", schema=@Schema(implementation=Domain.class))}), @ApiResponse(responseCode="404", description="Domain for instance {id} is not found")})
    public Domain get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,owner,parent,experts")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Id of the domain", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return (Domain)this.getInternal(uriInfo, securityContext, id, fieldsParam, null);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getDomainByFQN", summary="Get a domain by name", description="Get a domain by `name`.", responses={@ApiResponse(responseCode="200", description="domain", content={@Content(mediaType="application/json", schema=@Schema(implementation=Domain.class))}), @ApiResponse(responseCode="404", description="Domain for instance {name} is not found")})
    public Domain getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the domain", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,owner,parent,experts")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        return (Domain)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, null);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDomainVersion", summary="List domain versions", description="Get a list of all the versions of a domain identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of domain versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the domain", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="listSpecificDomainVersion", summary="Get a version of the domain", description="Get a version of the domain by given `Id`", responses={@ApiResponse(responseCode="200", description="domain", content={@Content(mediaType="application/json", schema=@Schema(implementation=Domain.class))}), @ApiResponse(responseCode="404", description="Domain for instance {id} and version {version} is not found")})
    public Domain getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the domain", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Domain version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Domain)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDomain", summary="Create a domain", description="Create a new domain.", responses={@ApiResponse(responseCode="200", description="The domain ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Domain.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDomain create) throws IOException {
        Domain domain = this.getDomain(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, domain);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDomain", summary="Create or update a domain", description="Create a domain. if it does not exist. If a domain already exists, update the domain.", responses={@ApiResponse(responseCode="200", description="The domain", content={@Content(mediaType="application/json", schema=@Schema(implementation=Domain.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDomain create) throws IOException {
        Domain domain = this.getDomain(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, domain);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDomain", summary="Update a domain", description="Update an existing domain using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the domain", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDomain", summary="Delete a domain by Id", description="Delete a domain by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Domain for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the domain", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, true, true);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteDomainByFQN", summary="Delete a domain by name", description="Delete a domain by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Domain for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the domain", schema=@Schema(type="string")) @PathParam(value="name") String name) throws IOException {
        return this.deleteByName(uriInfo, securityContext, name, true, true);
    }

    private Domain getDomain(CreateDomain create, String user) throws IOException {
        List<String> experts = create.getExperts() == null ? create.getExperts() : create.getExperts().stream().map(EntityInterfaceUtil::quoteName).collect(Collectors.toList());
        return this.copy(new Domain(), (CreateEntity)create, user).withDomainType(create.getDomainType()).withFullyQualifiedName(create.getName()).withParent(Entity.getEntityReference(this.getEntityReference("domain", create.getParent()), Include.NON_DELETED)).withExperts(EntityUtil.populateEntityReferences(this.getEntityReferences("user", experts)));
    }

    public static class DomainList
    extends ResultList<Domain> {
    }
}

