/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.glossary;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateGlossaryTerm;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.GlossaryTermRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.tags.TagLabelCache;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/glossaryTerms")
@Tag(name="Glossaries", description="A `Glossary` is collection of hierarchical `GlossaryTerms`.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="glossaryTerms", order=7)
public class GlossaryTermResource
extends EntityResource<GlossaryTerm, GlossaryTermRepository> {
    public static final String COLLECTION_PATH = "v1/glossaryTerms/";
    static final String FIELDS = "children,relatedTerms,reviewers,owner,tags,usageCount,domain";

    @Override
    public GlossaryTerm addHref(UriInfo uriInfo, GlossaryTerm term) {
        term.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, term.getId()));
        Entity.withHref(uriInfo, term.getGlossary());
        Entity.withHref(uriInfo, term.getParent());
        Entity.withHref(uriInfo, term.getChildren());
        Entity.withHref(uriInfo, term.getRelatedTerms());
        Entity.withHref(uriInfo, term.getReviewers());
        Entity.withHref(uriInfo, term.getOwner());
        return term;
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        TagLabelCache.initialize();
    }

    public GlossaryTermResource(CollectionDAO dao, Authorizer authorizer) {
        super(GlossaryTerm.class, new GlossaryTermRepository(dao), authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("children,relatedTerms,reviewers,usageCount", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Valid
    @Operation(operationId="listGlossaryTerm", summary="List glossary terms", description="Get a list of glossary terms. Use `fields` parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of glossary terms", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlossaryTermList.class))})})
    public ResultList<GlossaryTerm> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="List glossary terms filtered by glossary identified by Id given in `glossary` parameter.", schema=@Schema(type="string", example="children,relatedTerms,reviewers,owner,tags,usageCount,domain")) @QueryParam(value="glossary") String glossaryIdParam, @Parameter(description="List glossary terms filtered by children of glossary term identified by Id given in `parent` parameter.", schema=@Schema(type="string", example="children,relatedTerms,reviewers,owner,tags,usageCount,domain")) @QueryParam(value="parent") UUID parentTermParam, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,relatedTerms,reviewers,owner,tags,usageCount,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number glossary terms returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of glossary terms before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of glossary terms after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        RestUtil.validateCursors(before, after);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        String fqn = null;
        EntityReference glossary = null;
        if (glossaryIdParam != null) {
            glossary = ((GlossaryTermRepository)this.repository).getGlossary(glossaryIdParam);
            fqn = EntityInterfaceUtil.quoteName((String)glossary.getName());
        }
        if (parentTermParam != null) {
            GlossaryTerm parentTerm = (GlossaryTerm)((GlossaryTermRepository)this.repository).get(uriInfo, parentTermParam, EntityUtil.Fields.EMPTY_FIELDS);
            fqn = parentTerm.getFullyQualifiedName();
            if (glossary != null && !parentTerm.getGlossary().getId().equals(glossary.getId())) {
                throw new IllegalArgumentException(CatalogExceptionMessage.glossaryTermMismatch(parentTermParam.toString(), glossaryIdParam));
            }
        }
        ListFilter filter = new ListFilter(include).addQueryParam("parent", fqn);
        ResultList terms = before != null ? ((GlossaryTermRepository)this.repository).listBefore(uriInfo, fields, filter, limitParam, before) : ((GlossaryTermRepository)this.repository).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, terms);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getGlossaryTermByID", summary="Get a glossary term by Id", description="Get a glossary term by `Id`.", responses={@ApiResponse(responseCode="200", description="The glossary term", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {id} is not found")})
    public GlossaryTerm get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the glossary term", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,relatedTerms,reviewers,owner,tags,usageCount,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (GlossaryTerm)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getGlossaryTermByFQN", summary="Get a glossary term by fully qualified name", description="Get a glossary term by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The glossary term", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {fqn} is not found")})
    public GlossaryTerm getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the glossary term", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="children,relatedTerms,reviewers,owner,tags,usageCount,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (GlossaryTerm)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllGlossaryTermVersion", summary="List glossary term versions", description="Get a list of all the versions of a glossary terms identified by `id`", responses={@ApiResponse(responseCode="200", description="List of glossary term versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the glossary term", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificGlossaryTermVersion", summary="Get a version of the glossary term", description="Get a version of the glossary term by given `Id`", responses={@ApiResponse(responseCode="200", description="glossaries", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {id} and version {version} is not found")})
    public GlossaryTerm getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the glossary term", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="glossary term version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (GlossaryTerm)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createGlossaryTerm", summary="Create a glossary term", description="Create a new glossary term.", responses={@ApiResponse(responseCode="200", description="The glossary term", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlossaryTerm.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateGlossaryTerm create) throws IOException {
        GlossaryTerm term = this.getGlossaryTerm(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, term);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchGlossaryTerm", summary="Update a glossary term", description="Update an existing glossary term using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the glossary term", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateGlossaryTerm", summary="Create or update a glossary term", description="Create a new glossary term, if it does not exist or update an existing glossary term.", responses={@ApiResponse(responseCode="200", description="The glossary", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlossaryTerm.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateGlossaryTerm create) throws IOException {
        GlossaryTerm term = this.getGlossaryTerm(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, term);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete a glossary term by Id", description="Delete a glossary term by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="glossaryTerm for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the glossary term", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteGlossaryTermByName", summary="Delete a glossary term by fully qualified name", description="Delete a glossary term by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="glossaryTerm for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the glossary term", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted glossary term", description="Restore a soft deleted glossary term.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Chart ", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlossaryTerm.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private GlossaryTerm getGlossaryTerm(CreateGlossaryTerm create, String user) throws IOException {
        return this.copy(new GlossaryTerm(), (CreateEntity)create, user).withSynonyms(create.getSynonyms()).withGlossary(this.getEntityReference("glossary", create.getGlossary())).withParent(this.getEntityReference("glossaryTerm", create.getParent())).withRelatedTerms(this.getEntityReferences("glossaryTerm", create.getRelatedTerms())).withReferences(create.getReferences()).withReviewers(this.getEntityReferences("user", create.getReviewers() == null ? create.getReviewers() : create.getReviewers().stream().map(EntityInterfaceUtil::quoteName).collect(Collectors.toList()))).withTags(create.getTags()).withProvider(create.getProvider()).withMutuallyExclusive(create.getMutuallyExclusive());
    }

    public static class GlossaryTermList
    extends ResultList<GlossaryTerm> {
    }
}

