/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.ingestionpipelines;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.ingestionPipelines.CreateIngestionPipeline;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.MetadataToElasticSearchPipeline;
import org.openmetadata.schema.metadataIngestion.SourceConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MetadataServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.IngestionPipelineUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/services/ingestionPipelines")
@Tag(name="Ingestion Pipelines", description="APIs related pipelines/workflows created by the system to ingest metadata.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="IngestionPipelines")
public class IngestionPipelineResource
extends EntityResource<IngestionPipeline, IngestionPipelineRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(IngestionPipelineResource.class);
    private static final String DEFAULT_INSIGHT_PIPELINE = "OpenMetadata_dataInsight";
    private static final String DEFAULT_REINDEX_PIPELINE = "OpenMetadata_elasticSearchReindex";
    public static final String COLLECTION_PATH = "v1/services/ingestionPipelines/";
    private PipelineServiceClient pipelineServiceClient;
    private OpenMetadataApplicationConfig openMetadataApplicationConfig;
    private final MetadataServiceRepository metadataServiceRepository;
    static final String FIELDS = "owner";

    @Override
    public IngestionPipeline addHref(UriInfo uriInfo, IngestionPipeline ingestionPipeline) {
        Entity.withHref(uriInfo, ingestionPipeline.getOwner());
        Entity.withHref(uriInfo, ingestionPipeline.getService());
        return ingestionPipeline;
    }

    public IngestionPipelineResource(CollectionDAO dao, Authorizer authorizer) {
        super(IngestionPipeline.class, new IngestionPipelineRepository(dao), authorizer);
        this.metadataServiceRepository = new MetadataServiceRepository(dao);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        this.openMetadataApplicationConfig = config;
        this.pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(config.getPipelineServiceClientConfiguration());
        ((IngestionPipelineRepository)this.repository).setPipelineServiceClient(this.pipelineServiceClient);
        this.createIndexAndInsightPipeline(config);
    }

    private void createIndexAndInsightPipeline(OpenMetadataApplicationConfig config) {
        if (config.getElasticSearchConfiguration() != null) {
            try {
                EntityReference metadataService = ((MetadataService)this.metadataServiceRepository.getByName(null, "OpenMetadata", ((IngestionPipelineRepository)this.repository).getFields("id"))).getEntityReference();
                CreateIngestionPipeline createPipelineRequest = new CreateIngestionPipeline().withName(DEFAULT_INSIGHT_PIPELINE).withDisplayName(DEFAULT_INSIGHT_PIPELINE).withDescription("Data Insights Pipeline").withPipelineType(PipelineType.DATA_INSIGHT).withSourceConfig(new SourceConfig().withConfig((Object)new MetadataToElasticSearchPipeline().withType(MetadataToElasticSearchPipeline.MetadataToESConfigType.METADATA_TO_ELASTIC_SEARCH))).withAirflowConfig(IngestionPipelineUtils.getDefaultAirflowConfig()).withService(metadataService);
                IngestionPipeline dataInsightPipeline = this.getIngestionPipeline(createPipelineRequest, "system").withProvider(ProviderType.SYSTEM);
                ((IngestionPipelineRepository)this.repository).setFullyQualifiedName(dataInsightPipeline);
                ((IngestionPipelineRepository)this.repository).initializeEntity(dataInsightPipeline);
                createPipelineRequest.withName(DEFAULT_REINDEX_PIPELINE).withDisplayName(DEFAULT_REINDEX_PIPELINE).withDescription("Elastic Search Reindexing Pipeline").withPipelineType(PipelineType.ELASTIC_SEARCH_REINDEX);
                IngestionPipeline elasticSearchPipeline = this.getIngestionPipeline(createPipelineRequest, "system").withProvider(ProviderType.SYSTEM);
                ((IngestionPipelineRepository)this.repository).setFullyQualifiedName(elasticSearchPipeline);
                ((IngestionPipelineRepository)this.repository).initializeEntity(elasticSearchPipeline);
            }
            catch (Exception ex) {
                LOG.error("[IngestionPipelineResource] Failed in Creating Reindex and Insight Pipeline", (Throwable)ex);
            }
        }
    }

    @GET
    @Valid
    @Operation(operationId="listIngestionPipelines", summary="List ingestion pipelines for metadata operations", description="Get a list of airflow pipelines for metadata operations. Use `fields` parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of ingestion workflows", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public ResultList<IngestionPipeline> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter airflow pipelines by service fully qualified name", schema=@Schema(type="string", example="snowflakeWestCoast")) @QueryParam(value="service") String serviceParam, @Parameter(description="Filter airflow pipelines by pipeline Type", schema=@Schema(type="string", example="elasticSearchReindex")) @QueryParam(value="pipelineType") String pipelineType, @Parameter(description="Filter airflow pipelines by service Type", schema=@Schema(type="string", example="messagingService")) @QueryParam(value="serviceType") String serviceType, @Parameter(description="Limit the number ingestion returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of ingestion before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of ingestion after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("service", serviceParam).addQueryParam("pipelineType", pipelineType).addQueryParam("serviceType", serviceType);
        ResultList<IngestionPipeline> ingestionPipelines = super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        for (IngestionPipeline ingestionPipeline : CommonUtil.listOrEmpty(ingestionPipelines.getData())) {
            if (fieldsParam != null && fieldsParam.contains("pipelineStatus")) {
                ingestionPipeline.setPipelineStatuses(((IngestionPipelineRepository)this.repository).getLatestPipelineStatus(ingestionPipeline));
            }
            this.decryptOrNullify(securityContext, ingestionPipeline, false);
        }
        return ingestionPipelines;
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllIngestionPipelineVersion", summary="List ingestion workflow versions", description="Get a list of all the versions of a ingestion pipeline identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of IngestionPipeline versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getIngestionPipelineByID", summary="Get an ingestion pipeline by Id", description="Get an ingestion pipeline by `Id`.", responses={@ApiResponse(responseCode="200", description="The ingestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="404", description="IngestionPipeline for instance {id} is not found")})
    public IngestionPipeline get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        if (fieldsParam != null && fieldsParam.contains("pipelineStatus")) {
            ingestionPipeline.setPipelineStatuses(((IngestionPipelineRepository)this.repository).getLatestPipelineStatus(ingestionPipeline));
        }
        this.decryptOrNullify(securityContext, ingestionPipeline, false);
        return ingestionPipeline;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificIngestionPipelineVersion", summary="Get a version of the ingestion pipeline", description="Get a version of the ingestion pipeline by given `Id`", responses={@ApiResponse(responseCode="200", description="IngestionPipelines", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="404", description="IngestionPipeline for instance {id} and version  {version} is not found")})
    public IngestionPipeline getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Ingestion version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)super.getVersionInternal(securityContext, id, version);
        this.decryptOrNullify(securityContext, ingestionPipeline, false);
        return ingestionPipeline;
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getSpecificIngestionPipelineByFQN", summary="Get an ingestion pipeline by fully qualified name", description="Get an ingestion by fully qualified name.", responses={@ApiResponse(responseCode="200", description="IngestionPipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="404", description="Ingestion for instance {fqn} is not found")})
    public IngestionPipeline getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the ingestion pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
        if (fieldsParam != null && fieldsParam.contains("pipelineStatus")) {
            ingestionPipeline.setPipelineStatuses(((IngestionPipelineRepository)this.repository).getLatestPipelineStatus(ingestionPipeline));
        }
        this.decryptOrNullify(securityContext, ingestionPipeline, false);
        return ingestionPipeline;
    }

    @Override
    @POST
    @Operation(operationId="createIngestionPipeline", summary="Create an ingestion pipeline", description="Create a new ingestion pipeline.", responses={@ApiResponse(responseCode="200", description="The Ingestion Pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateIngestionPipeline create) throws IOException {
        IngestionPipeline ingestionPipeline = this.getIngestionPipeline(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, ingestionPipeline);
        IngestionPipelineRepository.validateProfileSample(ingestionPipeline);
        this.decryptOrNullify(securityContext, (IngestionPipeline)response.getEntity(), false);
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchIngestionPipeline", summary="Update an ingestion pipeline", description="Update an existing ingestion pipeline using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        Response response = this.patchInternal(uriInfo, securityContext, id, patch);
        this.decryptOrNullify(securityContext, (IngestionPipeline)response.getEntity(), false);
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateIngestionPipeline", summary="Create or update an ingestion pipeline", description="Create a new ingestion pipeline, if it does not exist or update an existing ingestion pipeline.", responses={@ApiResponse(responseCode="200", description="The IngestionPipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateIngestionPipeline update) throws IOException {
        IngestionPipeline ingestionPipeline = this.getIngestionPipeline(update, securityContext.getUserPrincipal().getName());
        this.unmask(ingestionPipeline);
        Response response = this.createOrUpdate(uriInfo, securityContext, ingestionPipeline);
        IngestionPipelineRepository.validateProfileSample(ingestionPipeline);
        this.decryptOrNullify(securityContext, (IngestionPipeline)response.getEntity(), false);
        return response;
    }

    @POST
    @Path(value="/deploy/{id}")
    @Operation(summary="Deploy an ingestion pipeline run", description="Trigger a ingestion pipeline run by Id.", responses={@ApiResponse(responseCode="200", description="The ingestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceClientResponse.class))}), @ApiResponse(responseCode="404", description="Ingestion for instance {id} is not found")})
    public PipelineServiceClientResponse deployIngestion(@Context UriInfo uriInfo, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext) throws IOException {
        return this.deployPipelineInternal(id, uriInfo, securityContext);
    }

    @POST
    @Path(value="/bulk/deploy")
    @Operation(summary="Bulk deploy a list of Ingestion Pipeline", description="Bulk deploy a list of Ingestion Pipelines given a list of IDs", responses={@ApiResponse(responseCode="200", description="List of Statuses of the deployed pipelines", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceClientResponse.class))})})
    public List<PipelineServiceClientResponse> bulkDeployIngestion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid List<UUID> pipelineIdList) {
        return pipelineIdList.stream().map(id -> {
            try {
                return this.deployPipelineInternal((UUID)id, uriInfo, securityContext);
            }
            catch (Exception e) {
                return new PipelineServiceClientResponse().withCode(Integer.valueOf(500)).withReason(String.format("Error deploying [%s] due to [%s]", id, e.getMessage())).withPlatform(this.pipelineServiceClient.getPlatform());
            }
        }).collect(Collectors.toList());
    }

    @POST
    @Path(value="/trigger/{id}")
    @Operation(operationId="triggerIngestionPipelineRun", summary="Trigger an ingestion pipeline run", description="Trigger a ingestion pipeline run by id.", responses={@ApiResponse(responseCode="200", description="The ingestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceClientResponse.class))}), @ApiResponse(responseCode="404", description="Ingestion for instance {id} is not found")})
    public PipelineServiceClientResponse triggerIngestion(@Context UriInfo uriInfo, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext) throws IOException {
        EntityUtil.Fields fields = this.getFields(FIELDS);
        IngestionPipeline ingestionPipeline = (IngestionPipeline)((IngestionPipelineRepository)this.repository).get(uriInfo, id, fields);
        ingestionPipeline.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build());
        this.decryptOrNullify(securityContext, ingestionPipeline, true);
        ServiceEntityInterface service = (ServiceEntityInterface)Entity.getEntity(ingestionPipeline.getService(), "", Include.NON_DELETED);
        return this.pipelineServiceClient.runPipeline(ingestionPipeline, service);
    }

    @POST
    @Path(value="/toggleIngestion/{id}")
    @Operation(operationId="toggleIngestionPipelineEnabled", summary="Set an ingestion pipeline either as enabled or disabled", description="Toggle an ingestion pipeline state by Id.", responses={@ApiResponse(responseCode="200", description="The ingestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))}), @ApiResponse(responseCode="404", description="Ingestion for instance {id} is not found")})
    public Response toggleIngestion(@Context UriInfo uriInfo, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext) throws IOException {
        EntityUtil.Fields fields = this.getFields(FIELDS);
        IngestionPipeline pipeline = (IngestionPipeline)((IngestionPipelineRepository)this.repository).get(uriInfo, id, fields);
        this.decryptOrNullify(securityContext, pipeline, true);
        this.pipelineServiceClient.toggleIngestion(pipeline);
        Response response = this.createOrUpdate(uriInfo, securityContext, pipeline);
        this.decryptOrNullify(securityContext, (IngestionPipeline)response.getEntity(), false);
        return response;
    }

    @POST
    @Path(value="/kill/{id}")
    @Operation(operationId="killIngestionPipelineRuns", summary="Mark as failed and kill any not-finished workflow or task for the ingestion pipeline", description="Kill an ingestion pipeline by Id.", responses={@ApiResponse(responseCode="200", description="The ingestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceClientResponse.class))}), @ApiResponse(responseCode="404", description="Ingestion for instance {id} is not found")})
    public PipelineServiceClientResponse killIngestion(@Context UriInfo uriInfo, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.getInternal(uriInfo, securityContext, id, FIELDS, Include.NON_DELETED);
        this.decryptOrNullify(securityContext, ingestionPipeline, true);
        return this.pipelineServiceClient.killIngestion(ingestionPipeline);
    }

    @GET
    @Path(value="/ip")
    @Operation(operationId="checkAirflowHostIp", summary="Check the airflow REST host IP", description="Check the Airflow REST host IP", responses={@ApiResponse(responseCode="200", description="Pipeline Service host IP", content={@Content(mediaType="application/json")})})
    public Response getHostIp(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.pipelineServiceClient.getHostIp();
    }

    @GET
    @Path(value="/status")
    @Operation(operationId="checkRestAirflowStatus", summary="Check the airflow REST status", description="Check that the Airflow REST endpoint is reachable and up and running", responses={@ApiResponse(responseCode="200", description="Status message", content={@Content(mediaType="application/json")})})
    public PipelineServiceClientResponse getRESTStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.pipelineServiceClient.getServiceStatus();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteIngestionPipeline", summary="Delete an ingestion pipeline by Id", description="Delete an ingestion pipeline by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Ingestion for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteIngestionPipelineByFQN", summary="Delete an ingestion pipeline by fully qualified name", description="Delete an ingestion pipeline by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Ingestion for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the ingestion pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted ingestion pipeline", description="Restore a soft deleted ingestion pipeline.", responses={@ApiResponse(responseCode="200", description="Successfully restored the IngestionPipeline. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public Response restoreIngestionPipeline(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/logs/{id}/last")
    @Operation(summary="Retrieve all logs from last ingestion pipeline run", description="Get all logs from last ingestion pipeline run by `Id`.", responses={@ApiResponse(responseCode="200", description="JSON object with the task instance name of the ingestion on each key and log in the value", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Logs for instance {id} is not found")})
    public Response getLastIngestionLogs(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ingestion pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Returns log chunk after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.getInternal(uriInfo, securityContext, id, FIELDS, Include.NON_DELETED);
        Map lastIngestionLogs = this.pipelineServiceClient.getLastIngestionLogs(ingestionPipeline, after);
        return Response.ok((Object)lastIngestionLogs, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @PUT
    @Path(value="/{fqn}/pipelineStatus")
    @Operation(operationId="addPipelineStatus", summary="Add pipeline status", description="Add pipeline status of ingestion pipeline.", responses={@ApiResponse(responseCode="200", description="Successfully updated the PipelineStatus. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public Response addPipelineStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the ingestion pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Valid PipelineStatus pipelineStatus) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        return ((IngestionPipelineRepository)this.repository).addPipelineStatus(uriInfo, fqn, pipelineStatus).toResponse();
    }

    @GET
    @Path(value="/{fqn}/pipelineStatus")
    @Operation(operationId="listPipelineStatuses", summary="List of pipeline status", description="Get a list of all the pipeline status for the given ingestion pipeline id, optionally filtered by  `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of pipeline status", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public ResultList<PipelineStatus> listPipelineStatuses(@Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the ingestion pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter pipeline status after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter pipeline status before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs) throws IOException {
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        return ((IngestionPipelineRepository)this.repository).listPipelineStatus(fqn, startTs, endTs);
    }

    @GET
    @Path(value="/{fqn}/pipelineStatus/{id}")
    @Operation(operationId="getPipelineStatus", summary="Get pipeline status", description="Get pipeline status of ingestion pipeline", responses={@ApiResponse(responseCode="200", description="Successfully updated state of the PipelineStatus.", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public PipelineStatus getPipelineStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the ingestion pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Id of pipeline status run", schema=@Schema(type="string")) @PathParam(value="id") UUID runId) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        return ((IngestionPipelineRepository)this.repository).getPipelineStatus(fqn, runId);
    }

    @DELETE
    @Path(value="/{id}/pipelineStatus")
    @Operation(operationId="deletePipelineStatus", summary="Delete Pipeline Status", tags={"ingestionPipelines"}, description="Delete the Pipeline Status for this Ingestion Pipeline.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the Statuses", content={@Content(mediaType="application/json", schema=@Schema(implementation=IngestionPipeline.class))})})
    public IngestionPipeline deletePipelineStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Ingestion Pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        IngestionPipeline ingestionPipeline = ((IngestionPipelineRepository)this.repository).deletePipelineStatus(id);
        return this.addHref(uriInfo, ingestionPipeline);
    }

    private IngestionPipeline getIngestionPipeline(CreateIngestionPipeline create, String user) throws IOException {
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build();
        return this.copy(new IngestionPipeline(), (CreateEntity)create, user).withPipelineType(create.getPipelineType()).withAirflowConfig(create.getAirflowConfig()).withOpenMetadataServerConnection(openMetadataServerConnection).withSourceConfig(create.getSourceConfig()).withLoggerLevel(create.getLoggerLevel()).withService(create.getService());
    }

    private void unmask(IngestionPipeline ingestionPipeline) {
        ((IngestionPipelineRepository)this.repository).setFullyQualifiedName(ingestionPipeline);
        IngestionPipeline originalIngestionPipeline = (IngestionPipeline)((IngestionPipelineRepository)this.repository).findByNameOrNull(ingestionPipeline.getFullyQualifiedName(), null, Include.NON_DELETED);
        EntityMaskerFactory.getEntityMasker().unmaskIngestionPipeline(ingestionPipeline, originalIngestionPipeline);
    }

    private PipelineServiceClientResponse deployPipelineInternal(UUID id, UriInfo uriInfo, SecurityContext securityContext) throws IOException {
        EntityUtil.Fields fields = this.getFields(FIELDS);
        IngestionPipeline ingestionPipeline = (IngestionPipeline)((IngestionPipelineRepository)this.repository).get(uriInfo, id, fields);
        ingestionPipeline.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build());
        this.decryptOrNullify(securityContext, ingestionPipeline, true);
        ServiceEntityInterface service = (ServiceEntityInterface)Entity.getEntity(ingestionPipeline.getService(), "", Include.NON_DELETED);
        PipelineServiceClientResponse status = this.pipelineServiceClient.deployPipeline(ingestionPipeline, service);
        if (status.getCode() == 200) {
            this.createOrUpdate(uriInfo, securityContext, ingestionPipeline);
        }
        return status;
    }

    private void decryptOrNullify(SecurityContext securityContext, IngestionPipeline ingestionPipeline, boolean forceNotMask) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        try {
            this.authorizer.authorize(securityContext, new OperationContext(this.entityType, MetadataOperation.VIEW_ALL), this.getResourceContextById(ingestionPipeline.getId()));
        }
        catch (IOException | AuthorizationException e) {
            ingestionPipeline.getSourceConfig().setConfig(null);
        }
        secretsManager.decryptIngestionPipeline(ingestionPipeline);
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build();
        ingestionPipeline.setOpenMetadataServerConnection(secretsManager.encryptOpenMetadataConnection(openMetadataServerConnection, false));
        if (this.authorizer.shouldMaskPasswords(securityContext) && !forceNotMask) {
            EntityMaskerFactory.getEntityMasker().maskIngestionPipeline(ingestionPipeline);
        }
    }

    public static class IngestionPipelineList
    extends ResultList<IngestionPipeline> {
    }
}

