/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.Response;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.schema.system.Failure;
import org.openmetadata.schema.system.FailureDetails;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.elasticsearch.ElasticSearchRequest;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.JsonUtils;
import org.opensearch.client.RequestOptions;

public interface SearchClient {
    public boolean createIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType var1, String var2);

    public void updateIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType var1, String var2);

    public void deleteIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType var1);

    public Response search(ElasticSearchRequest var1) throws IOException;

    public Response aggregate(String var1, String var2, String var3, String var4) throws IOException;

    public Response suggest(ElasticSearchRequest var1) throws IOException;

    public ElasticSearchConfiguration.SearchType getSearchType();

    default public org.opensearch.action.update.UpdateRequest applyOSChangeEvent(ChangeEvent event) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public UpdateRequest applyESChangeEvent(ChangeEvent event) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateElasticSearch(org.opensearch.action.update.UpdateRequest updateRequest) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateElasticSearch(UpdateRequest updateRequest) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateSearchForEntityCreated(ElasticSearchIndexDefinition.ElasticSearchIndexType indexType, String entityType, ChangeEvent event) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateSearchForEntityUpdated(ElasticSearchIndexDefinition.ElasticSearchIndexType indexType, String entityType, ChangeEvent event) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateESSearch(org.opensearch.action.update.UpdateRequest updateRequest) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void updateOSElasticSearch(UpdateRequest updateRequest) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    public void updateEntity(ChangeEvent var1) throws IOException;

    public void updateUser(ChangeEvent var1) throws IOException;

    public void updateTeam(ChangeEvent var1) throws IOException;

    public void updateGlossaryTerm(ChangeEvent var1) throws IOException;

    public void updateGlossary(ChangeEvent var1) throws IOException;

    public void updateTag(ChangeEvent var1) throws IOException;

    public void updateDatabase(ChangeEvent var1) throws IOException;

    public void updateDatabaseSchema(ChangeEvent var1) throws IOException;

    public void updateDatabaseService(ChangeEvent var1) throws IOException;

    public void updatePipelineService(ChangeEvent var1) throws IOException;

    public void updateMlModelService(ChangeEvent var1) throws IOException;

    public void updateStorageService(ChangeEvent var1) throws IOException;

    public void updateMessagingService(ChangeEvent var1) throws IOException;

    public void updateDashboardService(ChangeEvent var1) throws IOException;

    public void updateClassification(ChangeEvent var1) throws IOException;

    default public void updateTestCase(ChangeEvent event) throws IOException {
        ElasticSearchIndexDefinition.ElasticSearchIndexType indexType = ElasticSearchIndexDefinition.getIndexMappingByEntityType("testCase");
        EntityInterface entityInterface = (EntityInterface)event.getEntity();
        if (entityInterface instanceof TestCase) {
            this.processTestCase((TestCase)entityInterface, event, indexType);
        } else {
            this.addTestCaseFromLogicalTestSuite((TestSuite)entityInterface, event, indexType);
        }
    }

    public void updateTestSuite(ChangeEvent var1) throws IOException;

    public void processTestCase(TestCase var1, ChangeEvent var2, ElasticSearchIndexDefinition.ElasticSearchIndexType var3) throws IOException;

    public void addTestCaseFromLogicalTestSuite(TestSuite var1, ChangeEvent var2, ElasticSearchIndexDefinition.ElasticSearchIndexType var3) throws IOException;

    public void close();

    default public org.opensearch.action.bulk.BulkResponse bulk(org.opensearch.action.bulk.BulkRequest data, RequestOptions options) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public BulkResponse bulk(BulkRequest data, org.elasticsearch.client.RequestOptions options) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public int getSuccessFromBulkResponse(org.opensearch.action.bulk.BulkResponse response) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public int getSuccessFromBulkResponse(BulkResponse response) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    public TreeMap<Long, List<Object>> getSortedDate(String var1, Long var2, Long var3, DataInsightChartResult.DataInsightChartType var4, String var5) throws IOException, ParseException;

    public Response listDataInsightChartResult(Long var1, Long var2, String var3, String var4, DataInsightChartResult.DataInsightChartType var5, String var6) throws IOException, ParseException;

    default public void getScriptWithParams(ChangeEvent event, String script, Map<String, Object> fieldParams) {
        List entityReferences;
        ChangeDescription changeDescription = event.getChangeDescription();
        List fieldsAdded = changeDescription.getFieldsAdded();
        StringBuilder scriptTxt = new StringBuilder();
        HashMap<String, Object> fieldAddParams = new HashMap<String, Object>();
        fieldAddParams.put("updatedAt", event.getTimestamp());
        scriptTxt.append("ctx._source.updatedAt=params.updatedAt;");
        for (FieldChange fieldChange : fieldsAdded) {
            if (!fieldChange.getName().equalsIgnoreCase("followers")) continue;
            entityReferences = (List)fieldChange.getNewValue();
            ArrayList<String> newFollowers = new ArrayList<String>();
            for (EntityReference follower : entityReferences) {
                newFollowers.add(follower.getId().toString());
            }
            fieldAddParams.put(fieldChange.getName(), newFollowers);
            scriptTxt.append("ctx._source.followers.addAll(params.followers);");
        }
        for (FieldChange fieldChange : changeDescription.getFieldsDeleted()) {
            if (!fieldChange.getName().equalsIgnoreCase("followers")) continue;
            entityReferences = (List)fieldChange.getOldValue();
            for (EntityReference follower : entityReferences) {
                fieldAddParams.put(fieldChange.getName(), follower.getId().toString());
            }
            scriptTxt.append("ctx._source.followers.removeAll(Collections.singleton(params.followers));");
        }
        for (FieldChange fieldChange : changeDescription.getFieldsUpdated()) {
            if (fieldChange.getName().equalsIgnoreCase("usageSummary")) {
                UsageDetails usageSummary = (UsageDetails)fieldChange.getNewValue();
                fieldAddParams.put(fieldChange.getName(), JsonUtils.getMap(usageSummary));
                scriptTxt.append("ctx._source.usageSummary = params.usageSummary;");
            }
            if (event.getEntityType().equals("query") && fieldChange.getName().equalsIgnoreCase("queryUsedIn")) {
                fieldAddParams.put(fieldChange.getName(), JsonUtils.convertValue(fieldChange.getNewValue(), new TypeReference<List<LinkedHashMap<String, String>>>(){}));
                scriptTxt.append("ctx._source.queryUsedIn = params.queryUsedIn;");
            }
            if (!fieldChange.getName().equalsIgnoreCase("votes")) continue;
            Map<String, Object> doc = JsonUtils.getMap(event.getEntity());
            fieldAddParams.put(fieldChange.getName(), doc.get("votes"));
            scriptTxt.append("ctx._source.votes = params.votes;");
        }
        script = scriptTxt.toString();
        fieldParams = fieldAddParams;
    }

    default public String getIndexMapping(ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, String lang) throws IOException {
        InputStream in = ElasticSearchIndexDefinition.class.getResourceAsStream(String.format(elasticSearchIndexType.indexMappingFile, lang.toLowerCase()));
        if (!2.$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        return new String(in.readAllBytes());
    }

    public CollectionDAO getDao();

    default public void updateElasticSearchFailureStatus(String failedFor, String failureMessage) {
        try {
            long updateTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()).getTime();
            String recordString = this.getDao().entityExtensionTimeSeriesDao().getExtension("eventPublisher:ElasticSearch:STREAM", "service.eventPublisher");
            EventPublisherJob lastRecord = JsonUtils.readValue(recordString, EventPublisherJob.class);
            long originalLastUpdate = lastRecord.getTimestamp();
            lastRecord.setStatus(EventPublisherJob.Status.ACTIVE_WITH_ERROR);
            lastRecord.setTimestamp(Long.valueOf(updateTime));
            lastRecord.setFailure(new Failure().withSinkError(new FailureDetails().withContext(failedFor).withLastFailedAt(Long.valueOf(updateTime)).withLastFailedReason(failureMessage)));
            this.getDao().entityExtensionTimeSeriesDao().update("eventPublisher:ElasticSearch:STREAM", "service.eventPublisher", JsonUtils.pojoToJson(lastRecord), originalLastUpdate);
        }
        catch (Exception updateTime) {}
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

