/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.openSearch;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.DataInsightInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexFactory;
import org.openmetadata.service.elasticsearch.ElasticSearchRequest;
import org.openmetadata.service.elasticsearch.TestCaseIndex;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.indexes.GlossaryTermIndex;
import org.openmetadata.service.elasticsearch.indexes.TagIndex;
import org.openmetadata.service.elasticsearch.indexes.TeamIndex;
import org.openmetadata.service.elasticsearch.indexes.UserIndex;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.search.EntityBuilderConstant;
import org.openmetadata.service.search.IndexUtil;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.openSearch.OsDailyActiveUsersAggregator;
import org.openmetadata.service.search.openSearch.OsEntitiesDescriptionAggregator;
import org.openmetadata.service.search.openSearch.OsEntitiesOwnerAggregator;
import org.openmetadata.service.search.openSearch.OsMostActiveUsersAggregator;
import org.openmetadata.service.search.openSearch.OsMostViewedEntitiesAggregator;
import org.openmetadata.service.search.openSearch.OsPageViewsByEntitiesAggregator;
import org.openmetadata.service.search.openSearch.OsTotalEntitiesAggregator;
import org.openmetadata.service.search.openSearch.OsTotalEntitiesByTierAggregator;
import org.openmetadata.service.util.JsonUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.common.lucene.search.function.CombineFunction;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchModule;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.SuggestBuilder;
import org.opensearch.search.suggest.SuggestBuilders;
import org.opensearch.search.suggest.SuggestionBuilder;
import org.opensearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.opensearch.search.suggest.completion.context.CategoryQueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchClientImpl
implements SearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClientImpl.class);
    private final RestHighLevelClient client;
    private final CollectionDAO dao;
    private EnumMap<ElasticSearchIndexDefinition.ElasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus> elasticSearchIndexes = new EnumMap(ElasticSearchIndexDefinition.ElasticSearchIndexType.class);
    private static NamedXContentRegistry xContentRegistry;

    public OpenSearchClientImpl(ElasticSearchConfiguration esConfig, CollectionDAO dao) {
        this.client = OpenSearchClientImpl.createOpenSearchClient(esConfig);
        this.dao = dao;
    }

    @Override
    public boolean createIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, String lang) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            String elasticSearchIndexMapping = this.getIndexMapping(elasticSearchIndexType, lang);
            ElasticSearchIndexDefinition.ENTITY_TO_MAPPING_SCHEMA_MAP.put(elasticSearchIndexType.entityType, JsonUtils.getMap(JsonUtils.readJson(elasticSearchIndexMapping)));
            if (!exists) {
                CreateIndexRequest request = new CreateIndexRequest(elasticSearchIndexType.indexName);
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.info("{} Created {}", (Object)elasticSearchIndexType.indexName, (Object)createIndexResponse.isAcknowledged());
            }
            this.elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.CREATED);
        }
        catch (Exception e) {
            this.elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.FAILED);
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Creating Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to create Elastic Search indexes due to", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void updateIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, String lang) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            String elasticSearchIndexMapping = this.getIndexMapping(elasticSearchIndexType, lang);
            ElasticSearchIndexDefinition.ENTITY_TO_MAPPING_SCHEMA_MAP.put(elasticSearchIndexType.entityType, JsonUtils.getMap(JsonUtils.readJson(elasticSearchIndexMapping)));
            if (exists) {
                PutMappingRequest request = new PutMappingRequest(new String[]{elasticSearchIndexType.indexName});
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                AcknowledgedResponse putMappingResponse = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
                LOG.info("{} Updated {}", (Object)elasticSearchIndexType.indexName, (Object)putMappingResponse.isAcknowledged());
            } else {
                CreateIndexRequest request = new CreateIndexRequest(elasticSearchIndexType.indexName);
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.info("{} Created {}", (Object)elasticSearchIndexType.indexName, (Object)createIndexResponse.isAcknowledged());
            }
            this.elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.CREATED);
        }
        catch (Exception e) {
            this.elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.FAILED);
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Updating Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to update Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public void deleteIndex(ElasticSearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            if (exists) {
                DeleteIndexRequest request = new DeleteIndexRequest(elasticSearchIndexType.indexName);
                AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
                LOG.info("{} Deleted {}", (Object)elasticSearchIndexType.indexName, (Object)deleteIndexResponse.isAcknowledged());
            }
        }
        catch (IOException e) {
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Deleting Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to delete Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public Response search(ElasticSearchRequest request) throws IOException {
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder;
        switch (request.getIndex()) {
            case "topic_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildTopicSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "dashboard_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildDashboardSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "pipeline_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildPipelineSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "mlmodel_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildMlModelSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "table_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildTableSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "user_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildUserOrTeamSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "team_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildUserOrTeamSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "glossary_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildGlossaryTermSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "tag_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildTagSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "container_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildContainerSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "query_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildQuerySearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "test_case_search_index": {
                searchSourceBuilder = OpenSearchClientImpl.buildTestCaseSearch(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            default: {
                searchSourceBuilder = OpenSearchClientImpl.buildAggregateSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getQueryFilter()) && !request.getQueryFilter().equals("{}")) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getQueryFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getPostFilter())) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getPostFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.deleted())));
        if (!CommonUtil.nullOrEmpty((String)request.getSortFieldParam())) {
            searchSourceBuilder.sort(request.getSortFieldParam(), SortOrder.fromString((String)request.getSortOrder()));
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        if (request.trackTotalHits()) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(EntityBuilderConstant.MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(filter);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()).includeExclude(new IncludeExclude(value, null)).order(BucketOrder.key((boolean)true))).query((QueryBuilder)boolQueryBuilder).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public void updateElasticSearch(UpdateRequest updateRequest) throws IOException {
        if (updateRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public Response suggest(ElasticSearchRequest request) throws IOException {
        String fieldName = request.getFieldName();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(request.getQuery(), Fuzziness.AUTO).size(request.getSize())).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(String.valueOf(request.deleted())).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        SearchRequest searchRequest = new SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private static SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("tasks.name", 2.0f).field("tasks.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("tasks.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("tasks.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tasks.displayName.keyword").field("tasks.displayName.keyword"));
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("mlFeatures.name", 2.0f).field("mlFeatures.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("mlFeatures.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("mlFeatures.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("messageSchema.schemaFields.name", 2.0f).field("messageSchema.schemaFields.description", 1.0f).field("messageSchema.schemaFields.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTopicName = new HighlightBuilder.Field("displayName");
        highlightTopicName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTopicName);
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.description").highlighterType("unified"));
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.children.name").highlighterType("unified"));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name").field("messageSchema.schemaFields.name"));
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("charts.name", 2.0f).field("charts.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDashboardName = new HighlightBuilder.Field("displayName");
        highlightDashboardName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightCharts = new HighlightBuilder.Field("charts.name");
        highlightCharts.highlighterType("unified");
        HighlightBuilder.Field highlightChartDescriptions = new HighlightBuilder.Field("charts.description");
        highlightChartDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightDashboardName);
        hb.field(highlightCharts);
        hb.field(highlightChartDescriptions);
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModels.displayName.keyword").field("dataModels.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"charts.displayName.keyword").field("charts.displayName.keyword"));
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("description.ngram", 1.0f).field("columns.name.keyword", 10.0f).field("columns.name", 2.0f).field("columns.name.ngram").field("columns.displayName", 2.0f).field("columns.displayName.ngram").field("columns.description", 1.0f).field("columns.children.name", 2.0f).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        FieldValueFactorFunctionBuilder boostScoreBuilder = ScoreFunctionBuilders.fieldValueFactorFunction((String)"usageSummary.weeklyStats.count").missing(0.0).factor(0.2f);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] functions = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((ScoreFunctionBuilder)boostScoreBuilder)};
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functions);
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder.Field highlightTableName = new HighlightBuilder.Field("displayName");
        highlightTableName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightTableName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.name.keyword").field("database.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.name.keyword").field("databaseSchema.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword"));
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildUserOrTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 3.0f).field("displayName.keyword", 5.0f).field("displayName.ngram").field("name", 2.0f).field("name.keyword", 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        return OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 10.0f).field("displayName.ngram", 1.0f).field("name", 10.0f).field("name.keyword", 10.0f).field("displayName.keyword", 10.0f).field("displayName", 10.0f).field("displayName.ngram").field("synonyms", 5.0f).field("synonyms.ngram").field("description", 3.0f).field("glossary.name", 5.0f).field("glossary.displayName", 5.0f).field("glossary.displayName.ngram").defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("name");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightGlossaryDisplayName = new HighlightBuilder.Field("displayName");
        highlightGlossaryDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightSynonym = new HighlightBuilder.Field("synonyms");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightGlossaryDisplayName);
        hb.field(highlightSynonym);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"glossary.name.keyword").field("glossary.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"owner.name.keyword").field("owner.name.keyword"));
        return searchSourceBuilder;
    }

    private static SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("name", 10.0f).field("displayName", 10.0f).field("displayName.ngram", 1.0f).field("description", 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTagName = new HighlightBuilder.Field("name");
        highlightTagName.highlighterType("unified");
        HighlightBuilder.Field highlightTagDisplayName = new HighlightBuilder.Field("displayName");
        highlightTagDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTagDisplayName);
        hb.field(highlightDescription);
        hb.field(highlightTagName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"classification.name.keyword").field("classification.name.keyword"));
    }

    private static SearchSourceBuilder buildContainerSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description", 1.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("dataModel.columns.name", 2.0f).field("dataModel.columns.name.keyword", 10.0f).field("dataModel.columns.name.ngram").field("dataModel.columns.displayName", 2.0f).field("dataModel.columns.displayName.ngram").field("dataModel.columns.description", 1.0f).field("dataModel.columns.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightContainerName = new HighlightBuilder.Field("displayName");
        highlightContainerName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("dataModel.columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("dataModel.columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("dataModel.columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightContainerName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModel.columns.name.keyword").field("dataModel.columns.name.keyword"));
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildQuerySearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 10.0f).field("displayName.ngram").field("query", 10.0f).field("query.ngram").field("description", 1.0f).field("description.ngram", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("displayName");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightQuery = new HighlightBuilder.Field("query");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightQuery);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildTestCaseSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("name", 10.0f).field("description", 3.0f).field("testSuite.fullyQualifiedName", 10.0f).field("testSuite.name", 10.0f).field("testSuite.description", 3.0f).field("entityLink", 3.0f).field("entityFQN", 10.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTestCaseDescription = new HighlightBuilder.Field("description");
        highlightTestCaseDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTestCaseName = new HighlightBuilder.Field("name");
        highlightTestCaseName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteName = new HighlightBuilder.Field("testSuite.name");
        highlightTestSuiteName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteDescription = new HighlightBuilder.Field("testSuite.description");
        highlightTestSuiteDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTestCaseDescription);
        hb.field(highlightTestCaseName);
        hb.field(highlightTestSuiteName);
        hb.field(highlightTestSuiteDescription);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).lenient(Boolean.valueOf(true));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return OpenSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.name.keyword").field("service.name.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("entityType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"owner.displayName.keyword").field("owner.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN"));
        return builder;
    }

    private static SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    @Override
    public ElasticSearchConfiguration.SearchType getSearchType() {
        return ElasticSearchConfiguration.SearchType.OPENSEARCH;
    }

    @Override
    public void updateEntity(ChangeEvent event) throws IOException {
        String entityType = event.getEntityType();
        ElasticSearchIndexDefinition.ElasticSearchIndexType indexType = ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                ElasticSearchIndex index = ElasticSearchIndexFactory.buildIndex(entityType, event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(index.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                if (Objects.equals(event.getCurrentVersion(), event.getPreviousVersion())) {
                    updateRequest = this.applyOSChangeEvent(event);
                } else {
                    ElasticSearchIndex index = ElasticSearchIndexFactory.buildIndex(entityType, event.getEntity());
                    this.scriptedUpsert(index.buildESDoc(), updateRequest);
                }
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(indexType.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateUser(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                UserIndex userIndex = new UserIndex((User)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(userIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                UserIndex userIndex = new UserIndex((User)event.getEntity());
                this.scriptedUserUpsert(userIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateSearchForEntityCreated(ElasticSearchIndexDefinition.ElasticSearchIndexType indexType, String entityType, ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, event.getEntityId().toString());
        ElasticSearchIndex index = ElasticSearchIndexFactory.buildIndex(entityType, event.getEntity());
        updateRequest.doc(JsonUtils.pojoToJson(index.buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        this.updateElasticSearch(updateRequest);
    }

    @Override
    public void updateTeam(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.TEAM_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TeamIndex teamIndex = new TeamIndex((Team)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(teamIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                TeamIndex teamIndex = new TeamIndex((Team)event.getEntity());
                this.scriptedTeamUpsert(teamIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.TEAM_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateGlossaryTerm(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                GlossaryTermIndex glossaryTermIndex = new GlossaryTermIndex((GlossaryTerm)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(glossaryTermIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                GlossaryTermIndex glossaryTermIndex = new GlossaryTermIndex((GlossaryTerm)event.getEntity());
                this.scriptedUpsert(glossaryTermIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName});
                new DeleteRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, event.getEntityId().toString());
                GlossaryTerm glossaryTerm = (GlossaryTerm)event.getEntity();
                request.setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"id", (Object)glossaryTerm.getId().toString())).should((QueryBuilder)QueryBuilders.matchQuery((String)"parent.id", (Object)glossaryTerm.getId().toString())));
                this.deleteEntityFromElasticSearchByQuery(request);
            }
        }
    }

    @Override
    public void updateGlossary(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            Glossary glossary = (Glossary)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"glossary.id", (Object)glossary.getId().toString())));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateTag(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TagIndex tagIndex = new TagIndex((Tag)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(tagIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                if (Objects.equals(event.getCurrentVersion(), event.getPreviousVersion())) {
                    updateRequest = this.applyOSChangeEvent(event);
                } else {
                    TagIndex tagIndex = new TagIndex((Tag)event.getEntity());
                    this.scriptedUpsert(tagIndex.buildESDoc(), updateRequest);
                }
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                int totalHits;
                SearchResponse response;
                DeleteRequest deleteRequest = new DeleteRequest(ElasticSearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
                String[] indexes = new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX.indexName, ElasticSearchIndexDefinition.ElasticSearchIndexType.TOPIC_SEARCH_INDEX.indexName, ElasticSearchIndexDefinition.ElasticSearchIndexType.DASHBOARD_SEARCH_INDEX.indexName, ElasticSearchIndexDefinition.ElasticSearchIndexType.PIPELINE_SEARCH_INDEX.indexName, ElasticSearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, ElasticSearchIndexDefinition.ElasticSearchIndexType.MLMODEL_SEARCH_INDEX.indexName};
                BulkRequest request = new BulkRequest();
                int batchSize = 50;
                int currentHits = 0;
                do {
                    SearchRequest searchRequest = this.searchRequest(indexes, "tags.tagFQN", event.getEntityFullyQualifiedName(), batchSize, currentHits);
                    response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                    totalHits = (int)response.getHits().getTotalHits().value;
                    for (SearchHit hit : response.getHits()) {
                        Map sourceAsMap = hit.getSourceAsMap();
                        List listTags = (List)sourceAsMap.get("tags");
                        Script script = this.generateTagScript(listTags);
                        if (script.toString().isEmpty()) continue;
                        request.add(this.updateRequests(sourceAsMap.get("entityType").toString(), sourceAsMap.get("id").toString(), script));
                    }
                } while ((currentHits += response.getHits().getHits().length) < totalHits);
                if (request.numberOfActions() <= 0) break;
                this.client.bulk(request, RequestOptions.DEFAULT);
            }
        }
    }

    @Override
    public void updateDatabase(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            Database database = (Database)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX.indexName});
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("database.name", database.getName()));
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("service.name", database.getService().getName()));
            request.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateDatabaseSchema(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DatabaseSchema databaseSchema = (DatabaseSchema)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX.indexName});
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("databaseSchema.name", databaseSchema.getName()));
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("database.name", databaseSchema.getDatabase().getName()));
            request.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateDatabaseService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DatabaseService databaseService = (DatabaseService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", databaseService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updatePipelineService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            PipelineService pipelineService = (PipelineService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.PIPELINE_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", pipelineService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateMlModelService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            MlModelService mlModelService = (MlModelService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.MLMODEL_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", mlModelService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateStorageService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            StorageService storageService = (StorageService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.CONTAINER_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", storageService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateMessagingService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            MessagingService messagingService = (MessagingService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TOPIC_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", messagingService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateDashboardService(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DashboardService dashboardService = (DashboardService)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.DASHBOARD_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.name", dashboardService.getName()));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateClassification(ChangeEvent event) throws IOException {
        Classification classification = (Classification)event.getEntity();
        String indexName = ElasticSearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName;
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ElasticSearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName});
            String fqnMatch = classification.getName() + ".*";
            request.setQuery((QueryBuilder)new WildcardQueryBuilder("fullyQualifiedName", fqnMatch));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_UPDATED) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("tag.classification.id", (Object)classification.getId().toString()));
            String scriptTxt = "ctx._source.disabled=true";
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    @Override
    public void updateTestSuite(ChangeEvent event) throws IOException {
        ElasticSearchIndexDefinition.ElasticSearchIndexType indexType = ElasticSearchIndexDefinition.getIndexMappingByEntityType("testCase");
        TestSuite testSuite = (TestSuite)event.getEntity();
        UUID testSuiteId = testSuite.getId();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            if (Boolean.TRUE.equals(testSuite.getExecutable())) {
                DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexType.indexName});
                deleteByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("testSuites.id", (Object)testSuiteId.toString()));
                this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
            } else {
                UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexType.indexName});
                updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("testSuites.id", (Object)testSuiteId.toString()));
                String scriptTxt = "for (int i = 0; i < ctx._source.testSuites.length; i++) { if (ctx._source.testSuites[i].id == '%s') { ctx._source.testSuites.remove(i) }}";
                Script script = new Script(ScriptType.INLINE, "painless", String.format(scriptTxt, testSuiteId), new HashMap());
                updateByQueryRequest.setScript(script);
                this.updateElasticSearchByQuery(updateByQueryRequest);
            }
        }
    }

    private void updateElasticSearchByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        if (updateByQueryRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateByQueryRequest);
            this.client.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void processTestCase(TestCase testCase, ChangeEvent event, ElasticSearchIndexDefinition.ElasticSearchIndexType indexType) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, testCase.getId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TestCaseIndex testCaseIndex = new TestCaseIndex((TestCase)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(testCaseIndex.buildESDocForCreate()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                TestCaseIndex testCaseIndex = new TestCaseIndex((TestCase)event.getEntity());
                this.scriptedUpsert(testCaseIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteEntity(updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                EntityReference testSuiteReference = ((TestCase)event.getEntity()).getTestSuite();
                TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", testSuiteReference.getId(), "", Include.ALL);
                if (Boolean.TRUE.equals(testSuite.getExecutable())) {
                    DeleteRequest deleteRequest = new DeleteRequest(indexType.indexName, event.getEntityId().toString());
                    this.deleteEntityFromElasticSearch(deleteRequest);
                    break;
                }
                this.scriptedDeleteTestCase(updateRequest, testSuite.getId());
                this.updateElasticSearch(updateRequest);
            }
        }
    }

    private void scriptedDeleteTestCase(UpdateRequest updateRequest, UUID testSuiteId) {
        String scriptTxt = "for (int i = 0; i < ctx._source.testSuite.length; i++) { if (ctx._source.testSuite[i].id == '%s') { ctx._source.testSuite.remove(i) }}";
        scriptTxt = String.format(scriptTxt, testSuiteId);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
        updateRequest.script(script);
    }

    @Override
    public void addTestCaseFromLogicalTestSuite(TestSuite testSuite, ChangeEvent event, ElasticSearchIndexDefinition.ElasticSearchIndexType indexType) throws IOException {
        List testCaseReferences = testSuite.getTests();
        TestSuite testSuiteReference = new TestSuite().withId(testSuite.getId()).withName(testSuite.getName()).withDisplayName(testSuite.getDisplayName()).withDescription(testSuite.getDescription()).withFullyQualifiedName(testSuite.getFullyQualifiedName()).withDeleted(testSuite.getDeleted()).withHref(testSuite.getHref()).withExecutable(testSuite.getExecutable());
        Map<String, Object> testSuiteDoc = JsonUtils.getMap(testSuiteReference);
        if (event.getEventType() == EventType.ENTITY_UPDATED) {
            for (EntityReference testcaseReference : testCaseReferences) {
                UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, testcaseReference.getId().toString());
                String scripText = "ctx._source.testSuites.add(params)";
                Script script = new Script(ScriptType.INLINE, "painless", scripText, testSuiteDoc);
                updateRequest.script(script);
                this.updateElasticSearch(updateRequest);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close open search", (Throwable)e);
        }
    }

    private void scriptedUpsert(Object doc, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, JsonUtils.getMap(doc));
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    private void scriptedUserUpsert(Object index, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) {ctx._source.put(k, params.get(k)) }";
        Map<String, Object> doc = JsonUtils.getMap(index);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, doc);
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
    }

    private void scriptedTeamUpsert(Object index, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
        Map<String, Object> doc = JsonUtils.getMap(index);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, doc);
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
    }

    private void softDeleteEntity(UpdateRequest updateRequest) {
        String scriptTxt = "ctx._source.deleted=true";
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
        updateRequest.script(script);
    }

    private void deleteEntityFromElasticSearch(DeleteRequest deleteRequest) throws IOException {
        if (deleteRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    private void deleteEntityFromElasticSearchByQuery(DeleteByQueryRequest deleteRequest) throws IOException {
        if (deleteRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefresh(true);
            this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public UpdateRequest applyOSChangeEvent(ChangeEvent event) {
        String entityType = event.getEntityType();
        ElasticSearchIndexDefinition.ElasticSearchIndexType esIndexType = ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType);
        UUID entityId = event.getEntityId();
        String scriptTxt = "";
        HashMap<String, Object> fieldParams = new HashMap<String, Object>();
        this.getScriptWithParams(event, scriptTxt, fieldParams);
        if (!CommonUtil.nullOrEmpty((String)scriptTxt)) {
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, fieldParams);
            UpdateRequest updateRequest = new UpdateRequest(esIndexType.indexName, entityId.toString());
            updateRequest.script(script);
            return updateRequest;
        }
        return null;
    }

    private SearchRequest searchRequest(String[] indexes, String field, String value, int batchSize, int from) {
        SearchRequest searchRequest = new SearchRequest(indexes);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)value));
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(batchSize);
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private Script generateTagScript(List<TagLabel> listTags) {
        StringBuilder scriptTxt = new StringBuilder();
        HashMap<String, List<TagLabel>> fieldRemoveParams = new HashMap<String, List<TagLabel>>();
        fieldRemoveParams.put("tags", listTags);
        scriptTxt.append("ctx._source.tags=params.tags;");
        scriptTxt.append("ctx._source.tags.removeAll(params.tags);");
        fieldRemoveParams.put("tags", listTags);
        return new Script(ScriptType.INLINE, "painless", scriptTxt.toString(), fieldRemoveParams);
    }

    private UpdateRequest updateRequests(String entityType, String entityId, Script script) {
        return new UpdateRequest(IndexUtil.ENTITY_TYPE_TO_INDEX_MAP.get(entityType), entityId).script(script);
    }

    @Override
    public BulkResponse bulk(BulkRequest data, RequestOptions options) throws IOException {
        return this.client.bulk(data, RequestOptions.DEFAULT);
    }

    @Override
    public int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    @Override
    public TreeMap<Long, List<Object>> getSortedDate(String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        SearchRequest searchRequestTotalAssets = OpenSearchClientImpl.buildSearchRequest(scheduleTime, currentTime, null, team, chartType, indexName);
        SearchResponse searchResponseTotalAssets = this.client.search(searchRequestTotalAssets, RequestOptions.DEFAULT);
        DataInsightChartResult processedDataTotalAssets = OpenSearchClientImpl.processDataInsightChartResult(searchResponseTotalAssets, chartType);
        TreeMap<Long, List<Object>> dateWithDataMap = new TreeMap<Long, List<Object>>();
        for (Object data : processedDataTotalAssets.getData()) {
            DataInsightInterface convertedData = (DataInsightInterface)data;
            Long timestamp = convertedData.getTimestamp();
            List<Object> totalEntitiesByTypeList = new ArrayList<DataInsightInterface>();
            if (dateWithDataMap.containsKey(timestamp)) {
                totalEntitiesByTypeList = dateWithDataMap.get(timestamp);
            }
            totalEntitiesByTypeList.add(convertedData);
            dateWithDataMap.put(timestamp, totalEntitiesByTypeList);
        }
        return dateWithDataMap;
    }

    @Override
    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, String dataReportIndex) throws IOException, ParseException {
        SearchRequest searchRequest = OpenSearchClientImpl.buildSearchRequest(startTs, endTs, tier, team, dataInsightChartName, dataReportIndex);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)OpenSearchClientImpl.processDataInsightChartResult(searchResponse, dataInsightChartName)).build();
    }

    @Override
    public CollectionDAO getDao() {
        return this.dao;
    }

    private static DataInsightChartResult processDataInsightChartResult(SearchResponse searchResponse, DataInsightChartResult.DataInsightChartType dataInsightChartName) throws ParseException {
        DataInsightAggregatorInterface processor = OpenSearchClientImpl.createDataAggregator(searchResponse.getAggregations(), dataInsightChartName);
        return processor.process();
    }

    private static DataInsightAggregatorInterface createDataAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws IllegalArgumentException {
        switch (dataInsightChartType) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                return new OsEntitiesDescriptionAggregator(aggregations, dataInsightChartType);
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                return new OsEntitiesOwnerAggregator(aggregations, dataInsightChartType);
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                return new OsTotalEntitiesAggregator(aggregations, dataInsightChartType);
            }
            case TOTAL_ENTITIES_BY_TIER: {
                return new OsTotalEntitiesByTierAggregator(aggregations, dataInsightChartType);
            }
            case DAILY_ACTIVE_USERS: {
                return new OsDailyActiveUsersAggregator(aggregations, dataInsightChartType);
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                return new OsPageViewsByEntitiesAggregator(aggregations, dataInsightChartType);
            }
            case MOST_ACTIVE_USERS: {
                return new OsMostActiveUsersAggregator(aggregations, dataInsightChartType);
            }
            case MOST_VIEWED_ENTITIES: {
                return new OsMostViewedEntitiesAggregator(aggregations, dataInsightChartType);
            }
        }
        throw new IllegalArgumentException(String.format("No processor found for chart Type %s ", dataInsightChartType));
    }

    private static SearchRequest buildSearchRequest(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, String dataReportIndex) {
        SearchSourceBuilder searchSourceBuilder = OpenSearchClientImpl.buildQueryFilter(startTs, endTs, tier, team, dataInsightChartName.value());
        AggregationBuilder aggregationBuilder = OpenSearchClientImpl.buildQueryAggregation(dataInsightChartName);
        searchSourceBuilder.aggregation(aggregationBuilder);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        SearchRequest searchRequest = new SearchRequest(new String[]{dataReportIndex});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && DataInsightChartRepository.SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.team", teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && DataInsightChartRepository.SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.entityTier", tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTs).lte((Object)endTs);
        searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        return searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
    }

    private static AggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"timestamp").field("timestamp")).calendarInterval(DateHistogramInterval.DAY);
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"entityCount").field("data.entityCount");
        switch (dataInsightChartName) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TIER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityTier").field("data.entityTier")).missing((Object)"NoTier")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityFqn").field("data.entityFqn")).size(10).order(BucketOrder.aggregation((String)"pageViews", (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owner").field("data.owner");
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType");
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityHref").field("data.entityHref");
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"userName").field("data.userName")).size(10).order(BucketOrder.aggregation((String)"sessions", (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"team").field("data.team");
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessions").field("data.totalSessions");
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.totalPageView");
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastSession").field("data.lastSession");
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessionDuration").field("data.totalSessionDuration");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }

    public static RestHighLevelClient createOpenSearchClient(ElasticSearchConfiguration esConfig) {
        try {
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
            if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                SSLContext sslContext = IndexUtil.createElasticSearchSSLContext(esConfig);
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> OpenSearchClientImpl.lambda$createOpenSearchClient$2((CredentialsProvider)credentialsProvider, sslContext, arg_0));
            }
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
            return new RestHighLevelClient(restClientBuilder);
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed to create open search client ", (Throwable)e, new Object[0]);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createOpenSearchClient$2(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        return httpAsyncClientBuilder;
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, List.of());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

