/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(BotTokenCache.class);
    public static final String EMPTY_STRING = "";
    private static BotTokenCache instance;
    private static final LoadingCache<String, String> BOTS_TOKEN_CACHE;

    public String getToken(String botName) {
        try {
            if (((String)BOTS_TOKEN_CACHE.get((Object)botName)).equals(EMPTY_STRING)) {
                BOTS_TOKEN_CACHE.invalidate((Object)botName);
            }
            return (String)BOTS_TOKEN_CACHE.get((Object)botName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public void invalidateToken(String botName) {
        try {
            BOTS_TOKEN_CACHE.invalidate((Object)botName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate Bot token cache for Bot {}", (Object)botName, (Object)ex);
        }
    }

    public static BotTokenCache getInstance() {
        if (instance == null) {
            instance = new BotTokenCache();
        }
        return instance;
    }

    static {
        BOTS_TOKEN_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new BotTokenLoader());
    }

    static class BotTokenLoader
    extends CacheLoader<String, String> {
        BotTokenLoader() {
        }

        public String load(@CheckForNull String botName) throws IOException {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            User user = (User)userRepository.getByName(null, botName, new EntityUtil.Fields(Set.of("authenticationMechanism")), Include.NON_DELETED);
            AuthenticationMechanism authenticationMechanism = user.getAuthenticationMechanism();
            if (authenticationMechanism != null) {
                JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authenticationMechanism.getConfig(), JWTAuthMechanism.class);
                return jwtAuthMechanism.getJWTToken();
            }
            return null;
        }
    }
}

