/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogSecurityContext
implements SecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogSecurityContext.class);
    private final Principal principal;
    private final String scheme;
    private final String authenticationScheme;
    public static final String OPENID_AUTH = "openid";

    public CatalogSecurityContext(Principal principal, String scheme, String authenticationScheme) {
        this.principal = principal;
        this.scheme = scheme;
        this.authenticationScheme = authenticationScheme;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        LOG.debug("isUserInRole user: {}, role: {}", (Object)this.principal, (Object)role);
        return false;
    }

    public boolean isSecure() {
        return "https".equals(this.scheme);
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public String toString() {
        return "catalogSecurityContext{principal=" + this.principal + ", scheme='" + this.scheme + "', authenticationScheme='" + this.authenticationScheme + "', isSecure=" + this.isSecure() + "}";
    }
}

