/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.util.JsonPatchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationContext {
    private static final Logger LOG = LoggerFactory.getLogger(OperationContext.class);
    @NonNull
    private final String resource;
    List<MetadataOperation> operations;
    private JsonPatch patch;

    public OperationContext(@NonNull String resource, MetadataOperation ... operations) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
        this.operations = new ArrayList<MetadataOperation>();
        this.operations.addAll(List.of(operations));
    }

    public OperationContext(@NonNull String resource, JsonPatch patch) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
        this.patch = patch;
    }

    public List<MetadataOperation> getOperations() {
        if (this.operations != null) {
            return this.operations;
        }
        if (this.patch != null) {
            this.operations = new ArrayList<MetadataOperation>();
            this.operations.addAll(JsonPatchUtils.getMetadataOperations(this.patch));
            LOG.debug("Lazy initializing operations to {}", (Object)Arrays.toString(this.operations.toArray()));
        }
        return this.operations;
    }

    public static List<MetadataOperation> getAllOperations(MetadataOperation ... exclude) {
        return OperationContext.getOperations("", exclude);
    }

    public static boolean isEditOperation(MetadataOperation operation) {
        return operation.value().startsWith("Edit");
    }

    public static boolean isViewOperation(MetadataOperation operation) {
        return operation.value().startsWith("View");
    }

    public static List<MetadataOperation> getViewOperations(MetadataOperation ... exclude) {
        return OperationContext.getOperations("View", exclude);
    }

    public static List<MetadataOperation> getEditOperations(MetadataOperation ... exclude) {
        return OperationContext.getOperations("Edit", exclude);
    }

    private static List<MetadataOperation> getOperations(String startsWith, MetadataOperation ... exclude) {
        List list = CommonUtil.listOf((Object[])MetadataOperation.values());
        return OperationContext.getOperations(list, startsWith, exclude);
    }

    public static List<MetadataOperation> getOperations(String entityType, String startsWith, MetadataOperation ... exclude) {
        List list = ResourceRegistry.getResourceDescriptor(entityType).getOperations();
        return OperationContext.getOperations(list, startsWith, exclude);
    }

    private static List<MetadataOperation> getOperations(List<MetadataOperation> list, String startsWith, MetadataOperation ... exclude) {
        List excludeList = CommonUtil.listOf((Object[])exclude);
        if (!excludeList.isEmpty()) {
            list.remove(MetadataOperation.ALL);
        }
        for (MetadataOperation e : excludeList) {
            list.remove(e);
            if (OperationContext.isViewOperation(e)) {
                list.remove(MetadataOperation.VIEW_ALL);
                continue;
            }
            if (!OperationContext.isEditOperation(e)) continue;
            list.remove(MetadataOperation.EDIT_ALL);
        }
        return list.stream().filter(operation -> operation.value().startsWith(startsWith)).collect(Collectors.toList());
    }

    @NonNull
    public String getResource() {
        return this.resource;
    }

    public JsonPatch getPatch() {
        return this.patch;
    }
}

