/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.PolicyRepository;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyCache {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyCache.class);
    private static final PolicyCache INSTANCE = new PolicyCache();
    private static volatile boolean initialized = false;
    protected static LoadingCache<UUID, List<CompiledRule>> policyCache;
    private static PolicyRepository policyRepository;
    private static EntityUtil.Fields fields;

    public static PolicyCache getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!initialized) {
            policyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new PolicyLoader());
            policyRepository = (PolicyRepository)Entity.getEntityRepository("policy");
            fields = policyRepository.getFields("rules");
            initialized = true;
        }
    }

    public List<CompiledRule> getPolicyRules(UUID policyId) {
        try {
            return (List)policyCache.get((Object)policyId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public void invalidatePolicy(UUID policyId) {
        try {
            policyCache.invalidate((Object)policyId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for policy {}", (Object)policyId, (Object)ex);
        }
    }

    protected List<CompiledRule> getRules(Policy policy) {
        ArrayList<CompiledRule> rules = new ArrayList<CompiledRule>();
        for (Rule r : policy.getRules()) {
            rules.add(new CompiledRule(r));
        }
        return rules;
    }

    public static void cleanUp() {
        policyCache.cleanUp();
        initialized = false;
    }

    static class PolicyLoader
    extends CacheLoader<UUID, List<CompiledRule>> {
        PolicyLoader() {
        }

        public List<CompiledRule> load(@CheckForNull UUID policyId) throws IOException {
            Policy policy = (Policy)policyRepository.get(null, policyId, fields);
            LOG.info("Loaded policy {}:{}", (Object)policy.getName(), (Object)policy.getId());
            return PolicyCache.getInstance().getRules(policy);
        }
    }
}

