/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.RoleRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache {
    private static final Logger LOG = LoggerFactory.getLogger(RoleCache.class);
    private static final RoleCache INSTANCE = new RoleCache();
    private static volatile boolean initialized = false;
    protected static LoadingCache<String, Role> roleCache;
    protected static LoadingCache<UUID, Role> roleCacheWithId;
    private static RoleRepository roleRepository;
    private static EntityUtil.Fields fields;

    public static RoleCache getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!initialized) {
            roleCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new RoleLoader());
            roleCacheWithId = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new RoleLoaderWithId());
            roleRepository = (RoleRepository)Entity.getEntityRepository("role");
            fields = roleRepository.getFields("policies");
            initialized = true;
        }
    }

    public Role getRole(String roleName) {
        try {
            return (Role)roleCache.get((Object)roleName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("role", roleName));
        }
    }

    public Role getRoleById(UUID roleId) {
        try {
            return (Role)roleCacheWithId.get((Object)roleId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("role", roleId));
        }
    }

    public void invalidateRole(UUID roleId) {
        try {
            roleCacheWithId.invalidate((Object)roleId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for role {}", (Object)roleId, (Object)ex);
        }
    }

    public static void cleanUp() {
        roleCacheWithId.cleanUp();
        initialized = false;
    }

    static class RoleLoaderWithId
    extends CacheLoader<UUID, Role> {
        RoleLoaderWithId() {
        }

        public Role load(@CheckForNull UUID roleId) throws IOException {
            Role role = (Role)roleRepository.get(null, roleId, fields);
            LOG.info("Loaded role {}:{}", (Object)role.getName(), (Object)role.getId());
            return role;
        }
    }

    static class RoleLoader
    extends CacheLoader<String, Role> {
        RoleLoader() {
        }

        public Role load(@CheckForNull String roleName) throws IOException {
            Role role = (Role)roleRepository.getByName(null, roleName, fields);
            LOG.info("Loaded role {}:{}", (Object)role.getName(), (Object)role.getId());
            return role;
        }
    }
}

