/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.TeamRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectCache.class);
    private static SubjectCache instance;
    private static volatile boolean initialized;
    protected static LoadingCache<String, SubjectContext> userCache;
    protected static LoadingCache<UUID, SubjectContext> userCacheWihId;
    protected static LoadingCache<String, Team> teamCache;
    protected static LoadingCache<UUID, Team> teamCacheWithId;
    protected static UserRepository userRepository;
    protected static EntityUtil.Fields userFields;
    protected static TeamRepository teamRepository;
    protected static EntityUtil.Fields teamFields;

    public static void initialize() {
        if (!initialized) {
            userCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new UserLoader());
            userCacheWihId = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new UserLoaderWithId());
            teamCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new TeamLoader());
            teamCacheWithId = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new TeamLoaderWithId());
            userRepository = (UserRepository)Entity.getEntityRepository("user");
            userFields = userRepository.getFields("roles, teams, isAdmin, profile");
            teamRepository = (TeamRepository)Entity.getEntityRepository("team");
            teamFields = teamRepository.getFields("defaultRoles, policies, parents, profile");
            instance = new SubjectCache();
            initialized = true;
            LOG.info("Subject cache is initialized");
        } else {
            LOG.info("Subject cache is already initialized");
        }
    }

    public static SubjectCache getInstance() {
        return instance;
    }

    public SubjectContext getSubjectContext(String userName) throws EntityNotFoundException {
        try {
            return (SubjectContext)userCache.get((Object)userName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("user", userName));
        }
    }

    public SubjectContext getSubjectContext(UUID userId) throws EntityNotFoundException {
        try {
            return (SubjectContext)userCacheWihId.get((Object)userId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("user", userId));
        }
    }

    public User getUser(String userName) throws EntityNotFoundException {
        try {
            return ((SubjectContext)userCache.get((Object)userName)).getUser();
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("user", userName));
        }
    }

    public User getUserById(String userId) throws EntityNotFoundException {
        return this.getUserById(UUID.fromString(userId));
    }

    public User getUserById(UUID userId) throws EntityNotFoundException {
        try {
            return ((SubjectContext)userCacheWihId.get((Object)userId)).getUser();
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("user", userId));
        }
    }

    public Team getTeam(UUID teamId) throws EntityNotFoundException {
        try {
            return (Team)teamCacheWithId.get((Object)teamId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("team", teamId));
        }
    }

    public Team getTeamByName(String teamName) throws EntityNotFoundException {
        try {
            return (Team)teamCache.get((Object)teamName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("team", teamName));
        }
    }

    public boolean isInTeam(String parentTeam, EntityReference team) {
        ArrayDeque<EntityReference> stack = new ArrayDeque<EntityReference>();
        stack.push(team);
        while (!stack.isEmpty()) {
            Team parent = this.getTeam(((EntityReference)stack.pop()).getId());
            if (parent.getName().equals(parentTeam)) {
                return true;
            }
            CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
        }
        return false;
    }

    public boolean hasRole(User user, String role) {
        ArrayDeque stack = new ArrayDeque();
        if (SubjectCache.hasRole(user.getRoles(), role)) {
            return true;
        }
        CommonUtil.listOrEmpty((List)user.getTeams()).forEach(stack::push);
        while (!stack.isEmpty()) {
            Team parent = this.getTeam(((EntityReference)stack.pop()).getId());
            if (SubjectCache.hasRole(parent.getDefaultRoles(), role)) {
                return true;
            }
            CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
        }
        return false;
    }

    private static boolean hasRole(List<EntityReference> userRoles, String expectedRole) {
        return CommonUtil.listOrEmpty(userRoles).stream().anyMatch(userRole -> userRole.getName().equals(expectedRole));
    }

    public static void cleanUp() {
        LOG.info("Subject cache is cleaned up");
        userCache.invalidateAll();
        teamCacheWithId.invalidateAll();
        initialized = false;
    }

    public void invalidateUser(String userName) {
        try {
            userCache.invalidate((Object)userName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for user {}", (Object)userName, (Object)ex);
        }
    }

    public void invalidateTeam(UUID teamId) {
        try {
            teamCacheWithId.invalidate((Object)teamId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for team {}", (Object)teamId, (Object)ex);
        }
    }

    public List<EntityReference> getRolesForTeams(List<EntityReference> teams) {
        ArrayList<EntityReference> roles = new ArrayList<EntityReference>();
        for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
            Team team = this.getTeam(teamRef.getId());
            if (team == null) continue;
            roles.addAll(team.getDefaultRoles());
            roles.addAll(this.getRolesForTeams(team.getParents()));
        }
        return roles.stream().distinct().collect(Collectors.toList());
    }

    static {
        initialized = false;
    }

    static class TeamLoaderWithId
    extends CacheLoader<UUID, Team> {
        TeamLoaderWithId() {
        }

        public Team load(@NonNull UUID teamId) throws IOException {
            if (teamId == null) {
                throw new NullPointerException("teamId is marked non-null but is null");
            }
            Team team = (Team)teamRepository.get(null, teamId, teamFields);
            LOG.info("Loaded team {}:{}", (Object)team.getName(), (Object)team.getId());
            return team;
        }
    }

    static class TeamLoader
    extends CacheLoader<String, Team> {
        TeamLoader() {
        }

        public Team load(@CheckForNull String userName) throws IOException {
            Team team = teamRepository.getByName(null, userName, teamFields);
            LOG.info("Loaded user {}:{}", (Object)team.getName(), (Object)team.getId());
            return team;
        }
    }

    static class UserLoaderWithId
    extends CacheLoader<UUID, SubjectContext> {
        UserLoaderWithId() {
        }

        public SubjectContext load(@CheckForNull UUID uid) throws IOException {
            User user = (User)userRepository.get(null, uid, userFields);
            LOG.info("Loaded user {}:{}", (Object)user.getName(), (Object)user.getId());
            return new SubjectContext(user);
        }
    }

    static class UserLoader
    extends CacheLoader<String, SubjectContext> {
        UserLoader() {
        }

        public SubjectContext load(@CheckForNull String userName) throws IOException {
            User user = userRepository.getByName(null, EntityInterfaceUtil.quoteName((String)userName), userFields);
            LOG.info("Loaded user {}:{}", (Object)user.getName(), (Object)user.getId());
            return new SubjectContext(user);
        }
    }
}

