/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.formatter.decorators.FeedMessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public final class FeedUtils {
    private FeedUtils() {
    }

    public static List<Thread> getThreads(ChangeEvent changeEvent, String loggedInUserName) throws IOException {
        if (changeEvent == null || changeEvent.getEntity() == null) {
            return Collections.emptyList();
        }
        EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(changeEvent);
        MessageParser.EntityLink about = new MessageParser.EntityLink(changeEvent.getEntityType(), entityInterface.getFullyQualifiedName(), null, null, null);
        switch (changeEvent.getEventType()) {
            case ENTITY_CREATED: {
                String message = String.format("Created **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                return List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            case ENTITY_UPDATED: {
                return FeedUtils.getThreads(entityInterface, changeEvent.getChangeDescription(), loggedInUserName);
            }
            case ENTITY_SOFT_DELETED: {
                String message = String.format("Soft deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                return List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            case ENTITY_DELETED: {
                String message = String.format("Permanently Deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                return List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
        }
        if (entityInterface.getChangeDescription() == null) {
            return Collections.emptyList();
        }
        return FeedUtils.getThreads(entityInterface, entityInterface.getChangeDescription(), loggedInUserName);
    }

    private static List<Thread> getThreads(EntityInterface entity, ChangeDescription changeDescription, String loggedInUserName) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        FeedMessageDecorator feedFormatter = new FeedMessageDecorator();
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessages(feedFormatter, changeDescription, entity);
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            threads.add(FeedUtils.getThread(entry.getKey().getLinkString(), entry.getValue(), loggedInUserName));
        }
        return threads;
    }

    private static Thread getThread(String linkString, String message, String loggedInUserName) {
        return new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withCreatedBy(loggedInUserName).withAbout(linkString).withReactions(Collections.emptyList()).withUpdatedBy(loggedInUserName).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withMessage(message);
    }
}

